/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.testng.IInvokedMethod;
import org.testng.ISuite;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BaseMultiSuitePanel;
import org.testng.reporters.jq.Model;

public class ChronologicalPanel
extends BaseMultiSuitePanel {
    public ChronologicalPanel(Model model) {
        super(model);
    }

    @Override
    public String getPrefix() {
        return "chronological-";
    }

    @Override
    public String getHeader(ISuite iSuite) {
        return "Methods in chronological order";
    }

    @Override
    public String getContent(ISuite iSuite, XMLStringBuffer xMLStringBuffer) {
        XMLStringBuffer xMLStringBuffer2 = new XMLStringBuffer(xMLStringBuffer.getCurrentIndent());
        List<IInvokedMethod> list = iSuite.getAllInvokedMethods();
        Collections.sort(list, new Comparator<IInvokedMethod>(){

            @Override
            public int compare(IInvokedMethod iInvokedMethod, IInvokedMethod iInvokedMethod2) {
                return (int)(iInvokedMethod.getTestResult().getStartMillis() - iInvokedMethod2.getTestResult().getStartMillis());
            }
        });
        String string = "";
        long l = 0L;
        for (IInvokedMethod iInvokedMethod : list) {
            ITestNGMethod iTestNGMethod = iInvokedMethod.getTestMethod();
            String string2 = "test-method";
            if (iTestNGMethod.isBeforeSuiteConfiguration()) {
                string2 = "configuration-suite before";
            } else if (iTestNGMethod.isAfterSuiteConfiguration()) {
                string2 = "configuration-suite after";
            } else if (iTestNGMethod.isBeforeTestConfiguration()) {
                string2 = "configuration-test before";
            } else if (iTestNGMethod.isAfterTestConfiguration()) {
                string2 = "configuration-test after";
            } else if (iTestNGMethod.isBeforeClassConfiguration()) {
                string2 = "configuration-class before";
            } else if (iTestNGMethod.isAfterClassConfiguration()) {
                string2 = "configuration-class after";
            } else if (iTestNGMethod.isBeforeMethodConfiguration()) {
                string2 = "configuration-method before";
            } else if (iTestNGMethod.isAfterMethodConfiguration()) {
                string2 = "configuration-method after";
            }
            ITestResult iTestResult = iInvokedMethod.getTestResult();
            String string3 = Model.getTestResultName(iTestResult);
            if (!iTestNGMethod.getTestClass().getName().equals(string)) {
                if (!"".equals(string)) {
                    xMLStringBuffer2.pop("div");
                }
                xMLStringBuffer2.push("div", "class", "chronological-class");
                xMLStringBuffer2.addRequired("div", iTestNGMethod.getTestClass().getName(), "class", "chronological-class-name");
                string = iTestNGMethod.getTestClass().getName();
            }
            xMLStringBuffer2.push("div", "class", string2);
            if (iTestResult.getStatus() == 2) {
                xMLStringBuffer2.push("img", "src", Model.getImage("failed"));
                xMLStringBuffer2.pop("img");
            }
            xMLStringBuffer2.addRequired("span", string3, "class", "method-name");
            if (l == 0L) {
                l = iTestResult.getStartMillis();
            }
            xMLStringBuffer2.addRequired("span", Long.toString(iTestResult.getStartMillis() - l) + " ms", "class", "method-start");
            xMLStringBuffer2.pop("div");
        }
        return xMLStringBuffer2.toXML();
    }

    @Override
    public String getNavigatorLink(ISuite iSuite) {
        return "Chronological view";
    }
}

