/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.io.File;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.openfile.Bundle;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.spi.sendopts.Arg;
import org.netbeans.spi.sendopts.ArgsProcessor;
import org.netbeans.spi.sendopts.Description;
import org.netbeans.spi.sendopts.Env;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public final class Handler
implements ArgsProcessor {
    @Arg(longName="open", implicit=true)
    @Description(displayName="#MSG_OpenOptionDisplayName", shortDescription="#MSG_OpenOptionDescription")
    public String[] files;

    public void process(Env env) throws CommandException {
        String[] argv = this.files;
        if (argv == null || argv.length == 0) {
            throw new CommandException(2, Bundle.EXC_MissingArgOpen());
        }
        File curDir = env.getCurrentDirectory();
        StringBuffer failures = new StringBuffer();
        String sep = "";
        for (int i = 0; i < argv.length; ++i) {
            String error = this.openFile(curDir, env, argv[i]);
            if (error == null) continue;
            failures.append(sep);
            failures.append(error);
            sep = "\n";
        }
        if (failures.length() > 0) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)failures.toString()));
            throw new CommandException(1, failures.toString());
        }
    }

    private File findFile(File curDir, String name) {
        File f = new File(name);
        if (!f.isAbsolute()) {
            f = new File(curDir, name);
        }
        return f;
    }

    private String openFile(File curDir, Env args, String s) {
        int idx;
        int line = -1;
        File f = this.findFile(curDir, s);
        if (!f.exists() && (idx = s.lastIndexOf(58)) != -1) {
            try {
                line = Integer.parseInt(s.substring(idx + 1)) - 1;
                f = this.findFile(curDir, s.substring(0, idx));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return OpenFile.openFile(f, line);
    }
}

