/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.internal.MavenPluginConfigurationValidator;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMavenPluginParametersValidator
implements MavenPluginConfigurationValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    AbstractMavenPluginParametersValidator() {
    }

    protected boolean isValueSet(PlexusConfiguration config, ExpressionEvaluator expressionEvaluator) {
        if (config == null) {
            return false;
        }
        if (config.getChildCount() > 0) {
            return true;
        }
        String strValue = config.getValue();
        if (strValue == null || strValue.isEmpty()) {
            return false;
        }
        if (this.isIgnoredProperty(strValue)) {
            return false;
        }
        try {
            return expressionEvaluator.evaluate(strValue) != null;
        }
        catch (ExpressionEvaluationException expressionEvaluationException) {
            return false;
        }
    }

    @Override
    public final void validate(MojoDescriptor mojoDescriptor, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        if (!this.logger.isWarnEnabled()) {
            return;
        }
        this.doValidate(mojoDescriptor, pomConfiguration, expressionEvaluator);
    }

    protected abstract void doValidate(MojoDescriptor var1, PlexusConfiguration var2, ExpressionEvaluator var3);

    protected boolean isIgnoredProperty(String strValue) {
        return false;
    }

    protected abstract String getParameterLogReason(Parameter var1);

    protected void logParameter(Parameter parameter) {
        MessageBuilder messageBuilder = MessageUtils.buffer().warning((Object)"Parameter '").warning((Object)parameter.getName()).warning((Object)Character.valueOf('\''));
        if (parameter.getExpression() != null) {
            String userProperty = parameter.getExpression().replace("${", "'").replace('}', '\'');
            messageBuilder.warning((Object)" (user property ").warning((Object)userProperty).warning((Object)")");
        }
        messageBuilder.warning((Object)" ").warning((Object)this.getParameterLogReason(parameter));
        this.logger.warn(messageBuilder.toString());
    }
}

