/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.internal.AbstractMavenPluginDescriptorSourcedParametersValidator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

@Named
@Singleton
class ReadOnlyPluginParametersValidator
extends AbstractMavenPluginDescriptorSourcedParametersValidator {
    ReadOnlyPluginParametersValidator() {
    }

    @Override
    protected String getParameterLogReason(Parameter parameter) {
        return "is read-only, must not be used in configuration";
    }

    @Override
    protected void doValidate(MojoDescriptor mojoDescriptor, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        if (mojoDescriptor.getParameters() == null) {
            return;
        }
        mojoDescriptor.getParameters().stream().filter(parameter -> !parameter.isEditable()).forEach(parameter -> this.checkParameter((Parameter)parameter, pomConfiguration, expressionEvaluator));
    }

    private void checkParameter(Parameter parameter, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        PlexusConfiguration config = pomConfiguration.getChild(parameter.getName(), false);
        if (this.isValueSet(config, expressionEvaluator)) {
            this.logParameter(parameter);
        }
    }
}

