/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.TwoStateHoverProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.animator.AnimatorEvent;
import org.netbeans.api.visual.animator.AnimatorListener;
import org.netbeans.api.visual.export.SceneExporter;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.GraphLayoutFactory;
import org.netbeans.api.visual.graph.layout.GraphLayoutSupport;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.java.graph.Bundle;
import org.netbeans.modules.java.graph.CenteredZoomAnimator;
import org.netbeans.modules.java.graph.EdgeWidget;
import org.netbeans.modules.java.graph.FruchtermanReingoldLayout;
import org.netbeans.modules.java.graph.GraphEdge;
import org.netbeans.modules.java.graph.GraphNode;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.netbeans.modules.java.graph.HighlightVisitor;
import org.netbeans.modules.java.graph.NodeWidget;
import org.netbeans.modules.java.graph.SearchVisitor;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;

public class DependencyGraphScene<I extends GraphNodeImplementation>
extends GraphScene<GraphNode<I>, GraphEdge<I>> {
    private final VersionProvider versionProvider;
    private final ActionsProvider nodeActionProvider;
    private final HighlightDepthProvider highlightProvider;
    private final PaintingProvider<I> paintingProvider;
    private LayerWidget mainLayer;
    private final LayerWidget connectionLayer;
    private GraphNode rootNode;
    private final AllActionsProvider allActionsP = new AllActionsProvider();
    private final WidgetAction moveAction = ActionFactory.createMoveAction(null, (MoveProvider)this.allActionsP);
    private final WidgetAction popupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)this.allActionsP);
    private final WidgetAction zoomAction = ActionFactory.createMouseCenteredZoomAction((double)1.1);
    private final WidgetAction panAction = ActionFactory.createPanAction();
    private final WidgetAction editAction = ActionFactory.createEditAction((EditProvider)this.allActionsP);
    private final WidgetAction hoverAction = ActionFactory.createHoverAction((TwoStateHoverProvider)new HoverController());
    private final Action sceneZoomToFitAction = new SceneZoomToFitAction();
    private final Action highlitedZoomToFitAction = new HighlightedZoomToFitAction();
    private FruchtermanReingoldLayout layout;
    private int maxDepth = 0;
    private FitToViewLayout fitViewL;
    private static final Set<GraphNode> EMPTY_SELECTION = new HashSet<GraphNode>();
    private JScrollPane pane;
    private final AtomicBoolean animated = new AtomicBoolean(false);
    private HighlightVisitor highlightV;

    public DependencyGraphScene(JScrollPane pane) {
        this(null, null, null, null);
    }

    public DependencyGraphScene(ActionsProvider<I> nodeActionProvider, HighlightDepthProvider highlightProvider, VersionProvider<I> versionProvider, PaintingProvider<I> paintingProvider) {
        this.nodeActionProvider = nodeActionProvider;
        this.highlightProvider = highlightProvider;
        this.versionProvider = versionProvider;
        this.paintingProvider = paintingProvider;
        this.mainLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.mainLayer);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.connectionLayer);
        LayerWidget glasspane = new LayerWidget((Scene)this){

            protected void paintChildren() {
                if (this.isCheckClipping()) {
                    Rectangle clipBounds = DependencyGraphScene.this.getGraphics().getClipBounds();
                    for (Widget child : DependencyGraphScene.this.mainLayer.getChildren()) {
                        Point location = child.getLocation();
                        Rectangle bounds = child.getBounds();
                        bounds.translate(location.x, location.y);
                        if (clipBounds != null && !bounds.intersects(clipBounds)) continue;
                        child.paint();
                    }
                } else {
                    for (Widget child : DependencyGraphScene.this.mainLayer.getChildren()) {
                        child.paint();
                    }
                }
            }
        };
        this.addChild((Widget)glasspane);
        this.getActions().addAction(this.hoverAction);
        this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)this.allActionsP));
        this.getActions().addAction(this.zoomAction);
        this.getActions().addAction(this.panAction);
        this.getActions().addAction(this.editAction);
        this.getActions().addAction(this.popupMenuAction);
    }

    boolean isVisible(GraphEdge<I> e) {
        return this.paintingProvider == null || this.paintingProvider.isVisible(e.getSource(), e.getTarget());
    }

    boolean isVisible(GraphNode<I> n) {
        return this.paintingProvider == null || this.paintingProvider.isVisible(n.getImpl());
    }

    Stroke getStroke(GraphEdge<I> e) {
        return this.paintingProvider != null ? this.paintingProvider.getStroke(e.getSource(), e.getTarget()) : null;
    }

    Color getColor(GraphNode<I> n) {
        return this.paintingProvider != null ? this.paintingProvider.getColor(n.getImpl()) : null;
    }

    Icon getIcon(GraphNode<I> n) {
        return this.paintingProvider != null ? this.paintingProvider.getIcon(n.getImpl()) : null;
    }

    public void addGraphNodeImpl(I d) {
        super.addNode(new GraphNode<I>(d));
    }

    public GraphEdge addEdge(I source, I target) {
        Collection nodes = this.getNodes();
        GraphNode<I> s = this.getGraphNode(nodes, source);
        assert (s != null);
        GraphNode<I> t = this.getGraphNode(nodes, target);
        assert (t != null);
        GraphEdge<I> edge = new GraphEdge<I>(source, target);
        this.addEdge(edge);
        this.setEdgeSource(edge, s);
        this.setEdgeTarget(edge, t);
        return edge;
    }

    private GraphNode<I> getGraphNode(Collection<GraphNode<I>> nodes, I i) {
        for (GraphNode<I> n : nodes) {
            if (!n.getImpl().equals(i)) continue;
            return n;
        }
        assert (false) : "no node found for " + i.getName();
        return null;
    }

    public void setSearchString(String val) {
        SearchVisitor visitor = new SearchVisitor(this);
        visitor.setSearchString(val);
        visitor.accept(this.getRootGraphNode().getImpl());
        this.validate();
        this.repaint();
        this.revalidate();
        this.repaint();
    }

    public void notifyModelChanged(GraphNode<I> graphNode) {
        NodeWidget nodeWidget = (NodeWidget)this.findWidget(graphNode);
        if (nodeWidget != null) {
            nodeWidget.modelChanged();
        }
    }

    public void notifyModelChanged(GraphEdge<I> graphEdge) {
        EdgeWidget edgeWidget = (EdgeWidget)this.findWidget(graphEdge);
        if (edgeWidget != null) {
            edgeWidget.modelChanged();
        }
    }

    boolean supportsVersions() {
        return this.versionProvider != null;
    }

    public boolean isIncluded(I node) {
        if (!this.supportsVersions()) {
            return true;
        }
        assert (this.versionProvider != null);
        return this.versionProvider.isIncluded(node);
    }

    boolean isConflict(I node) {
        if (!this.supportsVersions()) {
            return false;
        }
        assert (this.versionProvider != null);
        return this.versionProvider.isOmmitedForConflict(node);
    }

    String getVersion(I impl) {
        assert (this.versionProvider != null);
        return this.versionProvider.getVersion(impl);
    }

    int compareVersions(I n1, I n2) {
        assert (this.versionProvider != null);
        return this.versionProvider.compareVersions(n1, n2);
    }

    public void setMyZoomFactor(double zoom) {
        this.setZoomFactor(zoom);
        ArrayList arr = new ArrayList();
        arr.addAll(this.mainLayer.getChildren());
        arr.addAll(this.connectionLayer.getChildren());
        for (Widget wid : arr) {
            if (wid instanceof NodeWidget) {
                ((NodeWidget)wid).updateReadableZoom();
            }
            if (!(wid instanceof EdgeWidget)) continue;
            ((EdgeWidget)wid).updateReadableZoom();
        }
    }

    public void initialLayout() {
        this.layout = new FruchtermanReingoldLayout(this, this.pane);
        this.layout.invokeLayout();
        this.addSceneListener(new Scene.SceneListener(){

            public void sceneRepaint() {
            }

            public void sceneValidating() {
            }

            public void sceneValidated() {
                if (DependencyGraphScene.this.animated.compareAndSet(false, true)) {
                    new SceneZoomToFitAction().actionPerformed(null);
                }
            }
        });
    }

    public void setSurroundingScrollPane(JScrollPane pane) {
        this.pane = pane;
    }

    public GraphNode<I> getRootGraphNode() {
        return this.rootNode;
    }

    public int getMaxNodeDepth() {
        return this.maxDepth;
    }

    boolean isAnimated() {
        return this.animated.get();
    }

    @CheckForNull
    public GraphNode getGraphNodeRepresentant(GraphNodeImplementation impl) {
        for (GraphNode grnode : this.getNodes()) {
            if (grnode.getImpl().equals(impl)) {
                return grnode;
            }
            if (!this.supportsVersions() || !grnode.represents(impl)) continue;
            return grnode;
        }
        return null;
    }

    protected Widget attachNodeWidget(GraphNode node) {
        if (this.rootNode == null) {
            this.rootNode = node;
        }
        if (node.getPrimaryLevel() > this.maxDepth) {
            this.maxDepth = node.getPrimaryLevel();
        }
        Action fixAction = this.nodeActionProvider != null ? this.nodeActionProvider.createFixVersionConflictAction(this, this.rootNode, node) : null;
        NodeWidget root = new NodeWidget(this, node, fixAction, this.hoverAction);
        this.mainLayer.addChild(root);
        root.setOpaque(true);
        root.getActions().addAction(this.createObjectHoverAction());
        root.getActions().addAction(this.createSelectAction());
        root.getActions().addAction(this.moveAction);
        root.getActions().addAction(this.editAction);
        root.getActions().addAction(this.popupMenuAction);
        return root;
    }

    protected Widget attachEdgeWidget(GraphEdge edge) {
        EdgeWidget connectionWidget = new EdgeWidget(this, edge);
        this.connectionLayer.addChild(connectionWidget);
        return connectionWidget;
    }

    protected void attachEdgeSourceAnchor(GraphEdge edge, GraphNode oldsource, GraphNode source) {
        ((ConnectionWidget)this.findWidget(edge)).setSourceAnchor(AnchorFactory.createRectangularAnchor((Widget)this.findWidget(source)));
    }

    protected void attachEdgeTargetAnchor(GraphEdge edge, GraphNode oldtarget, GraphNode target) {
        NodeWidget wid = (NodeWidget)this.findWidget(target);
        ((ConnectionWidget)this.findWidget(edge)).setTargetAnchor(AnchorFactory.createRectangularAnchor((Widget)wid));
    }

    public void updateVisibility() {
        this.getEdges().stream().forEach(edge -> ((EdgeWidget)this.findWidget(edge)).updateAppearance(true));
        this.getNodes().stream().forEach(node -> ((NodeWidget)this.findWidget(node)).updatePaintContent());
    }

    public void calculatePrimaryPathsAndLevels() {
        Collection ns = this.getNodes();
        for (GraphNode n : ns) {
            ArrayList<GraphEdge> primaryPathEdges = new ArrayList<GraphEdge>();
            LinkedList<GraphNode> importantNodes = new LinkedList<GraphNode>();
            this.addPathToRoot(n, primaryPathEdges, importantNodes);
            for (GraphEdge pe : primaryPathEdges) {
                pe.setPrimaryPath(true);
            }
            int level = primaryPathEdges.size();
            n.setPrimaryLevel(level);
            if (level <= this.maxDepth) continue;
            this.maxDepth = level;
        }
    }

    void highlightRelated(GraphNode<I> node) {
        ArrayList<GraphNode> importantNodes = new ArrayList<GraphNode>();
        ArrayList<GraphEdge> otherPathsEdges = new ArrayList<GraphEdge>();
        ArrayList<GraphEdge> primaryPathEdges = new ArrayList<GraphEdge>();
        ArrayList<GraphNode> childrenNodes = new ArrayList<GraphNode>();
        ArrayList childrenEdges = new ArrayList();
        importantNodes.add(node);
        List children = node.getImpl().getChildren();
        if (children != null) {
            for (GraphNodeImplementation n : children) {
                GraphNode child = this.getGraphNodeRepresentant(n);
                if (child == null) continue;
                childrenNodes.add(child);
            }
        }
        childrenEdges.addAll(this.findNodeEdges(node, true, false));
        this.addPathToRoot(node, primaryPathEdges, importantNodes);
        if (this.supportsVersions()) {
            for (Object curRep : node.getDuplicatesOrConflicts()) {
                this.addPathToRoot((GraphNodeImplementation)curRep, (GraphNodeImplementation)curRep.getParent(), (List<GraphEdge>)otherPathsEdges, (List<GraphNode>)importantNodes);
            }
        }
        for (GraphEdge curE : this.getEdges()) {
            EdgeWidget ew = (EdgeWidget)this.findWidget(curE);
            if (primaryPathEdges.contains(curE)) {
                ew.setState(4);
                continue;
            }
            if (otherPathsEdges.contains(curE)) {
                ew.setState(3);
                continue;
            }
            if (childrenEdges.contains(curE)) {
                ew.setState(1);
                continue;
            }
            ew.setState(0);
        }
        for (GraphNode curN : this.getNodes()) {
            NodeWidget aw = (NodeWidget)this.findWidget(curN);
            if (importantNodes.contains(curN)) {
                aw.setPaintState(2);
                aw.setReadable(true);
                continue;
            }
            if (childrenNodes.contains(curN)) {
                aw.setPaintState(2);
                aw.setReadable(true);
                continue;
            }
            aw.setPaintState(0);
            aw.setReadable(false);
        }
    }

    private void addPathToRoot(GraphNode node, List<GraphEdge> edges, List<GraphNode> nodes) {
        Object parentImpl = node.getParent();
        this.addPathToRoot((GraphNodeImplementation)node.getImpl(), (GraphNodeImplementation)parentImpl, edges, nodes);
    }

    private void addPathToRoot(GraphNodeImplementation impl, GraphNodeImplementation parentImpl, List<GraphEdge> edges, List<GraphNode> nodes) {
        HashSet<GraphNodeImplementation> seen = new HashSet<GraphNodeImplementation>();
        while (parentImpl != null) {
            seen.add(parentImpl);
            GraphNode grNode = this.getGraphNodeRepresentant(parentImpl);
            if (grNode == null) {
                return;
            }
            GraphNode targetNode = this.getGraphNodeRepresentant(impl);
            if (targetNode == null) {
                return;
            }
            edges.addAll(this.findEdgesBetween(grNode, targetNode));
            nodes.add(grNode);
            impl = parentImpl;
            parentImpl = grNode.getParent();
            if (!seen.contains(parentImpl)) continue;
            parentImpl = null;
        }
    }

    public void highlightDepth(int depth) {
        assert (depth > -1 || this.highlightProvider != null) : "using depth highlighting without providing HighlightProvider in c'tor no allowed";
        if (depth == -1) {
            depth = 0;
        }
        if (this.highlightV == null) {
            this.highlightV = new HighlightVisitor(this);
        }
        this.highlightV.setMaxDepth(depth);
        this.highlightV.accept(this.getRootGraphNode().getImpl());
        this.validate();
        this.repaint();
    }

    public void resetHighlight() {
        this.highlightV = null;
    }

    private void highlightDepthIntern() {
        int depth = this.highlightProvider == null ? -1 : this.highlightProvider.getDepth();
        this.highlightDepth(depth);
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        super.notifyStateChanged(previousState, state);
        if (!previousState.isSelected() && state.isSelected()) {
            this.highlightDepthIntern();
        }
    }

    private FitToViewLayout getFitToViewLayout() {
        if (this.fitViewL == null) {
            this.fitViewL = new FitToViewLayout(this, this.pane);
        }
        return this.fitViewL;
    }

    void fitToZoomAfterLayout() {
        this.getSceneAnimator().getPreferredLocationAnimator().addAnimatorListener(new AnimatorListener(){

            public void animatorStarted(AnimatorEvent event) {
            }

            public void animatorReset(AnimatorEvent event) {
            }

            public void animatorFinished(AnimatorEvent event) {
                DependencyGraphScene.this.getSceneAnimator().getPreferredLocationAnimator().removeAnimatorListener((AnimatorListener)this);
                new SceneZoomToFitAction().actionPerformed(null);
            }

            public void animatorPreTick(AnimatorEvent event) {
            }

            public void animatorPostTick(AnimatorEvent event) {
            }
        });
    }

    private class FruchtermanReingoldLayoutAction
    extends AbstractAction {
        FruchtermanReingoldLayoutAction() {
            this.putValue("Name", Bundle.ACT_Layout_FruchtermanReingoldLayout());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DependencyGraphScene.this.layout.invokeLayout();
            DependencyGraphScene.this.fitToZoomAfterLayout();
        }
    }

    private class TreeGraphLayoutHorizontalAction
    extends AbstractAction {
        TreeGraphLayoutHorizontalAction() {
            this.putValue("Name", Bundle.ACT_Layout_TreeGraphLayoutHorizontal());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphLayout layout = GraphLayoutFactory.createTreeGraphLayout((int)10, (int)10, (int)50, (int)50, (boolean)false);
            GraphLayoutSupport.setTreeGraphLayoutRootNode((GraphLayout)layout, (Object)DependencyGraphScene.this.rootNode);
            layout.layoutGraph((GraphScene)DependencyGraphScene.this);
            DependencyGraphScene.this.fitToZoomAfterLayout();
        }
    }

    private class TreeGraphLayoutVerticalAction
    extends AbstractAction {
        TreeGraphLayoutVerticalAction() {
            this.putValue("Name", Bundle.ACT_Layout_TreeGraphLayoutVertical());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphLayout layout = GraphLayoutFactory.createTreeGraphLayout((int)10, (int)10, (int)50, (int)50, (boolean)true);
            GraphLayoutSupport.setTreeGraphLayoutRootNode((GraphLayout)layout, (Object)DependencyGraphScene.this.rootNode);
            layout.layoutGraph((GraphScene)DependencyGraphScene.this);
            DependencyGraphScene.this.fitToZoomAfterLayout();
        }
    }

    private class HierarchicalGraphLayoutAction
    extends AbstractAction {
        HierarchicalGraphLayoutAction() {
            this.putValue("Name", Bundle.ACT_Layout_HierarchicalGraphLayout());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphLayout layout = GraphLayoutFactory.createHierarchicalGraphLayout((GraphScene)DependencyGraphScene.this, (boolean)DependencyGraphScene.this.isAnimated(), (boolean)false);
            layout.layoutGraph((GraphScene)DependencyGraphScene.this);
            DependencyGraphScene.this.fitToZoomAfterLayout();
        }
    }

    private static class HoverController
    implements TwoStateHoverProvider {
        private HoverController() {
        }

        public void unsetHovering(Widget widget) {
            NodeWidget aw = this.findArtifactW(widget);
            if (widget != null) {
                aw.bulbUnhovered();
            }
        }

        public void setHovering(Widget widget) {
            NodeWidget aw = this.findArtifactW(widget);
            if (aw != null) {
                aw.bulbHovered();
            }
        }

        private NodeWidget findArtifactW(Widget w) {
            while (w != null && !(w instanceof NodeWidget)) {
                w = w.getParentWidget();
            }
            return (NodeWidget)w;
        }
    }

    private class HighlightedZoomToFitAction
    extends AbstractAction {
        HighlightedZoomToFitAction() {
            this.putValue("Name", Bundle.ACT_ZoomToFit());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection grNodes = DependencyGraphScene.this.getNodes();
            ArrayList<NodeWidget> aws = new ArrayList<NodeWidget>();
            NodeWidget aw = null;
            for (GraphNode grNode : grNodes) {
                aw = (NodeWidget)DependencyGraphScene.this.findWidget(grNode);
                int paintState = aw.getPaintState();
                if (paintState == 0 || paintState == 1) continue;
                aws.add(aw);
            }
            DependencyGraphScene.this.getFitToViewLayout().fitToView(aws);
        }
    }

    private class SceneZoomToFitAction
    extends AbstractAction {
        SceneZoomToFitAction() {
            this.putValue("Name", Bundle.ACT_ZoomToFit());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DependencyGraphScene.this.getFitToViewLayout().fitToView(null);
        }
    }

    private static class FitToViewLayout
    extends SceneLayout {
        private final DependencyGraphScene depScene;
        private List<? extends Widget> widgets;
        private final JScrollPane parentScrollPane;

        FitToViewLayout(DependencyGraphScene scene, JScrollPane parentScrollPane) {
            super((Scene)scene);
            this.depScene = scene;
            this.parentScrollPane = parentScrollPane;
        }

        protected void fitToView(@NullAllowed List<? extends Widget> widgets) {
            this.widgets = widgets;
            this.invokeLayout();
        }

        protected void performLayout() {
            List toFit;
            Rectangle rectangle = null;
            List list = toFit = this.widgets != null ? this.widgets : this.depScene.getChildren();
            if (toFit == null) {
                return;
            }
            for (Widget widget : toFit) {
                Rectangle bounds = widget.getBounds();
                if (bounds == null) continue;
                if (rectangle == null) {
                    rectangle = widget.convertLocalToScene(bounds);
                    continue;
                }
                rectangle = rectangle.union(widget.convertLocalToScene(bounds));
            }
            if (this.widgets == null) {
                rectangle.grow(5, 5);
            } else {
                rectangle.grow(25, 25);
            }
            Dimension dim = rectangle.getSize();
            Dimension viewDim = this.parentScrollPane.getViewportBorderBounds().getSize();
            double zf = Math.min((double)viewDim.width / (double)dim.width, (double)viewDim.height / (double)dim.height);
            if (this.depScene.isAnimated()) {
                if (this.widgets == null) {
                    this.depScene.getSceneAnimator().animateZoomFactor(zf);
                } else {
                    CenteredZoomAnimator cza = new CenteredZoomAnimator(this.depScene.getSceneAnimator());
                    cza.setZoomFactor(zf, new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY()));
                }
            } else {
                this.depScene.setMyZoomFactor(zf);
            }
        }
    }

    private class AllActionsProvider
    implements PopupMenuProvider,
    MoveProvider,
    EditProvider,
    SelectProvider {
        private Point moveStart;

        private AllActionsProvider() {
        }

        public JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
            JPopupMenu popupMenu = new JPopupMenu();
            if (widget == DependencyGraphScene.this) {
                popupMenu.add(DependencyGraphScene.this.sceneZoomToFitAction);
                JMenu layoutMenu = new JMenu(Bundle.ACT_LayoutSubMenu());
                popupMenu.add(layoutMenu);
                layoutMenu.add(new FruchtermanReingoldLayoutAction());
                layoutMenu.add(new JSeparator());
                layoutMenu.add(new HierarchicalGraphLayoutAction());
                layoutMenu.add(new TreeGraphLayoutVerticalAction());
                layoutMenu.add(new TreeGraphLayoutHorizontalAction());
                popupMenu.add(new AbstractAction(Bundle.ACT_Export_As_Image()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File file = new FileChooserBuilder("DependencyGraphScene-ExportDir").setTitle(Bundle.ACT_Export_As_Image_Title()).setAcceptAllFileFilterUsed(false).addFileFilter((FileFilter)new FileNameExtensionFilter("PNG file", "png")).showSaveDialog();
                        if (file != null) {
                            try {
                                DependencyGraphScene theScene = DependencyGraphScene.this;
                                SceneExporter.createImage((Scene)theScene, (File)file, (SceneExporter.ImageType)SceneExporter.ImageType.PNG, (SceneExporter.ZoomType)SceneExporter.ZoomType.CURRENT_ZOOM_LEVEL, (boolean)false, (boolean)false, (int)-1, (int)-1, (int)-1);
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
            } else if (DependencyGraphScene.this.nodeActionProvider != null) {
                GraphNode node = (GraphNode)DependencyGraphScene.this.findObject(widget);
                boolean addSeparator = false;
                Action a = DependencyGraphScene.this.nodeActionProvider.createFixVersionConflictAction(DependencyGraphScene.this, DependencyGraphScene.this.rootNode, node);
                if (a != null) {
                    popupMenu.add(a);
                    addSeparator = true;
                }
                if ((a = DependencyGraphScene.this.nodeActionProvider.createExcludeDepAction(DependencyGraphScene.this, DependencyGraphScene.this.rootNode, node)) != null) {
                    popupMenu.add(a);
                    addSeparator = true;
                }
                if (addSeparator) {
                    popupMenu.add(new JSeparator());
                }
                popupMenu.add(DependencyGraphScene.this.highlitedZoomToFitAction);
                if (!node.isRoot() && (a = DependencyGraphScene.this.nodeActionProvider.createShowGraphAction(node)) != null) {
                    popupMenu.add(a);
                }
            }
            return popupMenu;
        }

        public void movementStarted(Widget widget) {
            widget.bringToFront();
            this.moveStart = widget.getLocation();
        }

        public void movementFinished(Widget widget) {
            Object obj;
            Point moveEnd = widget.getLocation();
            if (this.moveStart.distance(moveEnd) < 5.0 && (obj = DependencyGraphScene.this.findObject(widget)) instanceof GraphNode) {
                DependencyGraphScene.this.highlightRelated((GraphNode)obj);
            }
        }

        public Point getOriginalLocation(Widget widget) {
            return widget.getPreferredLocation();
        }

        public void setNewLocation(Widget widget, Point location) {
            widget.setPreferredLocation(location);
        }

        public void edit(Widget widget) {
            if (DependencyGraphScene.this == widget) {
                DependencyGraphScene.this.sceneZoomToFitAction.actionPerformed(null);
            } else {
                DependencyGraphScene.this.highlitedZoomToFitAction.actionPerformed(null);
            }
        }

        public boolean isAimingAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return true;
        }

        public void select(Widget widget, Point localLocation, boolean invertSelection) {
            DependencyGraphScene.this.setSelectedObjects(EMPTY_SELECTION);
            DependencyGraphScene.this.highlightDepthIntern();
        }
    }

    public static interface ActionsProvider<I extends GraphNodeImplementation> {
        public Action createFixVersionConflictAction(DependencyGraphScene var1, GraphNode<I> var2, GraphNode<I> var3);

        public Action createExcludeDepAction(DependencyGraphScene var1, GraphNode<I> var2, GraphNode<I> var3);

        public Action createShowGraphAction(GraphNode<I> var1);
    }

    public static interface VersionProvider<I extends GraphNodeImplementation> {
        public static final int VERSION_NO_CONFLICT = 0;
        public static final int VERSION_POTENTIAL_CONFLICT = 1;
        public static final int VERSION_CONFLICT = 2;

        public String getVersion(I var1);

        public int compareVersions(I var1, I var2);

        public boolean isIncluded(I var1);

        public boolean isOmmitedForConflict(I var1);
    }

    public static interface HighlightDepthProvider {
        public int getDepth();
    }

    public static interface PaintingProvider<I extends GraphNodeImplementation> {
        public Icon getIcon(I var1);

        public boolean isVisible(I var1);

        public boolean isVisible(I var1, I var2);

        public Color getColor(I var1);

        public Stroke getStroke(I var1, I var2);
    }
}

