/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.jstestdriver;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.jstestdriver.preferences.JsTestDriverPreferences;
import org.netbeans.modules.javascript.jstestdriver.preferences.JsTestDriverPreferencesValidator;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.spi.ImportantFilesImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public final class ImportantFilesImpl
implements ImportantFilesImplementation,
PreferenceChangeListener {
    private final Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    private ImportantFilesImpl(Project project) {
        assert (project != null);
        this.project = project;
    }

    public static ImportantFilesImplementation createImportantFiles(Project project) {
        ImportantFilesImpl importantFiles = new ImportantFilesImpl(project);
        JsTestDriverPreferences.addPreferenceChangeListener(project, (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)importantFiles, JsTestDriverPreferences.class));
        return importantFiles;
    }

    public Collection<ImportantFilesImplementation.FileInfo> getFiles() {
        String config = JsTestDriverPreferences.getConfig(this.project);
        ValidationResult result = new JsTestDriverPreferencesValidator().validateConfig(config).getResult();
        if (!result.isFaultless()) {
            return Collections.emptyList();
        }
        FileObject file = FileUtil.toFileObject((File)new File(config));
        assert (file != null) : config;
        return Collections.singleton(new ImportantFilesImplementation.FileInfo(file));
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if ("config".equals(evt.getKey())) {
            this.changeSupport.fireChange();
        }
    }
}

