/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.annotate;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.versioning.annotate.AnnotationBar;
import org.netbeans.modules.versioning.annotate.AnnotationBarManager;
import org.netbeans.modules.versioning.annotate.VcsAnnotations;
import org.netbeans.modules.versioning.annotate.VcsAnnotationsProvider;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class VcsAnnotateAction
extends AbstractAction {
    private final VcsAnnotationsProvider provider;
    private final Collection<? extends Node> nodes;

    public VcsAnnotateAction(VCSContext context, VcsAnnotationsProvider provider) {
        this.provider = provider;
        this.nodes = context.getElements().lookupAll(Node.class);
        this.putValue("Name", this.cumputeActionName());
    }

    @Override
    public boolean isEnabled() {
        return this.activatedEditorCookie() != null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.visible()) {
            JEditorPane pane = this.activatedEditorPane();
            AnnotationBarManager.hideAnnotationBar(pane);
        } else {
            EditorCookie ec = this.activatedEditorCookie();
            if (ec == null) {
                return;
            }
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes == null) {
                ec.open();
            }
            if ((panes = ec.getOpenedPanes()) == null) {
                return;
            }
            JEditorPane currentPane = panes[0];
            AnnotationBar ab = AnnotationBarManager.showAnnotationBar(currentPane);
            ab.setAnnotationMessage(NbBundle.getMessage(VcsAnnotateAction.class, (String)"CTL_AnnotationSubstitute"));
            this.computeAnnotationsAsync(ab);
        }
    }

    private void computeAnnotationsAsync(final AnnotationBar ab) {
        Utils.postParallel(new Runnable(){

            @Override
            public void run() {
                VcsAnnotateAction.this.computeAnnotations(ab);
            }
        }, 0);
    }

    private void computeAnnotations(AnnotationBar ab) {
        VcsAnnotations annotations = this.provider.getAnnotations();
        File file = new File("");
        ab.annotationLines(file, annotations);
    }

    private String cumputeActionName() {
        if (this.visible()) {
            return NbBundle.getMessage(VcsAnnotateAction.class, (String)"Action_HideAnnotations");
        }
        return NbBundle.getMessage(VcsAnnotateAction.class, (String)"Action_ShowAnnotations");
    }

    public boolean visible() {
        JEditorPane currentPane = this.activatedEditorPane();
        return AnnotationBarManager.annotationBarVisible(currentPane);
    }

    private JEditorPane activatedEditorPane() {
        JEditorPane[] panes;
        EditorCookie ec = this.activatedEditorCookie();
        if (ec != null && SwingUtilities.isEventDispatchThread() && (panes = ec.getOpenedPanes()) != null && panes.length > 0) {
            return panes[0];
        }
        return null;
    }

    private EditorCookie activatedEditorCookie() {
        if (this.nodes != null && this.nodes.size() == 1) {
            Node node = this.nodes.iterator().next();
            return (EditorCookie)node.getCookie(EditorCookie.class);
        }
        return null;
    }
}

