/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Multiset;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public final class DisjunctionMaxQuery
extends Query
implements Iterable<Query> {
    private final Multiset<Query> disjuncts = new Multiset();
    private final float tieBreakerMultiplier;

    public DisjunctionMaxQuery(Collection<Query> disjuncts, float tieBreakerMultiplier) {
        Objects.requireNonNull(disjuncts, "Collection of Querys must not be null");
        if (tieBreakerMultiplier < 0.0f || tieBreakerMultiplier > 1.0f) {
            throw new IllegalArgumentException("tieBreakerMultiplier must be in [0, 1]");
        }
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.disjuncts.addAll(disjuncts);
    }

    @Override
    public Iterator<Query> iterator() {
        return this.getDisjuncts().iterator();
    }

    public Collection<Query> getDisjuncts() {
        return Collections.unmodifiableCollection(this.disjuncts);
    }

    public float getTieBreakerMultiplier() {
        return this.tieBreakerMultiplier;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new DisjunctionMaxWeight(searcher, scoreMode, boost);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.disjuncts.isEmpty()) {
            return new MatchNoDocsQuery("empty DisjunctionMaxQuery");
        }
        if (this.disjuncts.size() == 1) {
            return this.disjuncts.iterator().next();
        }
        if (this.tieBreakerMultiplier == 1.0f) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (Query sub : this.disjuncts) {
                builder.add(sub, BooleanClause.Occur.SHOULD);
            }
            return builder.build();
        }
        boolean actuallyRewritten = false;
        ArrayList<Query> rewrittenDisjuncts = new ArrayList<Query>();
        for (Query sub : this.disjuncts) {
            Query rewrittenSub = sub.rewrite(indexSearcher);
            actuallyRewritten |= rewrittenSub != sub;
            rewrittenDisjuncts.add(rewrittenSub);
        }
        if (actuallyRewritten) {
            return new DisjunctionMaxQuery(rewrittenDisjuncts, this.tieBreakerMultiplier);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, this);
        for (Query q : this.disjuncts) {
            q.visit(v);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        Iterator<Query> it = this.disjuncts.iterator();
        int i = 0;
        while (it.hasNext()) {
            Query subquery = it.next();
            if (subquery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subquery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subquery.toString(field));
            }
            if (i != this.disjuncts.size() - 1) {
                buffer.append(" | ");
            }
            ++i;
        }
        buffer.append(")");
        if (this.tieBreakerMultiplier != 0.0f) {
            buffer.append("~");
            buffer.append(this.tieBreakerMultiplier);
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DisjunctionMaxQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(DisjunctionMaxQuery other) {
        return this.tieBreakerMultiplier == other.tieBreakerMultiplier && Objects.equals(this.disjuncts, other.disjuncts);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + Float.floatToIntBits(this.tieBreakerMultiplier);
        h = 31 * h + Objects.hashCode(this.disjuncts);
        return h;
    }

    protected class DisjunctionMaxWeight
    extends Weight {
        protected final ArrayList<Weight> weights;
        private final ScoreMode scoreMode;

        public DisjunctionMaxWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
            super(DisjunctionMaxQuery.this);
            this.weights = new ArrayList();
            for (Query disjunctQuery : DisjunctionMaxQuery.this.disjuncts) {
                this.weights.add(searcher.createWeight(disjunctQuery, scoreMode, boost));
            }
            this.scoreMode = scoreMode;
        }

        @Override
        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            ArrayList<Matches> mis = new ArrayList<Matches>();
            for (Weight weight : this.weights) {
                Matches mi = weight.matches(context, doc);
                if (mi == null) continue;
                mis.add(mi);
            }
            return MatchesUtils.fromSubMatches(mis);
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            ArrayList<Scorer> scorers = new ArrayList<Scorer>();
            for (Weight w : this.weights) {
                Scorer subScorer = w.scorer(context);
                if (subScorer == null) continue;
                scorers.add(subScorer);
            }
            if (scorers.isEmpty()) {
                return null;
            }
            if (scorers.size() == 1) {
                return (Scorer)scorers.get(0);
            }
            return new DisjunctionMaxScorer(this, DisjunctionMaxQuery.this.tieBreakerMultiplier, scorers, this.scoreMode);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            if (this.weights.size() > 16) {
                return false;
            }
            for (Weight w : this.weights) {
                if (w.isCacheable(ctx)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            boolean match = false;
            double max = 0.0;
            double otherSum = 0.0;
            ArrayList<Explanation> subs = new ArrayList<Explanation>();
            for (Weight wt : this.weights) {
                Explanation e = wt.explain(context, doc);
                if (!e.isMatch()) continue;
                match = true;
                subs.add(e);
                double score = e.getValue().doubleValue();
                if (score >= max) {
                    otherSum += max;
                    max = score;
                    continue;
                }
                otherSum += score;
            }
            if (match) {
                float score = (float)(max + otherSum * (double)DisjunctionMaxQuery.this.tieBreakerMultiplier);
                String desc = DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f ? "max of:" : "max plus " + DisjunctionMaxQuery.this.tieBreakerMultiplier + " times others of:";
                return Explanation.match((Number)Float.valueOf(score), desc, subs);
            }
            return Explanation.noMatch("No matching clause", new Explanation[0]);
        }
    }
}

