/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.encryptor;

import com.amazonaws.encryptionsdk.AwsCrypto;
import com.amazonaws.encryptionsdk.CommitmentPolicy;
import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.jce.JceMasterKey;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.action.get.GetRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.engine.encryptor.Encryptor;

public class EncryptorImpl
implements Encryptor {
    @Generated
    private static final Logger log = LogManager.getLogger(EncryptorImpl.class);
    public static final String MASTER_KEY_NOT_READY_ERROR = "The ML encryption master key has not been initialized yet. Please retry after waiting for 10 seconds.";
    private ClusterService clusterService;
    private Client client;
    private volatile String masterKey;

    public EncryptorImpl(ClusterService clusterService, Client client) {
        this.masterKey = null;
        this.clusterService = clusterService;
        this.client = client;
    }

    public EncryptorImpl(String masterKey) {
        this.masterKey = masterKey;
    }

    @Override
    public void setMasterKey(String masterKey) {
        this.masterKey = masterKey;
    }

    @Override
    public String getMasterKey() {
        return this.masterKey;
    }

    @Override
    public String encrypt(String plainText) {
        this.initMasterKey();
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        byte[] bytes = Base64.getDecoder().decode(this.masterKey);
        JceMasterKey jceMasterKey = JceMasterKey.getInstance((SecretKey)new SecretKeySpec(bytes, "AES"), (String)"Custom", (String)"", (String)"AES/GCM/NoPadding");
        CryptoResult encryptResult = crypto.encryptData((MasterKeyProvider)jceMasterKey, plainText.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString((byte[])encryptResult.getResult());
    }

    @Override
    public String decrypt(String encryptedText) {
        this.initMasterKey();
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        byte[] bytes = Base64.getDecoder().decode(this.masterKey);
        JceMasterKey jceMasterKey = JceMasterKey.getInstance((SecretKey)new SecretKeySpec(bytes, "AES"), (String)"Custom", (String)"", (String)"AES/GCM/NoPadding");
        CryptoResult decryptedResult = crypto.decryptData((MasterKeyProvider)jceMasterKey, Base64.getDecoder().decode(encryptedText));
        return new String((byte[])decryptedResult.getResult());
    }

    @Override
    public String generateMasterKey() {
        byte[] keyBytes = new byte[32];
        new SecureRandom().nextBytes(keyBytes);
        String base64Key = Base64.getEncoder().encodeToString(keyBytes);
        return base64Key;
    }

    private void initMasterKey() {
        if (this.masterKey != null) {
            return;
        }
        AtomicReference<ResourceNotFoundException> exceptionRef = new AtomicReference<ResourceNotFoundException>();
        CountDownLatch latch = new CountDownLatch(1);
        if (this.clusterService.state().metadata().hasIndex(".plugins-ml-config")) {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                GetRequest getRequest = new GetRequest(".plugins-ml-config").id("master_key");
                this.client.get(getRequest, (ActionListener)new LatchedActionListener(ActionListener.wrap(r -> {
                    if (r.isExists()) {
                        String masterKey;
                        this.masterKey = masterKey = (String)r.getSourceAsMap().get("master_key");
                    } else {
                        exceptionRef.set(new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]));
                    }
                }, e -> {
                    log.error("Failed to get ML encryption master key", (Throwable)e);
                    exceptionRef.set((ResourceNotFoundException)e);
                }), latch));
            }
        } else {
            exceptionRef.set(new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]));
            latch.countDown();
        }
        try {
            latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            throw new IllegalStateException(e2);
        }
        if (exceptionRef.get() != null) {
            log.debug("Failed to init master key", (Throwable)exceptionRef.get());
            if (exceptionRef.get() instanceof RuntimeException) {
                throw (RuntimeException)exceptionRef.get();
            }
            throw new MLException((Throwable)exceptionRef.get());
        }
        if (this.masterKey == null) {
            throw new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]);
        }
    }
}

