/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.utils;

import com.google.gson.Gson;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.opensearch.ml.common.connector.MLPostProcessFunction;
import org.opensearch.ml.common.connector.MLPreProcessFunction;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.ScriptType;
import org.opensearch.script.TemplateScript;

public class ScriptUtils {
    public static final Gson gson = new Gson();

    public static Optional<String> executePreprocessFunction(ScriptService scriptService, String preProcessFunction, Map<String, Object> params) {
        if (MLPreProcessFunction.contains((String)preProcessFunction)) {
            preProcessFunction = MLPreProcessFunction.get((String)preProcessFunction);
        }
        if (preProcessFunction != null) {
            return Optional.ofNullable(ScriptUtils.executeScript(scriptService, preProcessFunction, params));
        }
        return Optional.empty();
    }

    public static Optional<String> executePostprocessFunction(ScriptService scriptService, String postProcessFunction, String resultJson) {
        Map result = StringUtils.fromJson((String)resultJson, (String)"result");
        if (MLPostProcessFunction.contains((String)postProcessFunction)) {
            postProcessFunction = MLPostProcessFunction.get((String)postProcessFunction);
        }
        if (postProcessFunction != null) {
            return Optional.ofNullable(ScriptUtils.executeScript(scriptService, postProcessFunction, result));
        }
        return Optional.empty();
    }

    public static String executeScript(ScriptService scriptService, String painlessScript, Map<String, Object> params) {
        Script script = new Script(ScriptType.INLINE, "painless", painlessScript, Collections.emptyMap());
        TemplateScript templateScript = ((TemplateScript.Factory)scriptService.compile(script, TemplateScript.CONTEXT)).newInstance(params);
        return templateScript.execute();
    }
}

