/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.NodeConfigFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.core.NonLeafNode;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;

public abstract class OpenSearchConfigNode
extends NonLeafNode<NodeConfigFlowUnit> {
    private static final Logger LOG = LogManager.getLogger(OpenSearchConfigNode.class);

    public OpenSearchConfigNode() {
        super(0, 5L);
    }

    @Override
    public void generateFlowUnitListFromLocal(FlowUnitOperationArgWrapper args) {
        NodeConfigFlowUnit result;
        long startTime = System.currentTimeMillis();
        try {
            result = (NodeConfigFlowUnit)this.operate();
        }
        catch (Exception ex) {
            LOG.error("Exception in operate.", (Throwable)ex);
            ServiceMetrics.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat((MeasurementSet)ExceptionsAndErrors.EXCEPTION_IN_OPERATE, this.name(), (Number)1);
            result = new NodeConfigFlowUnit(System.currentTimeMillis());
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        ServiceMetrics.RCA_GRAPH_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaGraphMetrics.GRAPH_NODE_OPERATE_CALL, this.name(), (Number)duration);
        this.setLocalFlowUnit(result);
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        List<FlowUnitMessage> flowUnitMessages = args.getWireHopper().readFromWire(args.getNode());
        ArrayList<NodeConfigFlowUnit> flowUnitList = new ArrayList<NodeConfigFlowUnit>();
        LOG.debug("rca: Executing fromWire: {}", (Object)this.getClass().getSimpleName());
        for (FlowUnitMessage flowUnitMessage : flowUnitMessages) {
            flowUnitList.add(NodeConfigFlowUnit.buildFlowUnitFromWrapper(flowUnitMessage));
        }
        this.setFlowUnits(flowUnitList);
    }

    @Override
    public void handleNodeMuted() {
        this.setLocalFlowUnit(new NodeConfigFlowUnit(System.currentTimeMillis()));
    }

    @Override
    public void persistFlowUnit(FlowUnitOperationArgWrapper args) {
    }
}

