/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.SecurityConfigurationSummary;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListSecurityConfigurationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<SecurityConfigurationSummary> securityConfigurations;
    private String marker;

    public List<SecurityConfigurationSummary> getSecurityConfigurations() {
        if (this.securityConfigurations == null) {
            this.securityConfigurations = new SdkInternalList();
        }
        return this.securityConfigurations;
    }

    public void setSecurityConfigurations(Collection<SecurityConfigurationSummary> securityConfigurations) {
        if (securityConfigurations == null) {
            this.securityConfigurations = null;
            return;
        }
        this.securityConfigurations = new SdkInternalList(securityConfigurations);
    }

    public ListSecurityConfigurationsResult withSecurityConfigurations(SecurityConfigurationSummary ... securityConfigurations) {
        if (this.securityConfigurations == null) {
            this.setSecurityConfigurations((Collection<SecurityConfigurationSummary>)new SdkInternalList(securityConfigurations.length));
        }
        for (SecurityConfigurationSummary ele : securityConfigurations) {
            this.securityConfigurations.add((Object)ele);
        }
        return this;
    }

    public ListSecurityConfigurationsResult withSecurityConfigurations(Collection<SecurityConfigurationSummary> securityConfigurations) {
        this.setSecurityConfigurations(securityConfigurations);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListSecurityConfigurationsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityConfigurations() != null) {
            sb.append("SecurityConfigurations: ").append(this.getSecurityConfigurations()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityConfigurationsResult)) {
            return false;
        }
        ListSecurityConfigurationsResult other = (ListSecurityConfigurationsResult)obj;
        if (other.getSecurityConfigurations() == null ^ this.getSecurityConfigurations() == null) {
            return false;
        }
        if (other.getSecurityConfigurations() != null && !other.getSecurityConfigurations().equals(this.getSecurityConfigurations())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityConfigurations() == null ? 0 : this.getSecurityConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListSecurityConfigurationsResult clone() {
        try {
            return (ListSecurityConfigurationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

