/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class DeleteModelRequest
extends BaseNodesRequest<DeleteModelRequest>
implements ToXContentObject {
    private String adID;

    public String getAdID() {
        return this.adID;
    }

    public DeleteModelRequest() {
        super((String[])null);
    }

    public DeleteModelRequest(StreamInput in) throws IOException {
        super(in);
        this.adID = in.readString();
    }

    public DeleteModelRequest(String adID, DiscoveryNode ... nodes) {
        super(nodes);
        this.adID = adID;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.adID);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.adID)) {
            validationException = ValidateActions.addValidationError((String)"AD ID is missing", validationException);
        }
        return validationException;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("adID", this.adID);
        builder.endObject();
        return builder;
    }
}

