/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.ad.cluster.ADVersionUtil;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class RCFResultResponse
extends ActionResponse
implements ToXContentObject {
    public static final String RCF_SCORE_JSON_KEY = "rcfScore";
    public static final String CONFIDENCE_JSON_KEY = "confidence";
    public static final String FOREST_SIZE_JSON_KEY = "forestSize";
    public static final String ATTRIBUTION_JSON_KEY = "attribution";
    public static final String TOTAL_UPDATES_JSON_KEY = "total_updates";
    public static final String RELATIVE_INDEX_FIELD_JSON_KEY = "relativeIndex";
    public static final String PAST_VALUES_FIELD_JSON_KEY = "pastValues";
    public static final String EXPECTED_VAL_LIST_FIELD_JSON_KEY = "expectedValuesList";
    public static final String LIKELIHOOD_FIELD_JSON_KEY = "likelihoodOfValues";
    public static final String THRESHOLD_FIELD_JSON_KEY = "threshold";
    private Double rcfScore;
    private Double confidence;
    private Integer forestSize;
    private double[] attribution;
    private Long totalUpdates = 0L;
    private Version remoteAdVersion;
    private Double anomalyGrade;
    private Integer relativeIndex;
    private double[] pastValues;
    private double[][] expectedValuesList;
    private double[] likelihoodOfValues;
    private Double threshold;

    public RCFResultResponse(double rcfScore, double confidence, int forestSize, double[] attribution, long totalUpdates, double grade, Version remoteAdVersion, Integer relativeIndex, double[] pastValues, double[][] expectedValuesList, double[] likelihoodOfValues, Double threshold) {
        this.rcfScore = rcfScore;
        this.confidence = confidence;
        this.forestSize = forestSize;
        this.attribution = attribution;
        this.totalUpdates = totalUpdates;
        this.anomalyGrade = grade;
        this.remoteAdVersion = remoteAdVersion;
        this.relativeIndex = relativeIndex;
        this.pastValues = pastValues;
        this.expectedValuesList = expectedValuesList;
        this.likelihoodOfValues = likelihoodOfValues;
        this.threshold = threshold;
    }

    public RCFResultResponse(StreamInput in) throws IOException {
        super(in);
        this.rcfScore = in.readDouble();
        this.confidence = in.readDouble();
        this.forestSize = in.readVInt();
        this.attribution = in.readDoubleArray();
        if (in.available() > 0) {
            this.totalUpdates = in.readLong();
            this.anomalyGrade = in.readDouble();
            this.relativeIndex = in.readOptionalInt();
            this.pastValues = (double[])(in.readBoolean() ? in.readDoubleArray() : null);
            if (in.readBoolean()) {
                int numberofExpectedVals = in.readVInt();
                this.expectedValuesList = new double[numberofExpectedVals][];
                for (int i = 0; i < numberofExpectedVals; ++i) {
                    this.expectedValuesList[i] = in.readDoubleArray();
                }
            } else {
                this.expectedValuesList = null;
            }
            this.likelihoodOfValues = (double[])(in.readBoolean() ? in.readDoubleArray() : null);
            this.threshold = in.readOptionalDouble();
        }
    }

    public Double getRCFScore() {
        return this.rcfScore;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public Integer getForestSize() {
        return this.forestSize;
    }

    public double[] getAttribution() {
        return this.attribution;
    }

    public Long getTotalUpdates() {
        return this.totalUpdates;
    }

    public Double getAnomalyGrade() {
        return this.anomalyGrade;
    }

    public Integer getRelativeIndex() {
        return this.relativeIndex;
    }

    public double[] getPastValues() {
        return this.pastValues;
    }

    public double[][] getExpectedValuesList() {
        return this.expectedValuesList;
    }

    public double[] getLikelihoodOfValues() {
        return this.likelihoodOfValues;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.rcfScore.doubleValue());
        out.writeDouble(this.confidence.doubleValue());
        out.writeVInt(this.forestSize.intValue());
        out.writeDoubleArray(this.attribution);
        if (ADVersionUtil.compatibleWithVersionOnOrAfter1_1(this.remoteAdVersion)) {
            out.writeLong(this.totalUpdates.longValue());
            out.writeDouble(this.anomalyGrade.doubleValue());
            out.writeOptionalInt(this.relativeIndex);
            if (this.pastValues != null) {
                out.writeBoolean(true);
                out.writeDoubleArray(this.pastValues);
            } else {
                out.writeBoolean(false);
            }
            if (this.expectedValuesList != null) {
                out.writeBoolean(true);
                int numberofExpectedVals = this.expectedValuesList.length;
                out.writeVInt(this.expectedValuesList.length);
                for (int i = 0; i < numberofExpectedVals; ++i) {
                    out.writeDoubleArray(this.expectedValuesList[i]);
                }
            } else {
                out.writeBoolean(false);
            }
            if (this.likelihoodOfValues != null) {
                out.writeBoolean(true);
                out.writeDoubleArray(this.likelihoodOfValues);
            } else {
                out.writeBoolean(false);
            }
            out.writeOptionalDouble(this.threshold);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RCF_SCORE_JSON_KEY, this.rcfScore);
        builder.field(CONFIDENCE_JSON_KEY, this.confidence);
        builder.field(FOREST_SIZE_JSON_KEY, this.forestSize);
        builder.field(ATTRIBUTION_JSON_KEY, (Object)this.attribution);
        builder.field(TOTAL_UPDATES_JSON_KEY, this.totalUpdates);
        builder.field("anomalyGrade", this.anomalyGrade);
        builder.field(RELATIVE_INDEX_FIELD_JSON_KEY, this.relativeIndex);
        builder.field(PAST_VALUES_FIELD_JSON_KEY, (Object)this.pastValues);
        builder.field(EXPECTED_VAL_LIST_FIELD_JSON_KEY, (Object)this.expectedValuesList);
        builder.field(LIKELIHOOD_FIELD_JSON_KEY, (Object)this.likelihoodOfValues);
        builder.field(THRESHOLD_FIELD_JSON_KEY, this.threshold);
        builder.endObject();
        return builder;
    }
}

