/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.common;

import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoSettings;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.utils.LockService;

public class Ip2GeoLockService {
    @Generated
    private static final Logger log = LogManager.getLogger(Ip2GeoLockService.class);
    public static final long LOCK_DURATION_IN_SECONDS = 300L;
    public static final long RENEW_AFTER_IN_SECONDS = 120L;
    private final ClusterService clusterService;
    private final LockService lockService;

    public Ip2GeoLockService(ClusterService clusterService, Client client) {
        this.clusterService = clusterService;
        this.lockService = new LockService(client, clusterService);
    }

    public void acquireLock(String datasourceName, Long lockDurationSeconds, ActionListener<LockModel> listener) {
        this.lockService.acquireLockWithId(".scheduler-geospatial-ip2geo-datasource", lockDurationSeconds, datasourceName, listener);
    }

    public Optional<LockModel> acquireLock(String datasourceName, Long lockDurationSeconds) {
        final AtomicReference lockReference = new AtomicReference();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.lockService.acquireLockWithId(".scheduler-geospatial-ip2geo-datasource", lockDurationSeconds, datasourceName, (ActionListener)new ActionListener<LockModel>(){

            public void onResponse(LockModel lockModel) {
                lockReference.set(lockModel);
                countDownLatch.countDown();
            }

            public void onFailure(Exception e) {
                lockReference.set(null);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await(((TimeValue)this.clusterService.getClusterSettings().get(Ip2GeoSettings.TIMEOUT)).getSeconds(), TimeUnit.SECONDS);
            return Optional.ofNullable((LockModel)lockReference.get());
        }
        catch (InterruptedException e) {
            return Optional.empty();
        }
    }

    public void releaseLock(LockModel lockModel) {
        this.lockService.release(lockModel, ActionListener.wrap(released -> {}, exception -> log.error("Failed to release the lock", (Throwable)exception)));
    }

    public LockModel renewLock(LockModel lockModel) {
        final AtomicReference lockReference = new AtomicReference();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.lockService.renewLock(lockModel, (ActionListener)new ActionListener<LockModel>(){

            public void onResponse(LockModel lockModel) {
                lockReference.set(lockModel);
                countDownLatch.countDown();
            }

            public void onFailure(Exception e) {
                lockReference.set(null);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await(((TimeValue)this.clusterService.getClusterSettings().get(Ip2GeoSettings.TIMEOUT)).getSeconds(), TimeUnit.SECONDS);
            return (LockModel)lockReference.get();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public Runnable getRenewLockRunnable(AtomicReference<LockModel> lockModel) {
        return () -> {
            LockModel preLock = (LockModel)lockModel.get();
            if (Instant.now().isBefore(preLock.getLockTime().plusSeconds(120L))) {
                return;
            }
            lockModel.set(this.renewLock((LockModel)lockModel.get()));
            if (lockModel.get() == null) {
                new OpenSearchException("failed to renew a lock [{}]", new Object[]{preLock});
            }
        };
    }
}

