/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.SketchesReadOnlyException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.quantiles.DirectUpdateDoublesSketch;
import com.yahoo.sketches.quantiles.DirectUpdateDoublesSketchR;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesUnion;
import com.yahoo.sketches.quantiles.DoublesUtil;
import com.yahoo.sketches.quantiles.HeapUpdateDoublesSketch;
import com.yahoo.sketches.quantiles.UpdateDoublesSketch;

class DoublesUnionImplR
extends DoublesUnion {
    int maxK_;
    UpdateDoublesSketch gadget_ = null;

    DoublesUnionImplR(int maxK) {
        this.maxK_ = maxK;
    }

    static DoublesUnionImplR wrapInstance(Memory mem) {
        DirectUpdateDoublesSketchR sketch = DirectUpdateDoublesSketchR.wrapInstance(mem);
        int k = sketch.getK();
        DoublesUnionImplR union = new DoublesUnionImplR(k);
        union.maxK_ = k;
        union.gadget_ = sketch;
        return union;
    }

    @Override
    public void update(DoublesSketch sketchIn) {
        throw new SketchesReadOnlyException("Call to update() on read-only Union");
    }

    @Override
    public void update(Memory mem) {
        throw new SketchesReadOnlyException("Call to update() on read-only Union");
    }

    @Override
    public void update(double dataItem) {
        throw new SketchesReadOnlyException("Call to update() on read-only Union");
    }

    @Override
    public byte[] toByteArray() {
        if (this.gadget_ == null) {
            return DoublesSketch.builder().setK(this.maxK_).build().toByteArray();
        }
        return this.gadget_.toByteArray();
    }

    @Override
    public UpdateDoublesSketch getResult() {
        if (this.gadget_ == null) {
            return HeapUpdateDoublesSketch.newInstance(this.maxK_);
        }
        return DoublesUtil.copyToHeap(this.gadget_);
    }

    @Override
    public UpdateDoublesSketch getResult(WritableMemory dstMem) {
        long memCapBytes = dstMem.getCapacity();
        if (this.gadget_ == null) {
            if (memCapBytes < (long)DoublesSketch.getUpdatableStorageBytes(0, 0L)) {
                throw new SketchesArgumentException("Insufficient capacity for result: " + memCapBytes);
            }
            return DirectUpdateDoublesSketch.newInstance(this.maxK_, dstMem);
        }
        this.gadget_.putMemory(dstMem, false);
        return DirectUpdateDoublesSketch.wrapInstance(dstMem);
    }

    @Override
    public UpdateDoublesSketch getResultAndReset() {
        throw new SketchesReadOnlyException("Call to getResultAndReset() on read-only Union");
    }

    @Override
    public void reset() {
        throw new SketchesReadOnlyException("Call to reset() on read-only Union");
    }

    @Override
    public boolean isEmpty() {
        return this.gadget_ == null || this.gadget_.isEmpty();
    }

    @Override
    public boolean isDirect() {
        return this.gadget_ != null && this.gadget_.isDirect();
    }

    @Override
    public int getMaxK() {
        return this.maxK_;
    }

    @Override
    public int getEffectiveK() {
        return this.gadget_ != null ? this.gadget_.getK() : this.maxK_;
    }

    @Override
    public String toString() {
        return this.toString(true, false);
    }

    @Override
    public String toString(boolean sketchSummary, boolean dataDetail) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        int maxK = this.getMaxK();
        String kStr = String.format("%,d", maxK);
        sb.append(com.yahoo.sketches.quantiles.Util.LS).append("### Quantiles ").append(thisSimpleName).append(Util.LS);
        sb.append("   maxK                         : ").append(kStr);
        if (this.gadget_ == null) {
            sb.append(HeapUpdateDoublesSketch.newInstance(this.maxK_).toString());
            return sb.toString();
        }
        sb.append(this.gadget_.toString(sketchSummary, dataDetail));
        return sb.toString();
    }

    @Override
    public boolean isSameResource(Memory that) {
        return this.gadget_ == null ? false : this.gadget_.isSameResource(that);
    }
}

