/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.query.KNNWeight;

public class KNNQuery
extends Query {
    private final String field;
    private final float[] queryVector;
    private final int k;
    private final String indexName;
    private Query filterQuery;

    public KNNQuery(String field, float[] queryVector, int k, String indexName) {
        this.field = field;
        this.queryVector = queryVector;
        this.k = k;
        this.indexName = indexName;
    }

    public KNNQuery(String field, float[] queryVector, int k, String indexName, Query filterQuery) {
        this.field = field;
        this.queryVector = queryVector;
        this.k = k;
        this.indexName = indexName;
        this.filterQuery = filterQuery;
    }

    public String getField() {
        return this.field;
    }

    public float[] getQueryVector() {
        return this.queryVector;
    }

    public int getK() {
        return this.k;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        if (!KNNSettings.isKNNPluginEnabled()) {
            throw new IllegalStateException("KNN plugin is disabled. To enable update knn.plugin.enabled to true");
        }
        Weight filterWeight = this.getFilterWeight(searcher);
        if (filterWeight != null) {
            return new KNNWeight(this, boost, filterWeight);
        }
        return new KNNWeight(this, boost);
    }

    private Weight getFilterWeight(IndexSearcher searcher) throws IOException {
        if (this.getFilterQuery() != null) {
            BooleanQuery booleanQuery = new BooleanQuery.Builder().add(this.getFilterQuery(), BooleanClause.Occur.FILTER).add((Query)new FieldExistsQuery(this.getField()), BooleanClause.Occur.FILTER).build();
            Query rewritten = searcher.rewrite((Query)booleanQuery);
            return searcher.createWeight(rewritten, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        return null;
    }

    public void visit(QueryVisitor visitor) {
    }

    public String toString(String field) {
        return field;
    }

    public int hashCode() {
        return this.field.hashCode() ^ this.queryVector.hashCode() ^ this.k;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((KNNQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(KNNQuery other) {
        return this.field.equals(other.getField()) && this.queryVector.equals(other.getQueryVector()) && this.k == other.getK();
    }

    @Generated
    public Query getFilterQuery() {
        return this.filterQuery;
    }

    @Generated
    public void setFilterQuery(Query filterQuery) {
        this.filterQuery = filterQuery;
    }
}

