/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.util;

import java.util.Objects;
import org.apache.lucene.search.ScoreDoc;

public class HybridSearchResultFormatUtil {
    public static final Float MAGIC_NUMBER_START_STOP = Float.valueOf(-9.549512E9f);
    public static final Float MAGIC_NUMBER_DELIMITER = Float.valueOf(-4.4224404E9f);

    public static ScoreDoc createStartStopElementForHybridSearchResults(int docId) {
        return new ScoreDoc(docId, MAGIC_NUMBER_START_STOP.floatValue());
    }

    public static ScoreDoc createDelimiterElementForHybridSearchResults(int docId) {
        return new ScoreDoc(docId, MAGIC_NUMBER_DELIMITER.floatValue());
    }

    public static boolean isHybridQueryStartStopElement(ScoreDoc scoreDoc) {
        return Objects.nonNull(scoreDoc) && scoreDoc.doc >= 0 && Float.compare(scoreDoc.score, MAGIC_NUMBER_START_STOP.floatValue()) == 0;
    }

    public static boolean isHybridQueryDelimiterElement(ScoreDoc scoreDoc) {
        return Objects.nonNull(scoreDoc) && scoreDoc.doc >= 0 && Float.compare(scoreDoc.score, MAGIC_NUMBER_DELIMITER.floatValue()) == 0;
    }
}

