/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.ordinal;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlSelectGroupByExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;
import org.opensearch.sql.legacy.parser.ElasticSqlExprParser;
import org.opensearch.sql.legacy.rewriter.RewriteRule;
import org.opensearch.sql.legacy.rewriter.matchtoterm.VerificationException;

public class OrdinalRewriterRule
implements RewriteRule<SQLQueryExpr> {
    private final String sql;

    public OrdinalRewriterRule(String sql) {
        this.sql = sql;
    }

    @Override
    public boolean match(SQLQueryExpr root) {
        SQLSelectQuery sqlSelectQuery = root.getSubQuery().getQuery();
        if (!(sqlSelectQuery instanceof MySqlSelectQueryBlock)) {
            return false;
        }
        MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)sqlSelectQuery;
        return this.hasGroupByWithOrdinals(query) || this.hasOrderByWithOrdinals(query);
    }

    @Override
    public void rewrite(SQLQueryExpr root) {
        SQLQueryExpr sqlExprGroupCopy = this.toSqlExpr();
        SQLQueryExpr sqlExprOrderCopy = this.toSqlExpr();
        this.changeOrdinalAliasInGroupAndOrderBy(root, sqlExprGroupCopy, sqlExprOrderCopy);
    }

    private void changeOrdinalAliasInGroupAndOrderBy(SQLQueryExpr root, final SQLQueryExpr exprGroup, final SQLQueryExpr exprOrder) {
        root.accept((SQLASTVisitor)new MySqlASTVisitorAdapter(){
            private String groupException = "Invalid ordinal [%s] specified in [GROUP BY %s]";
            private String orderException = "Invalid ordinal [%s] specified in [ORDER BY %s]";
            private List<SQLSelectItem> groupSelectList = ((MySqlSelectQueryBlock)exprGroup.getSubQuery().getQuery()).getSelectList();
            private List<SQLSelectItem> orderSelectList = ((MySqlSelectQueryBlock)exprOrder.getSubQuery().getQuery()).getSelectList();

            public boolean visit(MySqlSelectGroupByExpr groupByExpr) {
                SQLExpr expr = groupByExpr.getExpr();
                if (expr instanceof SQLIntegerExpr) {
                    Integer ordinalValue = ((SQLIntegerExpr)expr).getNumber().intValue();
                    SQLExpr newExpr = OrdinalRewriterRule.this.checkAndGet(this.groupSelectList, ordinalValue, this.groupException);
                    groupByExpr.setExpr(newExpr);
                    newExpr.setParent((SQLObject)groupByExpr);
                }
                return false;
            }

            public boolean visit(SQLSelectOrderByItem orderByItem) {
                SQLExpr expr = orderByItem.getExpr();
                if (expr instanceof SQLIntegerExpr) {
                    Integer ordinalValue = ((SQLIntegerExpr)expr).getNumber().intValue();
                    SQLExpr newExpr = OrdinalRewriterRule.this.checkAndGet(this.orderSelectList, ordinalValue, this.orderException);
                    orderByItem.setExpr(newExpr);
                    newExpr.setParent((SQLObject)orderByItem);
                } else if (expr instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)expr).getLeft() instanceof SQLIntegerExpr) {
                    SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)expr;
                    SQLIntegerExpr integerExpr = (SQLIntegerExpr)binaryOpExpr.getLeft();
                    Integer ordinalValue = integerExpr.getNumber().intValue();
                    SQLExpr newExpr = OrdinalRewriterRule.this.checkAndGet(this.orderSelectList, ordinalValue, this.orderException);
                    binaryOpExpr.setLeft(newExpr);
                    newExpr.setParent((SQLObject)binaryOpExpr);
                }
                return false;
            }
        });
    }

    private SQLExpr checkAndGet(List<SQLSelectItem> selectList, Integer ordinal, String exception) {
        if (ordinal > selectList.size()) {
            throw new VerificationException(String.format(exception, ordinal, ordinal));
        }
        return selectList.get(ordinal - 1).getExpr();
    }

    private boolean hasGroupByWithOrdinals(MySqlSelectQueryBlock query) {
        if (query.getGroupBy() == null) {
            return false;
        }
        if (query.getGroupBy().getItems().isEmpty()) {
            return false;
        }
        return query.getGroupBy().getItems().stream().anyMatch(x -> x instanceof MySqlSelectGroupByExpr && ((MySqlSelectGroupByExpr)x).getExpr() instanceof SQLIntegerExpr);
    }

    private boolean hasOrderByWithOrdinals(MySqlSelectQueryBlock query) {
        if (query.getOrderBy() == null) {
            return false;
        }
        if (query.getOrderBy().getItems().isEmpty()) {
            return false;
        }
        return query.getOrderBy().getItems().stream().anyMatch(x -> x.getExpr() instanceof SQLIntegerExpr || x.getExpr() instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)x.getExpr()).getLeft() instanceof SQLIntegerExpr);
    }

    private SQLQueryExpr toSqlExpr() {
        ElasticSqlExprParser parser = new ElasticSqlExprParser(this.sql);
        SQLExpr expr = parser.expr();
        return (SQLQueryExpr)expr;
    }
}

