/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ad.control.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.ad.control.NotificationControl;
import org.ldaptive.ad.handler.ObjectGuidHandler;
import org.ldaptive.ad.handler.ObjectSidHandler;
import org.ldaptive.async.AbandonOperation;
import org.ldaptive.async.AsyncRequest;
import org.ldaptive.async.AsyncSearchOperation;
import org.ldaptive.async.handler.AsyncRequestHandler;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.handler.OperationResponseHandler;
import org.ldaptive.handler.SearchEntryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Connection connection;

    public NotificationClient(Connection conn) {
        this.connection = conn;
    }

    public BlockingQueue<NotificationItem> execute(SearchRequest request) throws LdapException {
        return this.execute(request, Integer.MAX_VALUE);
    }

    public BlockingQueue<NotificationItem> execute(SearchRequest request, int capacity) throws LdapException {
        final LinkedBlockingQueue<NotificationItem> queue = new LinkedBlockingQueue<NotificationItem>(capacity);
        final AsyncSearchOperation search = new AsyncSearchOperation(this.connection);
        search.setOperationResponseHandlers(new OperationResponseHandler<SearchRequest, SearchResult>(){

            @Override
            public HandlerResult<Response<SearchResult>> handle(Connection conn, SearchRequest request, Response<SearchResult> response) throws LdapException {
                try {
                    NotificationClient.this.logger.debug("received {}", response);
                    search.shutdown();
                    queue.put(new NotificationItem(response));
                }
                catch (Exception e) {
                    NotificationClient.this.logger.warn("Unable to enqueue response {}", response);
                }
                return new HandlerResult<Response<SearchResult>>(response);
            }
        });
        search.setAsyncRequestHandlers(new AsyncRequestHandler(){

            @Override
            public HandlerResult<AsyncRequest> handle(Connection conn, Request request, AsyncRequest asyncRequest) throws LdapException {
                try {
                    NotificationClient.this.logger.debug("received {}", (Object)asyncRequest);
                    queue.put(new NotificationItem(asyncRequest));
                }
                catch (Exception e) {
                    NotificationClient.this.logger.warn("Unable to enqueue async request {}", (Object)asyncRequest);
                }
                return new HandlerResult<Object>(null);
            }
        });
        search.setExceptionHandler((conn, request1, exception) -> {
            try {
                this.logger.debug("received exception:", (Throwable)exception);
                search.shutdown();
                queue.put(new NotificationItem(exception));
            }
            catch (Exception e) {
                this.logger.warn("Unable to enqueue exception:", (Throwable)exception);
            }
            return new HandlerResult<Object>(null);
        });
        request.setControls(new NotificationControl());
        request.setSearchEntryHandlers(new ObjectGuidHandler(), new ObjectSidHandler(), new SearchEntryHandler(){

            @Override
            public HandlerResult<SearchEntry> handle(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
                try {
                    NotificationClient.this.logger.debug("received {}", (Object)entry);
                    queue.put(new NotificationItem(entry));
                }
                catch (Exception e) {
                    NotificationClient.this.logger.warn("Unable to enqueue entry {}", (Object)entry);
                }
                return new HandlerResult<Object>(null);
            }

            @Override
            public void initializeRequest(SearchRequest request) {
            }
        });
        search.execute(request);
        return queue;
    }

    public void abandon(int messageId) throws LdapException {
        AbandonOperation abandon = new AbandonOperation(this.connection);
        abandon.execute(messageId);
    }

    public static class NotificationItem {
        private final AsyncRequest asyncRequest;
        private final SearchEntry searchEntry;
        private final Response searchResponse;
        private final Exception searchException;

        public NotificationItem(AsyncRequest request) {
            this.asyncRequest = request;
            this.searchEntry = null;
            this.searchResponse = null;
            this.searchException = null;
        }

        public NotificationItem(SearchEntry entry) {
            this.asyncRequest = null;
            this.searchEntry = entry;
            this.searchResponse = null;
            this.searchException = null;
        }

        public NotificationItem(Response response) {
            this.asyncRequest = null;
            this.searchEntry = null;
            this.searchResponse = response;
            this.searchException = null;
        }

        public NotificationItem(Exception exception) {
            this.asyncRequest = null;
            this.searchEntry = null;
            this.searchResponse = null;
            this.searchException = exception;
        }

        public boolean isAsyncRequest() {
            return this.asyncRequest != null;
        }

        public AsyncRequest getAsyncRequest() {
            return this.asyncRequest;
        }

        public boolean isEntry() {
            return this.searchEntry != null;
        }

        public SearchEntry getEntry() {
            return this.searchEntry;
        }

        public boolean isResponse() {
            return this.searchResponse != null;
        }

        public Response getResponse() {
            return this.searchResponse;
        }

        public boolean isException() {
            return this.searchException != null;
        }

        public Exception getException() {
            return this.searchException;
        }

        public String toString() {
            String s = this.isAsyncRequest() ? String.format("[%s@%d::asyncRequest=%s]", this.getClass().getName(), this.hashCode(), this.asyncRequest) : (this.isEntry() ? String.format("[%s@%d::searchEntry=%s]", this.getClass().getName(), this.hashCode(), this.searchEntry) : (this.isResponse() ? String.format("[%s@%d::searchResponse=%s]", this.getClass().getName(), this.hashCode(), this.searchResponse) : (this.isException() ? String.format("[%s@%d::searchException=%s]", this.getClass().getName(), this.hashCode(), this.searchException) : String.format("[%s@%d]", this.getClass().getName(), this.hashCode()))));
            return s;
        }
    }
}

