/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.stream.read.listener;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.io.Channels;
import org.opensearch.common.io.InputStreamContainer;
import org.opensearch.core.action.ActionListener;

@InternalApi
class FilePartWriter
implements Runnable {
    private final int partNumber;
    private final InputStreamContainer blobPartStreamContainer;
    private final Path fileLocation;
    private final AtomicBoolean anyPartStreamFailed;
    private final ActionListener<Integer> fileCompletionListener;
    private static final Logger logger = LogManager.getLogger(FilePartWriter.class);
    private static final int BUFFER_SIZE = 0xFD0000;

    public FilePartWriter(int partNumber, InputStreamContainer blobPartStreamContainer, Path fileLocation, AtomicBoolean anyPartStreamFailed, ActionListener<Integer> fileCompletionListener) {
        this.partNumber = partNumber;
        this.blobPartStreamContainer = blobPartStreamContainer;
        this.fileLocation = fileLocation;
        this.anyPartStreamFailed = anyPartStreamFailed;
        this.fileCompletionListener = fileCompletionListener;
    }

    @Override
    public void run() {
        if (!this.anyPartStreamFailed.get()) {
            try (FileChannel outputFileChannel = FileChannel.open(this.fileLocation, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                 InputStream inputStream = this.blobPartStreamContainer.getInputStream();){
                int bytesRead;
                long streamOffset = this.blobPartStreamContainer.getOffset();
                byte[] buffer = new byte[0xFD0000];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    Channels.writeToChannel(buffer, 0, bytesRead, outputFileChannel, streamOffset);
                    streamOffset += (long)bytesRead;
                }
            }
            catch (IOException e) {
                this.processFailure(e);
                return;
            }
            this.fileCompletionListener.onResponse((Object)this.partNumber);
        }
    }

    void processFailure(Exception e) {
        try {
            Files.deleteIfExists(this.fileLocation);
        }
        catch (IOException ex) {
            logger.info("Failed to delete file {} on stream failure: {}", (Object)this.fileLocation, (Object)ex);
        }
        if (!this.anyPartStreamFailed.getAndSet(true)) {
            this.fileCompletionListener.onFailure(e);
        }
    }
}

