/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

public final class JsonPrinter {
    private JsonPrinter() {
    }

    public static String minimalPrint(String json) {
        if (json == null) {
            new NullPointerException();
        }
        StringBuilder minimalPrintBuilder = new StringBuilder();
        int lookback = -1;
        int backslashCount = 0;
        boolean inQuote = false;
        for (int n : json.toCharArray()) {
            switch (n) {
                case 34: {
                    if (lookback != 92 || backslashCount % 2 == 0) {
                        inQuote = !inQuote;
                        minimalPrintBuilder.append((char)n);
                        break;
                    }
                }
                default: {
                    if (!inQuote && Character.toString((char)n).matches("\\s")) break;
                    minimalPrintBuilder.append((char)n);
                }
            }
            backslashCount = n == 92 ? ++backslashCount : 0;
            lookback = n;
        }
        return minimalPrintBuilder.toString();
    }

    public static String prettyPrint(String json) {
        return JsonPrinter.prettyPrint(json, "  ");
    }

    public static String prettyPrint(String json, String indentStr) {
        if (json == null) {
            new NullPointerException();
        }
        StringBuilder prettyPrintBuilder = new StringBuilder();
        int lookback = -1;
        int backslashCount = 0;
        int indentLevel = 0;
        boolean inQuote = false;
        boolean inBracket = false;
        for (int n : json.toCharArray()) {
            switch (n) {
                case 34: {
                    if (lookback != 92 || backslashCount % 2 == 0) {
                        inQuote = !inQuote;
                        prettyPrintBuilder.append((char)n);
                        break;
                    }
                }
                case 123: {
                    prettyPrintBuilder.append((char)n);
                    if (inQuote) break;
                    JsonPrinter.appendNewLine(prettyPrintBuilder, ++indentLevel, indentStr);
                    break;
                }
                case 125: {
                    if (!inQuote) {
                        JsonPrinter.appendNewLine(prettyPrintBuilder, --indentLevel, indentStr);
                    }
                    prettyPrintBuilder.append((char)n);
                    break;
                }
                case 91: {
                    prettyPrintBuilder.append((char)n);
                    if (inQuote) break;
                    inBracket = true;
                    prettyPrintBuilder.append(' ');
                    break;
                }
                case 93: {
                    if (!inQuote) {
                        inBracket = false;
                        prettyPrintBuilder.append(' ');
                    }
                    prettyPrintBuilder.append((char)n);
                    break;
                }
                case 44: {
                    prettyPrintBuilder.append((char)n);
                    if (inQuote) break;
                    if (inBracket) {
                        prettyPrintBuilder.append(' ');
                        break;
                    }
                    JsonPrinter.appendNewLine(prettyPrintBuilder, indentLevel, indentStr);
                    break;
                }
                case 58: {
                    if (inQuote) {
                        prettyPrintBuilder.append((char)n);
                        break;
                    }
                    prettyPrintBuilder.append(' ');
                    prettyPrintBuilder.append((char)n);
                    prettyPrintBuilder.append(' ');
                    break;
                }
                default: {
                    if (!inQuote && Character.toString((char)n).matches("\\s")) break;
                    prettyPrintBuilder.append((char)n);
                }
            }
            backslashCount = n == 92 ? ++backslashCount : 0;
            lookback = n;
        }
        return prettyPrintBuilder.toString();
    }

    private static void appendNewLine(StringBuilder stringBuilder, int indentLevel, String indentStr) {
        stringBuilder.append('\n');
        for (int i = 0; i < indentLevel; ++i) {
            stringBuilder.append(indentStr);
        }
    }

    public static String toJsonString(String javaString) {
        if (javaString == null || javaString.isEmpty()) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        block9: for (int i = 0; i < javaString.length(); ++i) {
            char c = javaString.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }
}

