/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.compliance;

import com.github.wnameless.json.flattener.JsonFlattener;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexService;
import org.opensearch.index.mapper.Uid;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.security.support.SourceFieldsContext;
import org.opensearch.security.support.WildcardMatcher;

public final class FieldReadCallback {
    private static final Logger log = LogManager.getLogger(FieldReadCallback.class);
    private final Index index;
    private final WildcardMatcher maskedFieldsMatcher;
    private final AuditLog auditLog;
    private Function<Map<String, ?>, Map<String, Object>> filterFunction;
    private SourceFieldsContext sfc;
    private Doc doc;
    private final ShardId shardId;

    public FieldReadCallback(ThreadContext threadContext, IndexService indexService, ClusterService clusterService, AuditLog auditLog, WildcardMatcher maskedFieldsMatcher, ShardId shardId) {
        block4: {
            this.index = Objects.requireNonNull(indexService).index();
            this.auditLog = auditLog;
            this.maskedFieldsMatcher = maskedFieldsMatcher;
            this.shardId = shardId;
            try {
                this.sfc = (SourceFieldsContext)HeaderHelper.deserializeSafeFromHeader(threadContext, "_opendistro_security_source_field_context");
                if (this.sfc != null && this.sfc.hasIncludesOrExcludes()) {
                    if (log.isTraceEnabled()) {
                        log.trace("_opendistro_security_source_field_context: {}", (Object)this.sfc);
                    }
                    this.filterFunction = XContentMapValues.filter((String[])this.sfc.getIncludes(), (String[])this.sfc.getExcludes());
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Cannot deserialize _opendistro_security_source_field_context because of {}", (Object)e.toString());
            }
        }
    }

    private boolean recordField(String fieldName, boolean isStringField) {
        return (!isStringField || !this.maskedFieldsMatcher.test(fieldName)) && this.auditLog.getComplianceConfig().readHistoryEnabledForField(this.index.getName(), fieldName);
    }

    public void binaryFieldRead(FieldInfo fieldInfo, byte[] fieldValue) {
        try {
            if (!(this.recordField(fieldInfo.name, false) || fieldInfo.name.equals("_source") || fieldInfo.name.equals("_id"))) {
                return;
            }
            if (fieldInfo.name.equals("_source")) {
                Map filteredSource;
                if (this.filterFunction != null) {
                    filteredSource = this.filterFunction.apply(Utils.byteArrayToMutableJsonMap(fieldValue));
                    fieldValue = Utils.jsonMapToByteArray(filteredSource);
                }
                filteredSource = new JsonFlattener(new String(fieldValue, StandardCharsets.UTF_8)).flattenAsMap();
                for (String k : filteredSource.keySet()) {
                    if (!this.recordField(k, filteredSource.get(k) instanceof String)) continue;
                    this.fieldRead0(k, filteredSource.get(k));
                }
            } else if (fieldInfo.name.equals("_id")) {
                this.fieldRead0(fieldInfo.name, Uid.decodeId((byte[])fieldValue));
            } else {
                this.fieldRead0(fieldInfo.name, new String(fieldValue, StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            log.error("Unexpected error reading binary field '{}' in index '{}'", (Object)fieldInfo.name, (Object)this.index.getName());
        }
    }

    public void stringFieldRead(FieldInfo fieldInfo, String fieldValue) {
        try {
            if (!this.recordField(fieldInfo.name, true)) {
                return;
            }
            this.fieldRead0(fieldInfo.name, fieldValue);
        }
        catch (Exception e) {
            log.error("Unexpected error reading string field '{}' in index '{}'", (Object)fieldInfo.name, (Object)this.index.getName());
        }
    }

    public void numericFieldRead(FieldInfo fieldInfo, Number fieldValue) {
        try {
            if (!this.recordField(fieldInfo.name, false)) {
                return;
            }
            this.fieldRead0(fieldInfo.name, fieldValue);
        }
        catch (Exception e) {
            log.error("Unexpected error reading numeric field '{}' in index '{}'", (Object)fieldInfo.name, (Object)this.index.getName());
        }
    }

    private void fieldRead0(String fieldName, Object fieldValue) {
        if (this.doc != null) {
            if (fieldName.equals("_id")) {
                this.doc.setId(fieldValue.toString());
            } else {
                this.doc.addField(new Field(fieldName, fieldValue));
            }
        } else {
            String indexName = this.index.getName();
            if (fieldName.equals("_id")) {
                this.doc = new Doc(indexName, fieldValue.toString());
            } else {
                this.doc = new Doc(indexName, null);
                this.doc.addField(new Field(fieldName, fieldValue));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        if (this.doc == null) {
            return;
        }
        try {
            HashMap<String, String> f = new HashMap<String, String>();
            for (Field fi : this.doc.fields) {
                f.put(fi.fieldName, String.valueOf(fi.fieldValue));
            }
            this.auditLog.logDocumentRead(this.doc.indexName, this.doc.id, this.shardId, f);
        }
        catch (Exception e) {
            log.error("Unexpected error finished compliance read entry {} in index '{}': {}", (Object)this.doc.id, (Object)this.index.getName(), (Object)e.toString(), (Object)e);
        }
        finally {
            this.doc = null;
            this.sfc = null;
        }
    }

    private class Doc {
        final String indexName;
        String id;
        final List<Field> fields = new ArrayList<Field>();

        public Doc(String indexName, String id) {
            this.indexName = indexName;
            this.id = id;
        }

        public void addField(Field f) {
            this.fields.add(f);
        }

        public void setId(String id) {
            this.id = id;
        }

        public String toString() {
            return "Doc [indexName=" + this.indexName + ", id=" + this.id + ", fields=" + this.fields + "]";
        }
    }

    private class Field {
        final String fieldName;
        final Object fieldValue;

        public Field(String fieldName, Object fieldValue) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        public String toString() {
            return "Field [fieldName=" + this.fieldName + ", fieldValue=" + this.fieldValue + "]";
        }
    }
}

