/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.securityconf.Migration;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.NodesDn;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.WhitelistingSettings;
import org.opensearch.security.securityconf.impl.v6.ConfigV6;
import org.opensearch.security.securityconf.impl.v6.InternalUserV6;
import org.opensearch.security.securityconf.impl.v6.RoleMappingsV6;
import org.opensearch.security.securityconf.impl.v6.RoleV6;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.securityconf.impl.v7.InternalUserV7;
import org.opensearch.security.securityconf.impl.v7.RoleMappingsV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;
import org.opensearch.threadpool.ThreadPool;

public class MigrateApiAction
extends AbstractApiAction {
    private static final Logger LOGGER = LogManager.getLogger(MigrateApiAction.class);
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix(Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/migrate")));

    @Inject
    public MigrateApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.MIGRATE, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(this::migrateApiRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType getConfigType() {
        return null;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
    }

    private void migrateApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.allMethodsNotImplemented().override(RestRequest.Method.POST, (channel, request, client) -> this.migrate(channel, client));
    }

    protected void migrate(final RestChannel channel, final Client client) throws IOException {
        Version oldestNodeVersion = this.clusterService.state().getNodes().getMinNodeVersion();
        if (oldestNodeVersion.before((Version)LegacyESVersion.V_7_0_0)) {
            Responses.badRequest(channel, "Can not migrate configuration because cluster is not fully migrated.");
            return;
        }
        SecurityDynamicConfiguration<ConfigV6> loadedConfig = this.load(CType.CONFIG, true);
        if (loadedConfig.getVersion() != 1) {
            Responses.badRequest(channel, "Can not migrate configuration because it was already migrated.");
            return;
        }
        SecurityDynamicConfiguration<ConfigV6> configV6 = loadedConfig;
        SecurityDynamicConfiguration<?> actionGroupsV6 = this.load(CType.ACTIONGROUPS, true);
        SecurityDynamicConfiguration<InternalUserV6> internalUsersV6 = this.load(CType.INTERNALUSERS, true);
        SecurityDynamicConfiguration<RoleV6> rolesV6 = this.load(CType.ROLES, true);
        SecurityDynamicConfiguration<RoleMappingsV6> rolesmappingV6 = this.load(CType.ROLESMAPPING, true);
        SecurityDynamicConfiguration<NodesDn> nodesDnV6 = this.load(CType.NODESDN, true);
        SecurityDynamicConfiguration<WhitelistingSettings> whitelistingSettingV6 = this.load(CType.WHITELIST, true);
        SecurityDynamicConfiguration<AuditConfig> auditConfigV6 = this.load(CType.AUDIT, true);
        final ImmutableList.Builder builder = ImmutableList.builder();
        SecurityDynamicConfiguration<ActionGroupsV7> actionGroupsV7 = Migration.migrateActionGroups(actionGroupsV6);
        builder.add(actionGroupsV7);
        SecurityDynamicConfiguration<ConfigV7> configV7 = Migration.migrateConfig(configV6);
        builder.add(configV7);
        SecurityDynamicConfiguration<InternalUserV7> internalUsersV7 = Migration.migrateInternalUsers(internalUsersV6);
        builder.add(internalUsersV7);
        Tuple<SecurityDynamicConfiguration<RoleV7>, SecurityDynamicConfiguration<TenantV7>> rolesTenantsV7 = Migration.migrateRoles(rolesV6, rolesmappingV6);
        builder.add((Object)((SecurityDynamicConfiguration)rolesTenantsV7.v1()));
        builder.add((Object)((SecurityDynamicConfiguration)rolesTenantsV7.v2()));
        SecurityDynamicConfiguration<RoleMappingsV7> rolesmappingV7 = Migration.migrateRoleMappings(rolesmappingV6);
        builder.add(rolesmappingV7);
        SecurityDynamicConfiguration<NodesDn> nodesDnV7 = Migration.migrateNodesDn(nodesDnV6);
        builder.add(nodesDnV7);
        SecurityDynamicConfiguration<WhitelistingSettings> whitelistingSettingV7 = Migration.migrateWhitelistingSetting(whitelistingSettingV6);
        builder.add(whitelistingSettingV7);
        SecurityDynamicConfiguration<AuditConfig> auditConfigV7 = Migration.migrateAudit(auditConfigV6);
        builder.add(auditConfigV7);
        int replicas = this.clusterService.state().metadata().index(this.securityApiDependencies.securityIndexName()).getNumberOfReplicas();
        String autoExpandReplicas = this.clusterService.state().metadata().index(this.securityApiDependencies.securityIndexName()).getSettings().get("index.auto_expand_replicas");
        final Settings.Builder securityIndexSettings = Settings.builder();
        if (autoExpandReplicas == null) {
            securityIndexSettings.put("index.number_of_replicas", replicas);
        } else {
            securityIndexSettings.put("index.auto_expand_replicas", autoExpandReplicas);
        }
        securityIndexSettings.put("index.number_of_shards", 1);
        client.admin().indices().prepareDelete(new String[]{this.securityApiDependencies.securityIndexName()}).execute((ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                if (response.isAcknowledged()) {
                    LOGGER.debug("opendistro_security index deleted successfully");
                    client.admin().indices().prepareCreate(MigrateApiAction.this.securityApiDependencies.securityIndexName()).setSettings(securityIndexSettings).execute((ActionListener)new ActionListener<CreateIndexResponse>(){

                        public void onResponse(CreateIndexResponse response) {
                            ImmutableList dynamicConfigurations = builder.build();
                            ImmutableList.Builder cTypes = ImmutableList.builderWithExpectedSize((int)dynamicConfigurations.size());
                            BulkRequestBuilder br = client.prepareBulk(MigrateApiAction.this.securityApiDependencies.securityIndexName());
                            br.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                            try {
                                for (SecurityDynamicConfiguration dynamicConfiguration : dynamicConfigurations) {
                                    String id = dynamicConfiguration.getCType().toLCString();
                                    BytesReference xContent = XContentHelper.toXContent((ToXContent)dynamicConfiguration, (XContentType)XContentType.JSON, (boolean)false);
                                    br.add(new IndexRequest().id(id).source(new Object[]{id, xContent}));
                                    cTypes.add((Object)id);
                                }
                            }
                            catch (IOException e1) {
                                LOGGER.error("Unable to create bulk request " + e1, (Throwable)e1);
                                Responses.internalSeverError(channel, "Unable to create bulk request.");
                                return;
                            }
                            br.execute(new AbstractApiAction.ConfigUpdatingActionListener<BulkResponse>((String[])cTypes.build().toArray((Object[])new String[0]), client, new ActionListener<BulkResponse>(){

                                public void onResponse(BulkResponse response) {
                                    if (response.hasFailures()) {
                                        LOGGER.error("Unable to upload migrated configuration because of " + response.buildFailureMessage());
                                        Responses.internalSeverError(channel, "Unable to upload migrated configuration (bulk index failed).");
                                    } else {
                                        LOGGER.debug("Migration completed");
                                        Responses.ok(channel, "Migration completed.");
                                    }
                                }

                                public void onFailure(Exception e) {
                                    LOGGER.error("Unable to upload migrated configuration because of " + e, (Throwable)e);
                                    Responses.internalSeverError(channel, "Unable to upload migrated configuration.");
                                }
                            }));
                        }

                        public void onFailure(Exception e) {
                            LOGGER.error("Unable to create opendistro_security index because of " + e, (Throwable)e);
                            Responses.internalSeverError(channel, "Unable to create opendistro_security index.");
                        }
                    });
                } else {
                    LOGGER.error("Unable to create opendistro_security index.");
                }
            }

            public void onFailure(Exception e) {
                LOGGER.error("Unable to delete opendistro_security index because of " + e, (Throwable)e);
                Responses.internalSeverError(channel, "Unable to delete opendistro_security index.");
            }
        });
    }
}

