/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.http.proxy;

import com.google.common.base.Joiner;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.http.HTTPProxyAuthenticator;
import org.opensearch.security.user.AuthCredentials;

public class HTTPExtendedProxyAuthenticator
extends HTTPProxyAuthenticator {
    private static final String ATTR_PROXY = "attr.proxy.";
    private static final String ATTR_PROXY_USERNAME = "attr.proxy.username";
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile Settings settings;

    public HTTPExtendedProxyAuthenticator(Settings settings, Path configPath) {
        super(settings, configPath);
        this.settings = settings;
    }

    @Override
    public AuthCredentials extractCredentials(RestRequest request, ThreadContext context) {
        AuthCredentials credentials = super.extractCredentials(request, context);
        if (credentials == null) {
            return null;
        }
        String attrHeaderPrefix = this.settings.get("attr_header_prefix");
        if (Strings.isNullOrEmpty((String)attrHeaderPrefix)) {
            this.log.debug("attr_header_prefix is null. Skipping additional attribute extraction");
            return credentials;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("attrHeaderPrefix {}", (Object)attrHeaderPrefix);
        }
        credentials.addAttribute(ATTR_PROXY_USERNAME, credentials.getUsername());
        attrHeaderPrefix = attrHeaderPrefix.toLowerCase();
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            Object key = ((String)entry.getKey()).toLowerCase();
            if (!((String)key).startsWith(attrHeaderPrefix)) continue;
            key = ATTR_PROXY + ((String)key).substring(attrHeaderPrefix.length());
            credentials.addAttribute((String)key, Joiner.on((String)",").join(((List)entry.getValue()).iterator()));
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("Found user custom attribute '{}'", key);
        }
        return credentials.markComplete();
    }

    @Override
    public boolean reRequestAuthentication(RestChannel channel, AuthCredentials creds) {
        return false;
    }

    @Override
    public String getType() {
        return "extended-proxy";
    }
}

