/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf.impl.v7;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.security.securityconf.Hideable;
import org.opensearch.security.securityconf.StaticDefinable;
import org.opensearch.security.securityconf.impl.v6.RoleV6;

public class RoleV7
implements Hideable,
StaticDefinable {
    private boolean reserved;
    private boolean hidden;
    @JsonProperty(value="static")
    private boolean _static;
    private String description;
    private List<String> cluster_permissions = Collections.emptyList();
    private List<Index> index_permissions = Collections.emptyList();
    private List<Tenant> tenant_permissions = Collections.emptyList();

    public RoleV7() {
    }

    public RoleV7(RoleV6 roleV6) {
        List<String> roTenants;
        this.reserved = roleV6.isReserved();
        this.hidden = roleV6.isHidden();
        this.description = "Migrated from v6 (all types mapped)";
        this.cluster_permissions = roleV6.getCluster();
        this.index_permissions = new ArrayList<Index>();
        this.tenant_permissions = new ArrayList<Tenant>();
        for (Map.Entry<String, RoleV6.Index> v6i : roleV6.getIndices().entrySet()) {
            this.index_permissions.add(new Index(v6i.getKey(), v6i.getValue()));
        }
        List<String> rwTenants = roleV6.getTenants().entrySet().stream().filter(e -> "rw".equalsIgnoreCase((String)e.getValue())).map(e -> (String)e.getKey()).collect(Collectors.toList());
        if (rwTenants != null && !rwTenants.isEmpty()) {
            Tenant t = new Tenant();
            t.setAllowed_actions(Collections.singletonList("kibana_all_write"));
            t.setTenant_patterns(rwTenants);
            this.tenant_permissions.add(t);
        }
        if ((roTenants = roleV6.getTenants().entrySet().stream().filter(e -> "ro".equalsIgnoreCase((String)e.getValue())).map(e -> (String)e.getKey()).collect(Collectors.toList())) != null && !roTenants.isEmpty()) {
            Tenant t = new Tenant();
            t.setAllowed_actions(Collections.singletonList("kibana_all_read"));
            t.setTenant_patterns(roTenants);
            this.tenant_permissions.add(t);
        }
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getCluster_permissions() {
        return this.cluster_permissions;
    }

    public void setCluster_permissions(List<String> cluster_permissions) {
        this.cluster_permissions = cluster_permissions;
    }

    public List<Index> getIndex_permissions() {
        return this.index_permissions;
    }

    public void setIndex_permissions(List<Index> index_permissions) {
        this.index_permissions = index_permissions;
    }

    public List<Tenant> getTenant_permissions() {
        return this.tenant_permissions;
    }

    public void setTenant_permissions(List<Tenant> tenant_permissions) {
        this.tenant_permissions = tenant_permissions;
    }

    @Override
    public boolean isReserved() {
        return this.reserved;
    }

    public void setReserved(boolean reserved) {
        this.reserved = reserved;
    }

    @Override
    @JsonProperty(value="static")
    public boolean isStatic() {
        return this._static;
    }

    @JsonProperty(value="static")
    public void setStatic(boolean _static) {
        this._static = _static;
    }

    public String toString() {
        return "RoleV7 [reserved=" + this.reserved + ", hidden=" + this.hidden + ", _static=" + this._static + ", description=" + this.description + ", cluster_permissions=" + this.cluster_permissions + ", index_permissions=" + this.index_permissions + ", tenant_permissions=" + this.tenant_permissions + "]";
    }

    public static class Index {
        private List<String> index_patterns = Collections.emptyList();
        private String dls;
        private List<String> fls = Collections.emptyList();
        private List<String> masked_fields = Collections.emptyList();
        private List<String> allowed_actions = Collections.emptyList();

        public Index(String pattern, RoleV6.Index v6Index) {
            this.index_patterns = Collections.singletonList(pattern);
            this.dls = v6Index.get_dls_();
            this.fls = v6Index.get_fls_();
            this.masked_fields = v6Index.get_masked_fields_();
            HashSet tmpActions = new HashSet();
            for (Map.Entry<String, List<String>> type : v6Index.getTypes().entrySet()) {
                tmpActions.addAll(type.getValue());
            }
            this.allowed_actions = new ArrayList<String>(tmpActions);
        }

        public Index() {
        }

        public List<String> getIndex_patterns() {
            return this.index_patterns;
        }

        public void setIndex_patterns(List<String> index_patterns) {
            this.index_patterns = index_patterns;
        }

        public String getDls() {
            return this.dls;
        }

        public void setDls(String dls) {
            this.dls = dls;
        }

        public List<String> getFls() {
            return this.fls;
        }

        public void setFls(List<String> fls) {
            this.fls = fls;
        }

        public List<String> getMasked_fields() {
            return this.masked_fields;
        }

        public void setMasked_fields(List<String> masked_fields) {
            this.masked_fields = masked_fields;
        }

        public List<String> getAllowed_actions() {
            return this.allowed_actions;
        }

        public void setAllowed_actions(List<String> allowed_actions) {
            this.allowed_actions = allowed_actions;
        }

        public String toString() {
            return "Index [index_patterns=" + this.index_patterns + ", dls=" + this.dls + ", fls=" + this.fls + ", masked_fields=" + this.masked_fields + ", allowed_actions=" + this.allowed_actions + "]";
        }
    }

    public static class Tenant {
        private List<String> tenant_patterns = Collections.emptyList();
        private List<String> allowed_actions = Collections.emptyList();

        public List<String> getTenant_patterns() {
            return this.tenant_patterns;
        }

        public void setTenant_patterns(List<String> tenant_patterns) {
            this.tenant_patterns = tenant_patterns;
        }

        public List<String> getAllowed_actions() {
            return this.allowed_actions;
        }

        public void setAllowed_actions(List<String> allowed_actions) {
            this.allowed_actions = allowed_actions;
        }

        public String toString() {
            return "Tenant [tenant_patterns=" + this.tenant_patterns + ", allowed_actions=" + this.allowed_actions + "]";
        }
    }
}

