/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.model_group;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.action.handler.MLSearchHandler;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class SearchModelGroupTransportAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchModelGroupTransportAction.class);
    Client client;
    ClusterService clusterService;
    ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public SearchModelGroupTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/opensearch/ml/model_groups/search", transportService, actionFilters, SearchRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected void doExecute(Task task, SearchRequest request, ActionListener<SearchResponse> actionListener) {
        User user = RestActionUtils.getUserContext(this.client);
        ActionListener<SearchResponse> listener = MLSearchHandler.wrapRestActionListener(actionListener, "Fail to search");
        request.indices(new String[]{".plugins-ml-model-group"});
        this.preProcessRoleAndPerformSearch(request, user, listener);
    }

    private void preProcessRoleAndPerformSearch(SearchRequest request, User user, ActionListener<SearchResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (this.modelAccessControlHelper.skipModelAccessControl(user)) {
                this.client.search(request, listener);
            } else {
                this.modelAccessControlHelper.addUserBackendRolesFilter(user, request.source());
                log.debug("Filtering result by " + user.getBackendRoles());
                this.client.search(request, listener);
            }
        }
        catch (Exception e) {
            log.error("Failed to search", (Throwable)e);
            listener.onFailure(e);
        }
    }
}

