/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.nio.file.Path;
import java.security.PrivilegedActionException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.ml.breaker.MLCircuitBreakerService;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.common.exception.MLLimitExceededException;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;
import org.opensearch.ml.common.exception.MLValidationException;
import org.opensearch.ml.common.model.MLModelState;
import org.opensearch.ml.common.transport.deploy.MLDeployModelAction;
import org.opensearch.ml.common.transport.deploy.MLDeployModelRequest;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.common.transport.upload_chunk.MLRegisterModelMetaInput;
import org.opensearch.ml.engine.MLEngine;
import org.opensearch.ml.engine.MLExecutable;
import org.opensearch.ml.engine.ModelHelper;
import org.opensearch.ml.engine.Predictable;
import org.opensearch.ml.engine.utils.FileUtils;
import org.opensearch.ml.indices.MLIndicesHandler;
import org.opensearch.ml.model.MLModelCacheHelper;
import org.opensearch.ml.profile.MLModelProfile;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.ml.stats.ActionName;
import org.opensearch.ml.stats.MLActionLevelStat;
import org.opensearch.ml.stats.MLNodeLevelStat;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.ml.utils.MLExceptionUtils;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.script.ScriptService;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.threadpool.ThreadPool;

public class MLModelManager {
    @Generated
    private static final Logger log = LogManager.getLogger(MLModelManager.class);
    public static final int TIMEOUT_IN_MILLIS = 5000;
    public static final long MODEL_FILE_SIZE_LIMIT = 0x100000000L;
    private final Client client;
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private ThreadPool threadPool;
    private NamedXContentRegistry xContentRegistry;
    private ModelHelper modelHelper;
    private final MLModelCacheHelper modelCacheHelper;
    private final MLStats mlStats;
    private final MLCircuitBreakerService mlCircuitBreakerService;
    private final MLIndicesHandler mlIndicesHandler;
    private final MLTaskManager mlTaskManager;
    private final MLEngine mlEngine;
    private final DiscoveryNodeHelper nodeHelper;
    private volatile Integer maxModelPerNode;
    private volatile Integer maxRegisterTasksPerNode;
    private volatile Integer maxDeployTasksPerNode;
    public static final ImmutableSet MODEL_DONE_STATES = ImmutableSet.of((Object)MLModelState.TRAINED, (Object)MLModelState.REGISTERED, (Object)MLModelState.DEPLOYED, (Object)MLModelState.PARTIALLY_DEPLOYED, (Object)MLModelState.DEPLOY_FAILED, (Object)MLModelState.UNDEPLOYED, (Object[])new MLModelState[0]);

    public MLModelManager(ClusterService clusterService, ScriptService scriptService, Client client, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, ModelHelper modelHelper, Settings settings, MLStats mlStats, MLCircuitBreakerService mlCircuitBreakerService, MLIndicesHandler mlIndicesHandler, MLTaskManager mlTaskManager, MLModelCacheHelper modelCacheHelper, MLEngine mlEngine, DiscoveryNodeHelper nodeHelper) {
        this.client = client;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.modelHelper = modelHelper;
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.modelCacheHelper = modelCacheHelper;
        this.mlStats = mlStats;
        this.mlCircuitBreakerService = mlCircuitBreakerService;
        this.mlIndicesHandler = mlIndicesHandler;
        this.mlTaskManager = mlTaskManager;
        this.mlEngine = mlEngine;
        this.nodeHelper = nodeHelper;
        this.maxModelPerNode = (Integer)MLCommonsSettings.ML_COMMONS_MAX_MODELS_PER_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MAX_MODELS_PER_NODE, it -> {
            this.maxModelPerNode = it;
        });
        this.maxRegisterTasksPerNode = (Integer)MLCommonsSettings.ML_COMMONS_MAX_REGISTER_MODEL_TASKS_PER_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MAX_REGISTER_MODEL_TASKS_PER_NODE, it -> {
            this.maxRegisterTasksPerNode = it;
        });
        this.maxDeployTasksPerNode = (Integer)MLCommonsSettings.ML_COMMONS_MAX_DEPLOY_MODEL_TASKS_PER_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MAX_DEPLOY_MODEL_TASKS_PER_NODE, it -> {
            this.maxDeployTasksPerNode = it;
        });
    }

    public void registerModelMeta(MLRegisterModelMetaInput mlRegisterModelMetaInput, ActionListener<String> listener) {
        block11: {
            try {
                FunctionName functionName = mlRegisterModelMetaInput.getFunctionName();
                this.mlStats.getStat(MLNodeLevelStat.ML_REQUEST_COUNT).increment();
                this.mlStats.createCounterStatIfAbsent(functionName, ActionName.REGISTER, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
                String modelGroupId = mlRegisterModelMetaInput.getModelGroupId();
                if (Strings.isBlank((String)modelGroupId)) {
                    this.uploadMLModelMeta(mlRegisterModelMetaInput, "1", listener);
                    break block11;
                }
                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                    GetRequest getModelGroupRequest = new GetRequest(".plugins-ml-model-group").id(modelGroupId);
                    this.client.get(getModelGroupRequest, ActionListener.wrap(modelGroup -> {
                        if (modelGroup.isExists()) {
                            Map source = modelGroup.getSourceAsMap();
                            int latestVersion = (Integer)source.get("latest_version");
                            int newVersion = latestVersion + 1;
                            source.put("latest_version", newVersion);
                            source.put("last_updated_time", Instant.now().toEpochMilli());
                            UpdateRequest updateModelGroupRequest = new UpdateRequest();
                            long seqNo = modelGroup.getSeqNo();
                            long primaryTerm = modelGroup.getPrimaryTerm();
                            ((UpdateRequest)updateModelGroupRequest.index(".plugins-ml-model-group")).id(modelGroupId).setIfSeqNo(seqNo).setIfPrimaryTerm(primaryTerm).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(source);
                            this.client.update(updateModelGroupRequest, ActionListener.wrap(r -> this.uploadMLModelMeta(mlRegisterModelMetaInput, "" + newVersion, listener), e -> {
                                log.error("Failed to update model group", (Throwable)e);
                                listener.onFailure(e);
                            }));
                        } else {
                            log.error("Model group not found");
                            listener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model group"));
                        }
                    }, e -> {
                        if (e instanceof IndexNotFoundException) {
                            listener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model group"));
                        } else {
                            log.error("Failed to get model group", (Throwable)e);
                            listener.onFailure((Exception)new MLValidationException("Failed to get model group"));
                        }
                    }));
                }
                catch (Exception e2) {
                    log.error("Failed to register model", (Throwable)e2);
                    listener.onFailure(e2);
                }
            }
            catch (Exception e3) {
                log.error("Failed to init model index", (Throwable)e3);
                listener.onFailure(e3);
            }
        }
    }

    private void uploadMLModelMeta(MLRegisterModelMetaInput mlRegisterModelMetaInput, String version, ActionListener<String> listener) {
        FunctionName functionName = mlRegisterModelMetaInput.getFunctionName();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            String modelName = mlRegisterModelMetaInput.getName();
            this.mlIndicesHandler.initModelIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(res -> {
                Instant now = Instant.now();
                MLModel mlModelMeta = MLModel.builder().name(modelName).algorithm(functionName).version(version).modelGroupId(mlRegisterModelMetaInput.getModelGroupId()).description(mlRegisterModelMetaInput.getDescription()).modelFormat(mlRegisterModelMetaInput.getModelFormat()).modelState(MLModelState.REGISTERING).modelConfig(mlRegisterModelMetaInput.getModelConfig()).totalChunks(mlRegisterModelMetaInput.getTotalChunks()).modelContentHash(mlRegisterModelMetaInput.getModelContentHashValue()).modelContentSizeInBytes(mlRegisterModelMetaInput.getModelContentSizeInBytes()).createdTime(now).lastUpdateTime(now).build();
                IndexRequest indexRequest = new IndexRequest(".plugins-ml-model");
                indexRequest.source(mlModelMeta.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.index(indexRequest, ActionListener.wrap(response -> {
                    log.debug("Index model meta doc successfully {}", (Object)modelName);
                    listener.onResponse((Object)response.getId());
                }, e -> {
                    log.error("Failed to index model meta doc", (Throwable)e);
                    listener.onFailure(e);
                }));
            }, ex -> {
                log.error("Failed to init model index", (Throwable)ex);
                listener.onFailure(ex);
            }));
        }
        catch (Exception e) {
            log.error("Failed to register model", (Throwable)e);
            listener.onFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMLModel(MLRegisterModelInput registerModelInput, MLTask mlTask) {
        this.checkAndAddRunningTask(mlTask, this.maxRegisterTasksPerNode);
        try {
            this.mlStats.getStat(MLNodeLevelStat.ML_REQUEST_COUNT).increment();
            this.mlStats.createCounterStatIfAbsent(mlTask.getFunctionName(), ActionName.REGISTER, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
            this.mlStats.getStat(MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).increment();
            String modelGroupId = registerModelInput.getModelGroupId();
            GetRequest getModelGroupRequest = new GetRequest(".plugins-ml-model-group").id(modelGroupId);
            if (Strings.isBlank((String)modelGroupId)) {
                this.uploadModel(registerModelInput, mlTask, "1");
            }
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.get(getModelGroupRequest, ActionListener.wrap(modelGroup -> {
                    if (modelGroup.isExists()) {
                        Map source = modelGroup.getSourceAsMap();
                        int latestVersion = (Integer)source.get("latest_version");
                        int newVersion = latestVersion + 1;
                        source.put("latest_version", newVersion);
                        source.put("last_updated_time", Instant.now().toEpochMilli());
                        UpdateRequest updateModelGroupRequest = new UpdateRequest();
                        long seqNo = modelGroup.getSeqNo();
                        long primaryTerm = modelGroup.getPrimaryTerm();
                        ((UpdateRequest)updateModelGroupRequest.index(".plugins-ml-model-group")).id(modelGroupId).setIfSeqNo(seqNo).setIfPrimaryTerm(primaryTerm).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(source);
                        this.client.update(updateModelGroupRequest, ActionListener.wrap(r -> this.uploadModel(registerModelInput, mlTask, "" + newVersion), e -> {
                            log.error("Failed to update model group", (Throwable)e);
                            this.handleException(registerModelInput.getFunctionName(), mlTask.getTaskId(), (Exception)e);
                        }));
                    } else {
                        log.error("Model group not found");
                        this.handleException(registerModelInput.getFunctionName(), mlTask.getTaskId(), (Exception)new MLValidationException("Model group not found"));
                    }
                }, e -> {
                    if (e instanceof IndexNotFoundException) {
                        this.handleException(registerModelInput.getFunctionName(), mlTask.getTaskId(), (Exception)new MLResourceNotFoundException("Failed to get model group"));
                    } else {
                        log.error("Failed to get model group", (Throwable)e);
                        this.handleException(registerModelInput.getFunctionName(), mlTask.getTaskId(), (Exception)e);
                    }
                }));
            }
            catch (Exception e2) {
                log.error("Failed to register model", (Throwable)e2);
                this.handleException(registerModelInput.getFunctionName(), mlTask.getTaskId(), e2);
            }
        }
        catch (Exception e3) {
            this.handleException(registerModelInput.getFunctionName(), mlTask.getTaskId(), e3);
        }
        finally {
            this.mlStats.getStat(MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).decrement();
        }
    }

    private void indexRemoteModel(MLRegisterModelInput registerModelInput, MLTask mlTask, String modelVersion) {
        String taskId = mlTask.getTaskId();
        FunctionName functionName = mlTask.getFunctionName();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            String modelName = registerModelInput.getModelName();
            String version = modelVersion == null ? registerModelInput.getVersion() : modelVersion;
            Instant now = Instant.now();
            if (registerModelInput.getConnector() != null) {
                registerModelInput.getConnector().encrypt(arg_0 -> ((MLEngine)this.mlEngine).encrypt(arg_0));
            }
            this.mlIndicesHandler.initModelIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(res -> {
                MLModel mlModelMeta = MLModel.builder().name(modelName).algorithm(functionName).modelGroupId(registerModelInput.getModelGroupId()).version(version).description(registerModelInput.getDescription()).modelFormat(registerModelInput.getModelFormat()).modelState(MLModelState.REGISTERED).connector(registerModelInput.getConnector()).connectorId(registerModelInput.getConnectorId()).modelConfig(registerModelInput.getModelConfig()).createdTime(now).lastUpdateTime(now).build();
                IndexRequest indexModelMetaRequest = new IndexRequest(".plugins-ml-model");
                indexModelMetaRequest.source(mlModelMeta.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                indexModelMetaRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                ActionListener indexListener = ActionListener.wrap(modelMetaRes -> {
                    String modelId = modelMetaRes.getId();
                    mlTask.setModelId(modelId);
                    log.info("create new model meta doc {} for upload task {}", (Object)modelId, (Object)taskId);
                    this.mlTaskManager.updateMLTask(taskId, (Map<String, Object>)ImmutableMap.of((Object)"model_id", (Object)modelId, (Object)"state", (Object)MLTaskState.COMPLETED), 5000L, true);
                    if (registerModelInput.isDeployModel()) {
                        this.deployModelAfterRegistering(registerModelInput, modelId);
                    }
                }, e -> {
                    log.error("Failed to index model meta doc", (Throwable)e);
                    this.handleException(functionName, taskId, (Exception)e);
                });
                this.client.index(indexModelMetaRequest, this.threadedActionListener("opensearch_ml_register", indexListener));
            }, e -> {
                log.error("Failed to init model index", (Throwable)e);
                this.handleException(functionName, taskId, (Exception)e);
            }));
        }
        catch (Exception e2) {
            MLExceptionUtils.logException("Failed to upload model", e2, log);
            this.handleException(functionName, taskId, e2);
        }
    }

    private void uploadModel(MLRegisterModelInput registerModelInput, MLTask mlTask, String modelVersion) throws PrivilegedActionException {
        if (registerModelInput.getUrl() != null) {
            this.registerModelFromUrl(registerModelInput, mlTask, modelVersion);
        } else if (registerModelInput.getFunctionName() == FunctionName.REMOTE || registerModelInput.getConnectorId() != null) {
            this.indexRemoteModel(registerModelInput, mlTask, modelVersion);
        } else {
            this.registerPrebuiltModel(registerModelInput, mlTask, modelVersion);
        }
    }

    private void registerModelFromUrl(MLRegisterModelInput registerModelInput, MLTask mlTask, String modelVersion) {
        String taskId = mlTask.getTaskId();
        FunctionName functionName = mlTask.getFunctionName();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            String modelName = registerModelInput.getModelName();
            String version = modelVersion == null ? registerModelInput.getVersion() : modelVersion;
            String modelGroupId = registerModelInput.getModelGroupId();
            Instant now = Instant.now();
            this.mlIndicesHandler.initModelIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(res -> {
                MLModel mlModelMeta = MLModel.builder().name(modelName).modelGroupId(modelGroupId).algorithm(functionName).version(version).description(registerModelInput.getDescription()).modelFormat(registerModelInput.getModelFormat()).modelState(MLModelState.REGISTERING).modelConfig(registerModelInput.getModelConfig()).createdTime(now).lastUpdateTime(now).build();
                IndexRequest indexModelMetaRequest = new IndexRequest(".plugins-ml-model");
                if (functionName == FunctionName.METRICS_CORRELATION) {
                    indexModelMetaRequest.id(functionName.name());
                }
                indexModelMetaRequest.source(mlModelMeta.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                indexModelMetaRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                ActionListener listener = ActionListener.wrap(modelMetaRes -> {
                    String modelId = modelMetaRes.getId();
                    mlTask.setModelId(modelId);
                    log.info("create new model meta doc {} for register model task {}", (Object)modelId, (Object)taskId);
                    this.registerModel(registerModelInput, taskId, functionName, modelName, version, modelId);
                }, e -> {
                    log.error("Failed to index model meta doc", (Throwable)e);
                    this.handleException(functionName, taskId, (Exception)e);
                });
                this.client.index(indexModelMetaRequest, this.threadedActionListener("opensearch_ml_register", listener));
            }, e -> {
                log.error("Failed to init model index", (Throwable)e);
                this.handleException(functionName, taskId, (Exception)e);
            }));
        }
        catch (Exception e2) {
            MLExceptionUtils.logException("Failed to register model", e2, log);
            this.handleException(functionName, taskId, e2);
        }
    }

    private void registerModel(MLRegisterModelInput registerModelInput, String taskId, FunctionName functionName, String modelName, String version, String modelId) {
        this.modelHelper.downloadAndSplit(registerModelInput.getModelFormat(), modelId, modelName, version, registerModelInput.getUrl(), registerModelInput.getHashValue(), ActionListener.wrap(result -> {
            Long modelSizeInBytes = (Long)result.get("model_size_in_bytes");
            if (modelSizeInBytes >= 0x100000000L) {
                throw new MLException("Model file size exceeds the limit of 4GB: " + modelSizeInBytes);
            }
            List chunkFiles = (List)result.get("chunk_files");
            String hashValue = (String)result.get("model_file_hash");
            Semaphore semaphore = new Semaphore(1);
            AtomicInteger uploaded = new AtomicInteger(0);
            AtomicBoolean failedToUploadChunk = new AtomicBoolean(false);
            for (String name : chunkFiles) {
                semaphore.tryAcquire(10L, TimeUnit.SECONDS);
                if (failedToUploadChunk.get()) {
                    throw new MLException("Failed to save model chunk");
                }
                File file = new File(name);
                byte[] bytes = Files.toByteArray((File)file);
                int chunkNum = Integer.parseInt(file.getName());
                Instant now = Instant.now();
                MLModel mlModel = MLModel.builder().modelId(modelId).name(modelName).algorithm(functionName).version(version).modelFormat(registerModelInput.getModelFormat()).chunkNumber(Integer.valueOf(chunkNum)).totalChunks(Integer.valueOf(chunkFiles.size())).content(Base64.getEncoder().encodeToString(bytes)).createdTime(now).lastUpdateTime(now).build();
                IndexRequest indexRequest = new IndexRequest(".plugins-ml-model");
                String chunkId = this.getModelChunkId(modelId, chunkNum);
                indexRequest.id(chunkId);
                indexRequest.source(mlModel.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.index(indexRequest, ActionListener.wrap(r -> {
                    uploaded.getAndIncrement();
                    if (uploaded.get() == chunkFiles.size()) {
                        this.updateModelRegisterStateAsDone(registerModelInput, taskId, modelId, modelSizeInBytes, chunkFiles, hashValue);
                    } else {
                        FileUtils.deleteFileQuietly((File)file);
                    }
                    semaphore.release();
                }, e -> {
                    log.error("Failed to index model chunk " + chunkId, (Throwable)e);
                    failedToUploadChunk.set(true);
                    this.handleException(functionName, taskId, (Exception)e);
                    FileUtils.deleteFileQuietly((File)file);
                    this.deleteModel(modelId);
                    semaphore.release();
                    FileUtils.deleteFileQuietly((Path)this.mlEngine.getRegisterModelPath(modelId));
                }));
            }
        }, e -> {
            log.error("Failed to index chunk file", (Throwable)e);
            FileUtils.deleteFileQuietly((Path)this.mlEngine.getRegisterModelPath(modelId));
            this.deleteModel(modelId);
            this.handleException(functionName, taskId, (Exception)e);
        }));
    }

    private void registerPrebuiltModel(MLRegisterModelInput registerModelInput, MLTask mlTask, String modelVersion) throws PrivilegedActionException {
        String taskId = mlTask.getTaskId();
        List modelMetaList = this.modelHelper.downloadPrebuiltModelMetaList(taskId, registerModelInput);
        if (!this.modelHelper.isModelAllowed(registerModelInput, modelMetaList)) {
            throw new IllegalArgumentException("This model is not in the pre-trained model list, please check your parameters.");
        }
        this.modelHelper.downloadPrebuiltModelConfig(taskId, registerModelInput, ActionListener.wrap(mlRegisterModelInput -> this.registerModelFromUrl((MLRegisterModelInput)mlRegisterModelInput, mlTask, modelVersion), e -> {
            log.error("Failed to register prebuilt model", (Throwable)e);
            this.handleException(registerModelInput.getFunctionName(), taskId, (Exception)e);
        }));
    }

    private <T> ThreadedActionListener<T> threadedActionListener(String threadPoolName, ActionListener<T> listener) {
        return new ThreadedActionListener(log, this.threadPool, threadPoolName, listener, false);
    }

    public void checkAndAddRunningTask(MLTask mlTask, Integer runningTaskLimit) {
        MLNodeUtils.checkOpenCircuitBreaker(this.mlCircuitBreakerService, this.mlStats);
        this.mlTaskManager.checkLimitAndAddRunningTask(mlTask, runningTaskLimit);
    }

    private void updateModelRegisterStateAsDone(MLRegisterModelInput registerModelInput, String taskId, String modelId, Long modelSizeInBytes, List<String> chunkFiles, String hashValue) {
        FunctionName functionName = registerModelInput.getFunctionName();
        FileUtils.deleteFileQuietly((Path)this.mlEngine.getRegisterModelPath(modelId));
        ImmutableMap updatedFields = ImmutableMap.of((Object)"model_state", (Object)MLModelState.REGISTERED, (Object)"last_registered_time", (Object)Instant.now().toEpochMilli(), (Object)"total_chunks", (Object)chunkFiles.size(), (Object)"model_content_hash_value", (Object)hashValue, (Object)"model_content_size_in_bytes", (Object)modelSizeInBytes);
        log.info("Model registered successfully, model id: {}, task id: {}", (Object)modelId, (Object)taskId);
        this.updateModel(modelId, (Map<String, Object>)updatedFields, (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
            this.mlTaskManager.updateMLTask(taskId, (Map<String, Object>)ImmutableMap.of((Object)"state", (Object)MLTaskState.COMPLETED, (Object)"model_id", (Object)modelId), 5000L, true);
            if (registerModelInput.isDeployModel()) {
                this.deployModelAfterRegistering(registerModelInput, modelId);
            }
        }, e -> {
            log.error("Failed to update model", (Throwable)e);
            this.handleException(functionName, taskId, (Exception)e);
            this.deleteModel(modelId);
        }));
    }

    private void deployModelAfterRegistering(MLRegisterModelInput registerModelInput, String modelId) {
        Object[] modelNodeIds = registerModelInput.getModelNodeIds();
        log.debug("start deploying model after registering, modelId: {} on nodes: {}", (Object)modelId, (Object)Arrays.toString(modelNodeIds));
        MLDeployModelRequest request = new MLDeployModelRequest(modelId, (String[])modelNodeIds, false, true);
        ActionListener listener = ActionListener.wrap(r -> log.debug("model deployed, response {}", r), e -> log.error("Failed to deploy model", (Throwable)e));
        this.client.execute((ActionType)MLDeployModelAction.INSTANCE, (ActionRequest)request, listener);
    }

    private void deleteModel(String modelId) {
        DeleteRequest deleteRequest = new DeleteRequest();
        ((DeleteRequest)deleteRequest.index(".plugins-ml-model")).id(modelId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.delete(deleteRequest);
        DeleteByQueryRequest deleteChunksRequest = (DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{".plugins-ml-model"}).setQuery((QueryBuilder)new TermQueryBuilder("model_id", modelId)).setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN).setAbortOnVersionConflict(false);
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteChunksRequest);
    }

    private void handleException(FunctionName functionName, String taskId, Exception e) {
        if (!(e instanceof MLLimitExceededException || e instanceof MLResourceNotFoundException || e instanceof IllegalArgumentException)) {
            this.mlStats.createCounterStatIfAbsent(functionName, ActionName.REGISTER, MLActionLevelStat.ML_ACTION_FAILURE_COUNT).increment();
            this.mlStats.getStat(MLNodeLevelStat.ML_FAILURE_COUNT).increment();
        }
        ImmutableMap updated = ImmutableMap.of((Object)"error", (Object)MLExceptionUtils.getRootCauseMessage(e), (Object)"state", (Object)MLTaskState.FAILED);
        this.mlTaskManager.updateMLTask(taskId, (Map<String, Object>)updated, 5000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployModel(String modelId, String modelContentHash, FunctionName functionName, boolean deployToAllNodes, MLTask mlTask, ActionListener<String> listener) {
        this.mlStats.createCounterStatIfAbsent(functionName, ActionName.DEPLOY, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
        this.mlStats.getStat(MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).increment();
        this.mlStats.getStat(MLNodeLevelStat.ML_REQUEST_COUNT).increment();
        List workerNodes = mlTask.getWorkerNodes();
        if (this.modelCacheHelper.isModelDeployed(modelId)) {
            if (workerNodes != null && workerNodes.size() > 0) {
                log.info("Set new target node ids {} for model {}", (Object)Arrays.toString(workerNodes.toArray(new String[0])), (Object)modelId);
                this.modelCacheHelper.setDeployToAllNodes(modelId, deployToAllNodes);
                this.modelCacheHelper.setTargetWorkerNodes(modelId, workerNodes);
            }
            listener.onResponse((Object)"successful");
            return;
        }
        if (this.modelCacheHelper.getLocalDeployedModels().length >= this.maxModelPerNode) {
            listener.onFailure((Exception)new IllegalArgumentException("Exceed max local model per node limit"));
            return;
        }
        this.modelCacheHelper.initModelState(modelId, MLModelState.DEPLOYING, functionName, workerNodes, deployToAllNodes);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.checkAndAddRunningTask(mlTask, this.maxDeployTasksPerNode);
            this.getModel(modelId, (ActionListener<MLModel>)this.threadedActionListener("opensearch_ml_deploy", ActionListener.wrap(mlModel -> {
                if (FunctionName.REMOTE == mlModel.getAlgorithm() || !FunctionName.isDLModel((FunctionName)mlModel.getAlgorithm()) && mlModel.getAlgorithm() != FunctionName.METRICS_CORRELATION) {
                    ImmutableMap params = ImmutableMap.of((Object)"ml_engine", (Object)this.mlEngine, (Object)"script_service", (Object)this.scriptService, (Object)"client", (Object)this.client, (Object)"xcontent_registry", (Object)this.xContentRegistry, (Object)"cluster_service", (Object)this.clusterService);
                    if (mlModel.getConnector() != null) {
                        this.setupPredictable(modelId, (MLModel)mlModel, (Map<String, Object>)params);
                        listener.onResponse((Object)"successful");
                        return;
                    }
                    log.info("Set connector {} for the model: {}", (Object)mlModel.getConnectorId(), (Object)modelId);
                    GetRequest getConnectorRequest = new GetRequest();
                    FetchSourceContext fetchContext = new FetchSourceContext(true, null, null);
                    ((GetRequest)getConnectorRequest.index(".plugins-ml-connector")).id(mlModel.getConnectorId()).fetchSourceContext(fetchContext);
                    this.client.get(getConnectorRequest, ActionListener.wrap(arg_0 -> this.lambda$deployModel$33(mlModel, modelId, (Map)params, listener, arg_0), e -> listener.onFailure(e)));
                    return;
                }
                MLNodeUtils.checkOpenCircuitBreaker(this.mlCircuitBreakerService, this.mlStats);
                this.retrieveModelChunks((MLModel)mlModel, (ActionListener<File>)ActionListener.wrap(modelZipFile -> {
                    String hash = FileUtils.calculateFileHash((File)modelZipFile);
                    if (modelContentHash != null && !modelContentHash.equals(hash)) {
                        log.error("Model content hash can't match original hash value");
                        this.removeModel(modelId);
                        listener.onFailure((Exception)new IllegalArgumentException("model content changed"));
                        return;
                    }
                    log.debug("Model content matches original hash value, continue deploying");
                    ImmutableMap params = ImmutableMap.of((Object)"model_zip_file", (Object)modelZipFile, (Object)"model_helper", (Object)this.modelHelper, (Object)"ml_engine", (Object)this.mlEngine);
                    if (FunctionName.METRICS_CORRELATION.equals((Object)mlModel.getAlgorithm())) {
                        MLExecutable mlExecutable = this.mlEngine.deployExecute(mlModel, (Map)params);
                        try {
                            this.modelCacheHelper.setMLExecutor(modelId, mlExecutable);
                            this.mlStats.getStat(MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).increment();
                            this.modelCacheHelper.setModelState(modelId, MLModelState.DEPLOYED);
                            listener.onResponse((Object)"successful");
                        }
                        catch (Exception e) {
                            log.error("Failed to add predictor to cache", (Throwable)e);
                            mlExecutable.close();
                            listener.onFailure(e);
                        }
                    } else {
                        Predictable predictable = this.mlEngine.deploy(mlModel, (Map)params);
                        try {
                            this.modelCacheHelper.setPredictor(modelId, predictable);
                            this.mlStats.getStat(MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).increment();
                            this.modelCacheHelper.setModelState(modelId, MLModelState.DEPLOYED);
                            Long modelContentSizeInBytes = mlModel.getModelContentSizeInBytes();
                            long contentSize = modelContentSizeInBytes == null ? (long)(mlModel.getTotalChunks() * 10000000) : modelContentSizeInBytes;
                            this.modelCacheHelper.setMemSizeEstimation(modelId, mlModel.getModelFormat(), contentSize);
                            listener.onResponse((Object)"successful");
                        }
                        catch (Exception e) {
                            log.error("Failed to add predictor to cache", (Throwable)e);
                            predictable.close();
                            listener.onFailure(e);
                        }
                    }
                }, e -> {
                    log.error("Failed to retrieve model " + modelId, (Throwable)e);
                    this.handleDeployModelException(modelId, functionName, listener, (Exception)e);
                }));
            }, e -> {
                log.error("Failed to deploy model " + modelId, (Throwable)e);
                this.handleDeployModelException(modelId, functionName, listener, (Exception)e);
            })));
        }
        catch (Exception e2) {
            this.handleDeployModelException(modelId, functionName, listener, e2);
        }
        finally {
            this.mlStats.getStat(MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).decrement();
        }
    }

    private void handleDeployModelException(String modelId, FunctionName functionName, ActionListener<String> listener, Exception e) {
        if (!(e instanceof MLLimitExceededException || e instanceof MLResourceNotFoundException || e instanceof IllegalArgumentException)) {
            this.mlStats.createCounterStatIfAbsent(functionName, ActionName.DEPLOY, MLActionLevelStat.ML_ACTION_FAILURE_COUNT).increment();
            this.mlStats.getStat(MLNodeLevelStat.ML_FAILURE_COUNT).increment();
        }
        this.removeModel(modelId);
        listener.onFailure(e);
    }

    private void setupPredictable(String modelId, MLModel mlModel, Map<String, Object> params) {
        Predictable predictable = this.mlEngine.deploy(mlModel, params);
        this.modelCacheHelper.setPredictor(modelId, predictable);
        this.mlStats.getStat(MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).increment();
        this.modelCacheHelper.setModelState(modelId, MLModelState.DEPLOYED);
    }

    public void getModel(String modelId, ActionListener<MLModel> listener) {
        this.getModel(modelId, null, null, listener);
    }

    public void getModel(String modelId, String[] includes, String[] excludes, ActionListener<MLModel> listener) {
        GetRequest getRequest = new GetRequest();
        FetchSourceContext fetchContext = new FetchSourceContext(true, includes, excludes);
        ((GetRequest)getRequest.index(".plugins-ml-model")).id(modelId).fetchSourceContext(fetchContext);
        this.client.get(getRequest, ActionListener.wrap(r -> {
            if (r != null && r.isExists()) {
                try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    GetResponse getResponse = r;
                    String algorithmName = getResponse.getSource().get("algorithm").toString();
                    MLModel mlModel = MLModel.parse((XContentParser)parser, (String)algorithmName);
                    mlModel.setModelId(modelId);
                    listener.onResponse((Object)mlModel);
                }
                catch (Exception e) {
                    log.error("Failed to parse ml task" + r.getId(), (Throwable)e);
                    listener.onFailure(e);
                }
            } else {
                listener.onFailure((Exception)new OpenSearchStatusException("Failed to find model", RestStatus.NOT_FOUND, new Object[0]));
            }
        }, e -> listener.onFailure(e)));
    }

    private void retrieveModelChunks(MLModel mlModelMeta, ActionListener<File> listener) throws InterruptedException {
        String modelId = mlModelMeta.getModelId();
        String modelName = mlModelMeta.getName();
        Integer totalChunks = mlModelMeta.getTotalChunks();
        GetRequest getRequest = new GetRequest();
        getRequest.index(".plugins-ml-model");
        getRequest.id();
        Semaphore semaphore = new Semaphore(1);
        AtomicBoolean stopNow = new AtomicBoolean(false);
        String modelZip = this.mlEngine.getDeployModelZipPath(modelId, modelName);
        ConcurrentLinkedDeque chunkFiles = new ConcurrentLinkedDeque();
        AtomicInteger retrievedChunks = new AtomicInteger(0);
        int i = 0;
        while (i < totalChunks) {
            semaphore.tryAcquire(10L, TimeUnit.SECONDS);
            if (stopNow.get()) {
                throw new MLException("Failed to deploy model");
            }
            String modelChunkId = this.getModelChunkId(modelId, i);
            int currentChunk = i++;
            this.getModel(modelChunkId, (ActionListener<MLModel>)this.threadedActionListener("opensearch_ml_deploy", ActionListener.wrap(model -> {
                Path chunkPath = this.mlEngine.getDeployModelChunkPath(modelId, Integer.valueOf(currentChunk));
                FileUtils.write((byte[])Base64.getDecoder().decode(model.getContent()), (String)chunkPath.toString());
                chunkFiles.add(new File(chunkPath.toUri()));
                retrievedChunks.getAndIncrement();
                if (retrievedChunks.get() == totalChunks.intValue()) {
                    File modelZipFile = new File(modelZip);
                    FileUtils.mergeFiles((Queue)chunkFiles, (File)modelZipFile);
                    listener.onResponse((Object)modelZipFile);
                }
                semaphore.release();
            }, e -> {
                stopNow.set(true);
                semaphore.release();
                log.error("Failed to retrieve model chunk " + modelChunkId, (Throwable)e);
                if (retrievedChunks.get() == totalChunks - 1) {
                    listener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model chunk " + modelChunkId));
                }
            })));
        }
    }

    public void updateModel(String modelId, Map<String, Object> updatedFields) {
        this.updateModel(modelId, updatedFields, (ActionListener<UpdateResponse>)ActionListener.wrap(response -> {
            if (response.status() == RestStatus.OK) {
                log.debug("Updated ML model successfully: {}, model id: {}", (Object)response.status(), (Object)modelId);
            } else {
                log.error("Failed to update ML model {}, status: {}", (Object)modelId, (Object)response.status());
            }
        }, e -> log.error("Failed to update ML model: " + modelId, (Throwable)e)));
    }

    public void updateModel(String modelId, Map<String, Object> updatedFields, ActionListener<UpdateResponse> listener) {
        if (updatedFields == null || updatedFields.size() == 0) {
            listener.onFailure((Exception)new IllegalArgumentException("Updated fields is null or empty"));
            return;
        }
        HashMap<String, Object> newUpdatedFields = new HashMap<String, Object>();
        newUpdatedFields.putAll(updatedFields);
        newUpdatedFields.put("last_updated_time", Instant.now().toEpochMilli());
        UpdateRequest updateRequest = new UpdateRequest(".plugins-ml-model", modelId);
        updateRequest.doc(newUpdatedFields);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        if (newUpdatedFields.containsKey("model_state") && MODEL_DONE_STATES.contains(newUpdatedFields.get("model_state"))) {
            updateRequest.retryOnConflict(3);
        }
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.update(updateRequest, ActionListener.runBefore(listener, () -> context.restore()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public String getModelChunkId(String modelId, Integer chunkNumber) {
        return modelId + "_" + chunkNumber;
    }

    public void addModelWorkerNode(String modelId, String ... nodeIds) {
        if (nodeIds != null) {
            for (String nodeId : nodeIds) {
                this.modelCacheHelper.addWorkerNode(modelId, nodeId);
            }
        }
    }

    public void addModelWorkerNodes(List<String> nodeIds) {
        if (nodeIds != null) {
            String[] modelIds = this.getAllModelIds();
            for (String nodeId : nodeIds) {
                Arrays.stream(modelIds).forEach(x -> this.modelCacheHelper.addWorkerNode((String)x, nodeId));
            }
        }
    }

    public void removeModelWorkerNode(String modelId, boolean isFromUndeploy, String ... nodeIds) {
        if (nodeIds != null) {
            for (String nodeId : nodeIds) {
                this.modelCacheHelper.removeWorkerNode(modelId, nodeId, isFromUndeploy);
            }
        }
    }

    public void removeWorkerNodes(Set<String> removedNodes, boolean isFromUndeploy) {
        this.modelCacheHelper.removeWorkerNodes(removedNodes, isFromUndeploy);
    }

    public synchronized Map<String, String> undeployModel(String[] modelIds) {
        HashMap<String, String> modelUndeployStatus = new HashMap<String, String>();
        if (modelIds != null && modelIds.length > 0) {
            log.debug("undeploy models {}", (Object)Arrays.toString(modelIds));
            for (String modelId : modelIds) {
                if (this.modelCacheHelper.isModelDeployed(modelId)) {
                    modelUndeployStatus.put(modelId, "undeployed");
                    this.mlStats.getStat(MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).decrement();
                    this.mlStats.getStat(MLNodeLevelStat.ML_REQUEST_COUNT).increment();
                    this.mlStats.createCounterStatIfAbsent(this.getModelFunctionName(modelId), ActionName.UNDEPLOY, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
                } else {
                    modelUndeployStatus.put(modelId, "not_found");
                }
                this.removeModel(modelId);
            }
        } else {
            log.debug("undeploy all models {}", (Object)Arrays.toString(this.getLocalDeployedModels()));
            for (String modelId : this.getLocalDeployedModels()) {
                modelUndeployStatus.put(modelId, "undeployed");
                this.mlStats.getStat(MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT).decrement();
                this.mlStats.createCounterStatIfAbsent(this.getModelFunctionName(modelId), ActionName.UNDEPLOY, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
                this.removeModel(modelId);
            }
        }
        return modelUndeployStatus;
    }

    private void removeModel(String modelId) {
        this.modelCacheHelper.removeModel(modelId);
        this.modelHelper.deleteFileCache(modelId);
    }

    public String[] getWorkerNodes(String modelId, FunctionName functionName, boolean onlyEligibleNode) {
        String[] workerNodeIds = this.modelCacheHelper.getWorkerNodes(modelId);
        if (!onlyEligibleNode) {
            return workerNodeIds;
        }
        if (workerNodeIds == null || workerNodeIds.length == 0) {
            return workerNodeIds;
        }
        String[] eligibleNodeIds = this.nodeHelper.filterEligibleNodes(functionName, workerNodeIds);
        if (eligibleNodeIds == null || eligibleNodeIds.length == 0) {
            throw new IllegalArgumentException("No eligible worker node found");
        }
        return eligibleNodeIds;
    }

    public String[] getWorkerNodes(String modelId, FunctionName functionName) {
        return this.getWorkerNodes(modelId, functionName, false);
    }

    public Predictable getPredictor(String modelId) {
        return this.modelCacheHelper.getPredictor(modelId);
    }

    public String[] getAllModelIds() {
        return this.modelCacheHelper.getAllModels();
    }

    public String[] getLocalDeployedModels() {
        return this.modelCacheHelper.getDeployedModels();
    }

    public synchronized void syncModelWorkerNodes(Map<String, Set<String>> modelWorkerNodes) {
        this.modelCacheHelper.syncWorkerNodes(modelWorkerNodes);
    }

    public void clearRoutingTable() {
        this.modelCacheHelper.clearWorkerNodes();
    }

    public MLModelProfile getModelProfile(String modelId) {
        return this.modelCacheHelper.getModelProfile(modelId);
    }

    public <T> T trackPredictDuration(String modelId, Supplier<T> supplier) {
        long start = System.nanoTime();
        T t = supplier.get();
        long end = System.nanoTime();
        double durationInMs = (double)(end - start) / 1000000.0;
        this.modelCacheHelper.addModelInferenceDuration(modelId, durationInMs);
        return t;
    }

    public FunctionName getModelFunctionName(String modelId) {
        return this.modelCacheHelper.getFunctionName(modelId);
    }

    public Optional<FunctionName> getOptionalModelFunctionName(String modelId) {
        return this.modelCacheHelper.getOptionalFunctionName(modelId);
    }

    public boolean isModelRunningOnNode(String modelId) {
        return this.modelCacheHelper.isModelRunningOnNode(modelId);
    }

    private /* synthetic */ void lambda$deployModel$33(MLModel mlModel, String modelId, Map params, ActionListener listener, GetResponse getResponse) throws Exception {
        if (getResponse != null && getResponse.isExists()) {
            try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, getResponse.getSourceAsBytesRef());){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                Connector connector = Connector.createConnector((XContentParser)parser);
                mlModel.setConnector(connector);
                this.setupPredictable(modelId, mlModel, params);
                listener.onResponse((Object)"successful");
                log.info("Completed setting connector {} in the model {}", (Object)mlModel.getConnectorId(), (Object)modelId);
            }
        }
    }
}

