/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import lombok.Generated;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.stats.ActionName;
import org.opensearch.ml.stats.MLActionLevelStat;
import org.opensearch.ml.stats.MLActionStats;
import org.opensearch.ml.stats.MLStat;
import org.opensearch.ml.stats.suppliers.CounterSupplier;

public class MLStats {
    private Map<Enum, MLStat<?>> stats;
    private Map<FunctionName, Map<ActionName, Map<MLActionLevelStat, MLStat>>> algoStats;

    public MLStats(Map<Enum, MLStat<?>> stats) {
        this.stats = stats;
        this.algoStats = new ConcurrentHashMap<FunctionName, Map<ActionName, Map<MLActionLevelStat, MLStat>>>();
    }

    public MLStat<?> getStat(Enum key) throws IllegalArgumentException {
        if (!this.stats.keySet().contains(key)) {
            throw new IllegalArgumentException("Stat \"" + key + "\" does not exist");
        }
        return this.stats.get(key);
    }

    public MLStat<?> createCounterStatIfAbsent(Enum key) {
        return this.createStatIfAbsent(key, () -> new MLStat<Long>(false, new CounterSupplier()));
    }

    public MLStat<?> createCounterStatIfAbsent(FunctionName algoName, ActionName action, MLActionLevelStat stat) {
        Map actionStats = this.algoStats.computeIfAbsent(algoName, it -> new ConcurrentHashMap());
        Map algoActionStats = actionStats.computeIfAbsent(action, it -> new ConcurrentHashMap());
        return this.createAlgoStatIfAbsent(algoActionStats, stat, () -> new MLStat<Long>(false, new CounterSupplier()));
    }

    public synchronized MLStat<?> createAlgoStatIfAbsent(Map<MLActionLevelStat, MLStat> algoActionStats, MLActionLevelStat key, Supplier<MLStat> supplier) {
        return algoActionStats.computeIfAbsent(key, k -> (MLStat)supplier.get());
    }

    public synchronized MLStat<?> createStatIfAbsent(Enum key, Supplier<MLStat> supplier) {
        return this.stats.computeIfAbsent(key, k -> (MLStat)supplier.get());
    }

    public Map<Enum, MLStat<?>> getNodeStats() {
        return this.getClusterOrNodeStats(false);
    }

    public Map<Enum, MLStat<?>> getClusterStats() {
        return this.getClusterOrNodeStats(true);
    }

    private Map<Enum, MLStat<?>> getClusterOrNodeStats(Boolean getClusterStats) {
        HashMap statsMap = new HashMap();
        for (Map.Entry<Enum, MLStat<?>> entry : this.stats.entrySet()) {
            if (entry.getValue().isClusterLevel() != getClusterStats.booleanValue()) continue;
            statsMap.put(entry.getKey(), entry.getValue());
        }
        return statsMap;
    }

    public Map<ActionName, MLActionStats> getAlgorithmStats(FunctionName algoName) {
        if (!this.algoStats.containsKey(algoName)) {
            return null;
        }
        HashMap<ActionName, MLActionStats> algoActionStats = new HashMap<ActionName, MLActionStats>();
        for (Map.Entry<ActionName, Map<MLActionLevelStat, MLStat>> entry : this.algoStats.get(algoName).entrySet()) {
            HashMap<MLActionLevelStat, Object> statsMap = new HashMap<MLActionLevelStat, Object>();
            for (Map.Entry<MLActionLevelStat, MLStat> state : entry.getValue().entrySet()) {
                statsMap.put(state.getKey(), state.getValue().getValue());
            }
            algoActionStats.put(entry.getKey(), new MLActionStats(statsMap));
        }
        return algoActionStats;
    }

    public FunctionName[] getAllAlgorithms() {
        return this.algoStats.keySet().toArray(new FunctionName[0]);
    }

    @Generated
    public Map<Enum, MLStat<?>> getStats() {
        return this.stats;
    }
}

