"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SYSTEM_INDEX = exports.SYSTEM_ALIAS = exports.REQUEST = exports.NODE_API = exports.BASE_API_PATH = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const BASE_API_PATH = "/api/ism";
exports.BASE_API_PATH = BASE_API_PATH;
const NODE_API = Object.freeze({
  _SEARCH: `${BASE_API_PATH}/_search`,
  _SEARCH_SAMPLE_DATA: `${BASE_API_PATH}/_searchSampleData`,
  _INDICES: `${BASE_API_PATH}/_indices`,
  _DATA_STREAMS: `${BASE_API_PATH}/_data_streams`,
  _ALIASES: `${BASE_API_PATH}/_aliases`,
  _MAPPINGS: `${BASE_API_PATH}/_mappings`,
  APPLY_POLICY: `${BASE_API_PATH}/applyPolicy`,
  EDIT_ROLLOVER_ALIAS: `${BASE_API_PATH}/editRolloverAlias`,
  POLICIES: `${BASE_API_PATH}/policies`,
  _RECOVERY: `${BASE_API_PATH}/_recovery`,
  ROLLUPS: `${BASE_API_PATH}/rollups`,
  TRANSFORMS: `${BASE_API_PATH}/transforms`,
  MANAGED_INDICES: `${BASE_API_PATH}/managedIndices`,
  CHANNELS: `${BASE_API_PATH}/_notifications/channels`,
  RETRY: `${BASE_API_PATH}/retry`,
  CHANGE_POLICY: `${BASE_API_PATH}/changePolicy`,
  REMOVE_POLICY: `${BASE_API_PATH}/removePolicy`,
  SMPolicies: `${BASE_API_PATH}/smPolicies`,
  _SNAPSHOTS: `${BASE_API_PATH}/_snapshots`,
  _REPOSITORIES: `${BASE_API_PATH}/_repositores`,
  PUT_INDEX: `${BASE_API_PATH}/putIndex`,
  API_CALLER: `${BASE_API_PATH}/apiCaller`
});
exports.NODE_API = NODE_API;
const REQUEST = Object.freeze({
  PUT: "PUT",
  DELETE: "DELETE",
  GET: "GET",
  POST: "POST",
  HEAD: "HEAD"
});
exports.REQUEST = REQUEST;
const SYSTEM_INDEX = [".plugins-ml-model", ".plugins-ml-task", ".opendistro-alerting-config", ".opendistro-alerting-alert*", ".opendistro-anomaly-results*", ".opendistro-anomaly-detector*", ".opendistro-anomaly-checkpoints", ".opendistro-anomaly-detection-state", ".opendistro-reports-*", ".opensearch-notifications-*", ".opensearch-notebooks", ".opensearch-observability", ".opendistro-asynchronous-search-response*", ".opendistro_security", ".opendistro-job-scheduler-lock", ".opendistro-ism-config", ".replication-metadata-store", "kibana*", ".kibana*", ".tasks"];
exports.SYSTEM_INDEX = SYSTEM_INDEX;
const SYSTEM_ALIAS = [".plugins*", ".opendistro*", ".opensearch*", ".replication-metadata-store", "kibana*", ".kibana*", ".tasks"];
exports.SYSTEM_ALIAS = SYSTEM_ALIAS;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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