/// <reference types="node" />
import * as fs from 'fs';
declare function copy(sourcePath: string, targetPath: string, options?: copy.Options): Promise<copy.Totals>;
declare namespace copy {
    type Options = {
        overwrite?: boolean;
        errorOnExist?: boolean;
        dereference?: boolean;
        preserveTimestamps?: boolean;
        dryRun?: boolean;
        rename?: (source: Source, target: Target, options: Options) => string | void | Promise<string | void>;
        filter?: (source: Source, target: Target, options: Options) => boolean | Promise<boolean>;
        transform?: (data: Buffer, source: Source, target: Target, options: Options) => Buffer | Promise<Buffer>;
        afterEach?: (source: Source, target: Target, options: Options) => void | Promise<void>;
    };
    type Source = {
        path: string;
        stats: fs.Stats;
    };
    type Target = {
        path: string;
        stats?: fs.Stats;
    };
    type Totals = {
        directories: number;
        files: number;
        symlinks: number;
        size: number;
    };
}
export = copy;
