"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDslRoute = registerDslRoute;

var _configSchema = require("@osd/config-schema");

var _metrics = require("../metrics");

var _common = require("../../common");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const performance = require('perf_hooks').performance;

function registerDslRoute(router) {
  router.post({
    path: _common.ServiceEndpoints.GetSearchResults,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const {
      query1,
      query2
    } = request.body;
    const actionName = query1 && query2 ? _metrics.METRIC_ACTION.COMPARISON_SEARCH : _metrics.METRIC_ACTION.SINGLE_SEARCH;
    let resBody = {};

    if (query1) {
      const {
        index,
        size,
        ...rest
      } = query1;
      const params = {
        index,
        size,
        body: rest
      };
      const start = performance.now();

      try {
        const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
        const end = performance.now();
        context.searchRelevance.metricsService.addMetric(_metrics.METRIC_NAME.SEARCH_RELEVANCE, actionName, 200, end - start);
        resBody.result1 = resp;
      } catch (error) {
        var _error$body, _error$body$error, _error$body2, _error$body2$error;

        const end = performance.now();
        context.searchRelevance.metricsService.addMetric(_metrics.METRIC_NAME.SEARCH_RELEVANCE, actionName, error.statusCode, end - start);
        if (error.statusCode !== 404) console.error(error); // Template: Error: {{Error.type}} – {{Error.reason}}

        const errorMessage = `Error: ${(_error$body = error.body) === null || _error$body === void 0 ? void 0 : (_error$body$error = _error$body.error) === null || _error$body$error === void 0 ? void 0 : _error$body$error.type} - ${(_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : (_error$body2$error = _error$body2.error) === null || _error$body2$error === void 0 ? void 0 : _error$body2$error.reason}`;
        resBody.errorMessage1 = {
          statusCode: error.statusCode || 500,
          body: errorMessage
        };
      }
    }

    if (query2) {
      const {
        index,
        size,
        ...rest
      } = query2;
      const params = {
        index,
        size,
        body: rest
      };
      const start = performance.now();

      try {
        const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
        const end = performance.now();
        context.searchRelevance.metricsService.addMetric(_metrics.METRIC_NAME.SEARCH_RELEVANCE, actionName, 200, end - start);
        resBody.result2 = resp;
      } catch (error) {
        var _error$body3, _error$body3$error, _error$body4, _error$body4$error;

        const end = performance.now();
        if (error.statusCode !== 404) console.error(error);
        context.searchRelevance.metricsService.addMetric(_metrics.METRIC_NAME.SEARCH_RELEVANCE, actionName, error.statusCode, end - start); // Template: Error: {{Error.type}} – {{Error.reason}}

        const errorMessage = `Error: ${(_error$body3 = error.body) === null || _error$body3 === void 0 ? void 0 : (_error$body3$error = _error$body3.error) === null || _error$body3$error === void 0 ? void 0 : _error$body3$error.type} - ${(_error$body4 = error.body) === null || _error$body4 === void 0 ? void 0 : (_error$body4$error = _error$body4.error) === null || _error$body4$error === void 0 ? void 0 : _error$body4$error.reason}`;
        resBody.errorMessage2 = {
          statusCode: error.statusCode || 500,
          body: errorMessage
        };
      }
    }

    return response.ok({
      body: resBody
    });
  });
  router.get({
    path: _common.ServiceEndpoints.GetIndexes,
    validate: {}
  }, async (context, request, response) => {
    const params = {
      format: 'json'
    };
    const start = performance.now();

    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('cat.indices', params);
      const end = performance.now();
      context.searchRelevance.metricsService.addMetric(_metrics.METRIC_NAME.SEARCH_RELEVANCE, _metrics.METRIC_ACTION.FETCH_INDEX, 200, end - start);
      return response.ok({
        body: resp
      });
    } catch (error) {
      const end = performance.now();
      context.searchRelevance.metricsService.addMetric(_metrics.METRIC_NAME.SEARCH_RELEVANCE, _metrics.METRIC_ACTION.FETCH_INDEX, error.statusCode, end - start);
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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