# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.repository.bundles.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class OvfDeployInfo(VapiInterface):
    """
    
    """
    GET_PRODUCT_SAMPLE = "SAMPLE"
    """
    Possible value for ``product`` of method :func:`OvfDeployInfo.get`.

    """
    GET_PRODUCT_ALB_CONTROLLER = "ALB_CONTROLLER"
    """
    Possible value for ``product`` of method :func:`OvfDeployInfo.get`.

    """
    GET_PRODUCT_INTELLIGENCE = "INTELLIGENCE"
    """
    Possible value for ``product`` of method :func:`OvfDeployInfo.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.repository.bundles.ovf_deploy_info'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _OvfDeployInfoStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            product,
            ):
        """
        Get information of the OVF for specified appliance which is present in
        repository and will be used to deploy new VM.

        :type  product: :class:`str`
        :param product: Name of the appliance (required)
        :rtype: :class:`com.vmware.nsx.model_client.OvfInfo`
        :return: com.vmware.nsx.model.OvfInfo
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'product': product,
                            })
class UploadAllowed(VapiInterface):
    """
    
    """
    GET_PRODUCT_SAMPLE = "SAMPLE"
    """
    Possible value for ``product`` of method :func:`UploadAllowed.get`.

    """
    GET_PRODUCT_ALB_CONTROLLER = "ALB_CONTROLLER"
    """
    Possible value for ``product`` of method :func:`UploadAllowed.get`.

    """
    GET_PRODUCT_INTELLIGENCE = "INTELLIGENCE"
    """
    Possible value for ``product`` of method :func:`UploadAllowed.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.repository.bundles.upload_allowed'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _UploadAllowedStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            product,
            ):
        """
        Checks whether bundle upload is allowed on given node for given
        appliance. There are different kinds of checks for different
        appliances. Some of the checks for Intelligence appliance are as
        follows: 1. Is bundle upload-allowed on given node 2. Is bundle upload
        already in-progress

        :type  product: :class:`str`
        :param product: Name of the appliance (required)
        :rtype: :class:`com.vmware.nsx.model_client.BundleUploadPermission`
        :return: com.vmware.nsx.model.BundleUploadPermission
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'product': product,
                            })
class UploadStatus(VapiInterface):
    """
    
    """
    GET_PRODUCT_SAMPLE = "SAMPLE"
    """
    Possible value for ``product`` of method :func:`UploadStatus.get`.

    """
    GET_PRODUCT_ALB_CONTROLLER = "ALB_CONTROLLER"
    """
    Possible value for ``product`` of method :func:`UploadStatus.get`.

    """
    GET_PRODUCT_INTELLIGENCE = "INTELLIGENCE"
    """
    Possible value for ``product`` of method :func:`UploadStatus.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.repository.bundles.upload_status'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _UploadStatusStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            bundle_id,
            product,
            ):
        """
        Get uploaded bundle upload status

        :type  bundle_id: :class:`str`
        :param bundle_id: (required)
        :type  product: :class:`str`
        :param product: Name of the appliance (required)
        :rtype: :class:`com.vmware.nsx.model_client.BundleUploadStatus`
        :return: com.vmware.nsx.model.BundleUploadStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'bundle_id': bundle_id,
                            'product': product,
                            })
class _OvfDeployInfoStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'product': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/repository/bundles/ovf-deploy-info',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
                'product': 'product',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'OvfInfo'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.repository.bundles.ovf_deploy_info',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _UploadAllowedStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'product': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/repository/bundles/upload-allowed',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
                'product': 'product',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'BundleUploadPermission'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.repository.bundles.upload_allowed',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _UploadStatusStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'bundle_id': type.StringType(),
            'product': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/repository/bundles/{bundle-id}/upload-status',
            path_variables={
                'bundle_id': 'bundle-id',
            },
             header_parameters={
                 },
            query_parameters={
                'product': 'product',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'BundleUploadStatus'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.repository.bundles.upload_status',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'OvfDeployInfo': OvfDeployInfo,
        'UploadAllowed': UploadAllowed,
        'UploadStatus': UploadStatus,
    }

