# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes.vteps.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Actions(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes.vteps.actions'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ActionsStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               site_id,
               enforcementpoint_id,
               host_transport_node_id,
               transport_node_vtep_action,
               ):
        """
        Submit a new VTEP action for a particular TransportNode. The status of
        submitted actions could be retrieved using the
        ListTransportNodeVtepActionsStatus API.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  host_transport_node_id: :class:`str`
        :param host_transport_node_id: (required)
        :type  transport_node_vtep_action: :class:`vmware.vapi.struct.VapiStruct`
        :param transport_node_vtep_action: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.TransportNodeVtepAction`.
        :rtype: :class:`com.vmware.nsx_policy.model_client.TransportNodeVtepActionReference`
        :return: com.vmware.nsx_policy.model.TransportNodeVtepActionReference
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('create',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'host_transport_node_id': host_transport_node_id,
                            'transport_node_vtep_action': transport_node_vtep_action,
                            })
class _ActionsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'host_transport_node_id': type.StringType(),
            'transport_node_vtep_action': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'TransportNodeVtepAction')]),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/host-transport-nodes/{host-transport-node-id}/vteps/actions',
            request_body_parameter='transport_node_vtep_action',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'host_transport_node_id': 'host-transport-node-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TransportNodeVtepActionReference'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes.vteps.actions',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Actions': Actions,
        'actions': 'com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes.vteps.actions_client.StubFactory',
    }

