/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.widgets.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BE\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rBE\b\u0000\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0010J<\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u001c\u001a\u00020\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u001d\u001a\u00020\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J,\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u001f\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140 2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010&\u001a\u00020\u0003H\u0016J\u001f\u0010'\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b(J(\u0010)\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006*"}, d2={"Lcom/github/ajalt/mordant/widgets/Text;", "Lcom/github/ajalt/mordant/rendering/Widget;", "text", "", "whitespace", "Lcom/github/ajalt/mordant/rendering/Whitespace;", "align", "Lcom/github/ajalt/mordant/rendering/TextAlign;", "overflowWrap", "Lcom/github/ajalt/mordant/rendering/OverflowWrap;", "width", "", "tabWidth", "(Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/Whitespace;Lcom/github/ajalt/mordant/rendering/TextAlign;Lcom/github/ajalt/mordant/rendering/OverflowWrap;Ljava/lang/Integer;Ljava/lang/Integer;)V", "lines", "Lcom/github/ajalt/mordant/rendering/Lines;", "(Lcom/github/ajalt/mordant/rendering/Lines;Lcom/github/ajalt/mordant/rendering/Whitespace;Lcom/github/ajalt/mordant/rendering/TextAlign;Lcom/github/ajalt/mordant/rendering/OverflowWrap;Ljava/lang/Integer;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "alignLine", "", "Lcom/github/ajalt/mordant/rendering/Span;", "line", "wrapWidth", "endStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "alignLineCenter", "", "extraWidth", "alignLineLeft", "alignLineRight", "justifyLine", "lastNonWhitespace", "", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "render", "toString", "withAlign", "withAlign$mordant", "wrap", "mordant"})
public final class Text
implements Widget {
    @NotNull
    private final Lines lines;
    @NotNull
    private final Whitespace whitespace;
    @NotNull
    private final TextAlign align;
    @NotNull
    private final OverflowWrap overflowWrap;
    @Nullable
    private final Integer width;
    @Nullable
    private final Integer tabWidth;

    public Text(@NotNull Lines lines, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width, @Nullable Integer tabWidth) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter((Object)whitespace2, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        this.lines = lines;
        this.whitespace = whitespace2;
        this.align = align;
        this.overflowWrap = overflowWrap2;
        this.width = width;
        this.tabWidth = tabWidth;
        boolean bl = this.width == null || this.width >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "width cannot be negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.tabWidth == null || this.tabWidth >= 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "tab width cannot be negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Text(Lines lines, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n3 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n3 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n3 & 0x10) != 0) {
            n = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        this(lines, whitespace2, textAlign2, overflowWrap2, n, n2);
    }

    public Text(@NotNull String text, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width, @Nullable Integer tabWidth) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter((Object)whitespace2, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        this(ParsingKt.parseText(text, ConstantsKt.getDEFAULT_STYLE()), whitespace2, align, overflowWrap2, width, tabWidth);
    }

    public /* synthetic */ Text(String string, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n3 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n3 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n3 & 0x10) != 0) {
            n = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        this(string, whitespace2, textAlign2, overflowWrap2, n, n2);
    }

    @NotNull
    public final Text withAlign$mordant(@NotNull TextAlign align, @Nullable OverflowWrap overflowWrap2) {
        Text text;
        Intrinsics.checkNotNullParameter((Object)align, "align");
        if (align == this.align && (overflowWrap2 == null || overflowWrap2 == this.overflowWrap)) {
            text = this;
        } else {
            OverflowWrap overflowWrap3 = overflowWrap2;
            OverflowWrap overflowWrap4 = overflowWrap3 == null ? this.overflowWrap : overflowWrap3;
            text = new Text(this.lines, this.whitespace, align, overflowWrap4, this.width, this.tabWidth);
        }
        return text;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t, int width) {
        Comparable comparable;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(t, "t");
        Integer n = this.width;
        int n2 = n == null ? width : n;
        n = this.tabWidth;
        Lines lines = this.wrap(n2, n == null ? t.getTabWidth() : n.intValue(), TextAlign.NONE, OverflowWrap.NORMAL);
        Object object3 = lines.getLines();
        boolean bl = false;
        Iterator iterator2 = object3.iterator();
        if (!iterator2.hasNext()) {
            object2 = null;
        } else {
            Iterator iterator3;
            Comparable comparable2;
            Line l = (Line)iterator2.next();
            boolean bl2 = false;
            Iterable iterable = l;
            boolean bl3 = false;
            Iterator iterator4 = iterable.iterator();
            if (!iterator4.hasNext()) {
                comparable2 = null;
            } else {
                Span it = (Span)iterator4.next();
                boolean bl4 = false;
                iterator3 = it.getCellWidth$mordant();
                while (iterator4.hasNext()) {
                    Object it2 = (Span)iterator4.next();
                    bl6 = false;
                    if (iterator3.compareTo(it2 = (Comparable)Integer.valueOf(((Span)it2).getCellWidth$mordant())) >= 0) continue;
                    iterator3 = it2;
                }
                comparable2 = iterator3;
            }
            Integer n3 = (Integer)comparable2;
            object = n3 == null ? 0 : n3;
            while (iterator2.hasNext()) {
                Integer n4;
                Comparable comparable3;
                Object l2 = (Line)iterator2.next();
                $i$a$-maxOfOrNull-Text$measure$min$1 = false;
                Iterable iterable2 = (Iterable)l2;
                boolean bl5 = false;
                iterator3 = iterable2.iterator();
                if (!iterator3.hasNext()) {
                    comparable3 = null;
                } else {
                    Span it = (Span)iterator3.next();
                    boolean bl6 = false;
                    Comparable comparable4 = Integer.valueOf(it.getCellWidth$mordant());
                    while (iterator3.hasNext()) {
                        Span it3 = (Span)iterator3.next();
                        span = false;
                        Comparable comparable5 = Integer.valueOf(it3.getCellWidth$mordant());
                        if (comparable4.compareTo(comparable5) >= 0) continue;
                        comparable4 = comparable5;
                    }
                    comparable3 = comparable4;
                }
                if (object.compareTo(l2 = (Comparable)Integer.valueOf((n4 = (Integer)comparable3) == null ? 0 : n4)) >= 0) continue;
                object = l2;
            }
            object2 = object;
        }
        Integer n5 = (Integer)object2;
        int min = n5 == null ? 0 : n5;
        Iterable iterable = lines.getLines();
        boolean bl7 = false;
        object = iterable.iterator();
        if (!object.hasNext()) {
            comparable = null;
        } else {
            Line l = (Line)object.next();
            boolean bl8 = false;
            Iterable iterable3 = l;
            boolean bl9 = false;
            int n6 = 0;
            for (Object t2 : iterable3) {
                void it;
                Span span = (Span)t2;
                int n7 = n6;
                boolean bl10 = false;
                int n8 = it.getCellWidth$mordant();
                n6 = n7 + n8;
            }
            Comparable comparable6 = Integer.valueOf(n6);
            while (object.hasNext()) {
                Line l3 = (Line)object.next();
                $i$a$-maxOfOrNull-Text$measure$max$1 = false;
                Iterable iterable4 = l3;
                n6 = 0;
                int n9 = 0;
                for (Integer n3 : iterable4) {
                    void it;
                    Span span = (Span)((Object)n3);
                    int n10 = n9;
                    boolean bl11 = false;
                    int n11 = it.getCellWidth$mordant();
                    n9 = n10 + n11;
                }
                Comparable comparable7 = Integer.valueOf(n9);
                if (comparable6.compareTo(comparable7) >= 0) continue;
                comparable6 = comparable7;
            }
            comparable = comparable6;
        }
        object3 = (Integer)comparable;
        int max = object3 == null ? 0 : (Integer)object3;
        return new WidthRange(min, max);
    }

    @Override
    @NotNull
    public Lines render(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter(t, "t");
        Integer n = this.width;
        int n2 = n == null ? width : n;
        n = this.tabWidth;
        return this.wrap(n2, n == null ? t.getTabWidth() : n.intValue(), this.align, this.overflowWrap);
    }

    private final Lines wrap(int wrapWidth, int tabWidth, TextAlign align, OverflowWrap overflowWrap2) {
        if (wrapWidth <= 0 && overflowWrap2 != OverflowWrap.NORMAL) {
            return ConstantsKt.getEMPTY_LINES();
        }
        boolean bl = false;
        List lines = new ArrayList();
        Ref.ObjectRef<List<Span>> line = new Ref.ObjectRef<List<Span>>();
        boolean bl2 = false;
        line.element = new ArrayList();
        Ref.ObjectRef<TextStyle> endStyle = new Ref.ObjectRef<TextStyle>();
        endStyle.element = ConstantsKt.getDEFAULT_STYLE();
        Ref.IntRef width = new Ref.IntRef();
        Ref.BooleanRef lastPieceWasWhitespace = new Ref.BooleanRef();
        lastPieceWasWhitespace.element = true;
        for (Line oldLine : this.lines.getLines()) {
            int lastNonWhitespace = this.lastNonWhitespace(oldLine, align);
            endStyle.element = oldLine.getEndStyle();
            Iterator<Span> iterator2 = oldLine.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                Span span;
                boolean pieceIsWhitespace;
                int i = n++;
                Span piece = iterator2.next();
                if (Intrinsics.areEqual(piece.getText(), "\u0085") || Intrinsics.areEqual(piece.getText(), "\u2028")) {
                    Text.wrap$breakLine(this, align, line, width, wrapWidth, endStyle, lines, lastPieceWasWhitespace);
                    continue;
                }
                if (this.whitespace.getTrimEol() || align == TextAlign.JUSTIFY) {
                    if (0 <= lastNonWhitespace ? lastNonWhitespace < i : false) continue;
                }
                if (i == 0 && !lastPieceWasWhitespace.element) {
                    TextStyle textStyle = ((Span)CollectionsKt.last((List)line.element)).getStyle();
                    Span span2 = (Span)CollectionsKt.firstOrNull(oldLine);
                    TextStyle style = Intrinsics.areEqual(textStyle, span2 == null ? null : span2.getStyle()) ? ((Span)CollectionsKt.last((List)line.element)).getStyle() : ConstantsKt.getDEFAULT_STYLE();
                    ((List)line.element).add(Span.Companion.word(" ", style));
                    lastPieceWasWhitespace.element = true;
                    ++width.element;
                }
                if ((pieceIsWhitespace = piece.isWhitespace$mordant()) && lastPieceWasWhitespace.element && this.whitespace.getCollapseSpaces()) continue;
                Span span3 = null;
                if (pieceIsWhitespace && this.whitespace.getCollapseSpaces()) {
                    span = Span.Companion.space(1, piece.getStyle());
                } else if (piece.isTab$mordant()) {
                    if (tabWidth <= 0) continue;
                    span = Span.Companion.space(tabWidth - width.element % tabWidth, piece.getStyle());
                } else {
                    span = piece;
                }
                span3 = span;
                int cellWidth2 = span3.getCellWidth$mordant();
                if (this.whitespace.getWrap() && width.element > 0 && width.element + cellWidth2 > wrapWidth) {
                    Text.wrap$breakLine(this, align, line, width, wrapWidth, endStyle, lines, lastPieceWasWhitespace);
                    if (pieceIsWhitespace) continue;
                }
                if (cellWidth2 > wrapWidth) {
                    OverflowWrap overflowWrap3 = overflowWrap2;
                    int n2 = WhenMappings.$EnumSwitchMapping$0[overflowWrap3.ordinal()];
                    switch (n2) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            span3 = Span.Companion.word(StringsKt.take(span3.getText(), wrapWidth), span3.getStyle());
                            break;
                        }
                        case 3: {
                            span3 = Span.Companion.word(Intrinsics.stringPlus(StringsKt.take(span3.getText(), wrapWidth - 1), "\u2026"), span3.getStyle());
                            break;
                        }
                        case 4: {
                            Iterable $this$forEach$iv = StringsKt.chunked(span3.getText(), wrapWidth);
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String it = (String)element$iv;
                                boolean bl3 = false;
                                if (it.length() == wrapWidth) {
                                    Collection collection = lines;
                                    Line line2 = new Line(CollectionsKt.listOf(Span.Companion.word(it, span3.getStyle())));
                                    boolean bl4 = false;
                                    collection.add(line2);
                                    continue;
                                }
                                span3 = Span.Companion.word(it, span3.getStyle());
                            }
                            break;
                        }
                    }
                }
                width.element += span3.getCellWidth$mordant();
                ((List)line.element).add(span3);
                lastPieceWasWhitespace.element = pieceIsWhitespace;
            }
            if (this.whitespace.getCollapseNewlines()) continue;
            Text.wrap$breakLine(this, align, line, width, wrapWidth, endStyle, lines, lastPieceWasWhitespace);
        }
        Collection collection = (Collection)line.element;
        boolean bl5 = false;
        if (!collection.isEmpty()) {
            Text.wrap$breakLine(this, align, line, width, wrapWidth, endStyle, lines, lastPieceWasWhitespace);
        }
        return new Lines(lines);
    }

    private final int lastNonWhitespace(List<Span> line, TextAlign align) {
        int n;
        block3: {
            if (this.whitespace.getTrimEol() || align == TextAlign.JUSTIFY) {
                List<Span> $this$indexOfLast$iv = line;
                boolean $i$f$indexOfLast = false;
                ListIterator<Span> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Span it = iterator$iv.previous();
                    boolean bl = false;
                    if (!(!it.isWhitespace$mordant())) continue;
                    n = iterator$iv.nextIndex();
                    break block3;
                }
                n = -1;
            } else {
                n = -1;
            }
        }
        return n;
    }

    private final List<Span> alignLine(List<Span> line, int wrapWidth, int width, TextAlign align, TextStyle endStyle) {
        int extraWidth = wrapWidth - width;
        TextAlign textAlign2 = align;
        int n = WhenMappings.$EnumSwitchMapping$1[textAlign2.ordinal()];
        switch (n) {
            case 1: {
                this.alignLineLeft(line, extraWidth, endStyle);
                break;
            }
            case 2: {
                this.alignLineRight(line, extraWidth, endStyle);
                break;
            }
            case 3: {
                this.alignLineCenter(line, extraWidth, endStyle);
                break;
            }
            case 4: {
                return this.justifyLine(line, extraWidth, endStyle);
            }
        }
        return line;
    }

    private final void alignLineLeft(List<Span> line, int extraWidth, TextStyle endStyle) {
        TextStyle textStyle;
        Span span = CollectionsKt.lastOrNull(line);
        line.add(Span.Companion.space(extraWidth, span == null ? endStyle : ((textStyle = span.getStyle()) == null ? endStyle : textStyle)));
    }

    private final void alignLineRight(List<Span> line, int extraWidth, TextStyle endStyle) {
        TextStyle textStyle;
        Span span = CollectionsKt.firstOrNull(line);
        line.add(0, Span.Companion.space(extraWidth, span == null ? endStyle : ((textStyle = span.getStyle()) == null ? endStyle : textStyle)));
    }

    private final void alignLineCenter(List<Span> line, int extraWidth, TextStyle endStyle) {
        int halfExtra = extraWidth / 2;
        this.alignLineLeft(line, halfExtra + extraWidth % 2, endStyle);
        if (halfExtra > 0) {
            this.alignLineRight(line, halfExtra, endStyle);
        }
    }

    private final List<Span> justifyLine(List<Span> line, int extraWidth, TextStyle endStyle) {
        int spaceCount;
        int n;
        Iterable $this$count$iv = line;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Span it = (Span)element$iv;
                boolean bl = false;
                if (!it.isWhitespace$mordant()) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = spaceCount = count$iv;
        }
        if (spaceCount == 0) {
            this.alignLineCenter(line, extraWidth, endStyle);
            return line;
        }
        int spaceSize = extraWidth / spaceCount;
        int skipRemainder = spaceCount - extraWidth % spaceCount;
        ArrayList justifiedLine = new ArrayList(line.size() + skipRemainder + (spaceSize > 0 ? spaceCount : 0));
        for (Span span : line) {
            Collection collection = justifiedLine;
            boolean bl = false;
            collection.add(span);
            if (!span.isWhitespace$mordant()) continue;
            int n3 = skipRemainder;
            skipRemainder = n3 + -1;
            if (n3 > 0 && spaceSize == 0) continue;
            Collection collection2 = justifiedLine;
            Span span2 = Span.Companion.space(spaceSize + (skipRemainder < 0 ? 1 : 0), span.getStyle());
            boolean bl3 = false;
            collection2.add(span2);
        }
        return justifiedLine;
    }

    @NotNull
    public String toString() {
        String plain2 = CollectionsKt.joinToString$default(CollectionsKt.flatten((Iterable)this.lines.getLines()), "", null, null, 0, null, toString.plain.1.INSTANCE, 30, null);
        return "Text(" + StringsKt.take(plain2, 25) + (plain2.length() > 25 ? "\u2026" : "") + ')';
    }

    private static final void wrap$breakLine(Text this$0, TextAlign $align, Ref.ObjectRef<List<Span>> line, Ref.IntRef width, int $wrapWidth, Ref.ObjectRef<TextStyle> endStyle, List<Line> lines, Ref.BooleanRef lastPieceWasWhitespace) {
        int lastNonWhitespace;
        if ((this$0.whitespace.getTrimEol() || $align == TextAlign.JUSTIFY) && (lastNonWhitespace = this$0.lastNonWhitespace((List)line.element, $align)) >= 0) {
            int n = CollectionsKt.getLastIndex((List)line.element) - lastNonWhitespace;
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                ((List)line.element).remove(CollectionsKt.getLastIndex((List)line.element));
            }
        }
        if (width.element < $wrapWidth) {
            line.element = this$0.alignLine((List)line.element, $wrapWidth, width.element, $align, (TextStyle)endStyle.element);
        }
        Collection collection = lines;
        Span span = (Span)CollectionsKt.lastOrNull((List)line.element);
        Object object = span == null ? null : span.getStyle();
        object = new Line((List)line.element, (TextStyle)(object == null ? (TextStyle)endStyle.element : object));
        boolean bl = false;
        collection.add(object);
        boolean bl3 = false;
        line.element = new ArrayList();
        width.element = 0;
        lastPieceWasWhitespace.element = true;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OverflowWrap.values().length];
            nArray[OverflowWrap.NORMAL.ordinal()] = 1;
            nArray[OverflowWrap.TRUNCATE.ordinal()] = 2;
            nArray[OverflowWrap.ELLIPSES.ordinal()] = 3;
            nArray[OverflowWrap.BREAK_WORD.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TextAlign.values().length];
            nArray[TextAlign.LEFT.ordinal()] = 1;
            nArray[TextAlign.RIGHT.ordinal()] = 2;
            nArray[TextAlign.CENTER.ordinal()] = 3;
            nArray[TextAlign.JUSTIFY.ordinal()] = 4;
            nArray[TextAlign.NONE.ordinal()] = 5;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

