/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.cipher.cryptohelper;

import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;

public class KeySet {
    private byte[] clientWriteMacSecret;
    private byte[] serverWriteMacSecret;
    private byte[] clientWriteKey;
    private byte[] serverWriteKey;
    private byte[] clientWriteIv;
    private byte[] serverWriteIv;
    private Tls13KeySetType keySetType = Tls13KeySetType.NONE;

    public KeySet() {
    }

    public KeySet(Tls13KeySetType keySetType) {
        this.keySetType = keySetType;
    }

    public byte[] getClientWriteMacSecret() {
        return this.clientWriteMacSecret;
    }

    public void setClientWriteMacSecret(byte[] clientWriteMacSecret) {
        this.clientWriteMacSecret = clientWriteMacSecret;
    }

    public byte[] getServerWriteMacSecret() {
        return this.serverWriteMacSecret;
    }

    public void setServerWriteMacSecret(byte[] serverWriteMacSecret) {
        this.serverWriteMacSecret = serverWriteMacSecret;
    }

    public byte[] getClientWriteKey() {
        return this.clientWriteKey;
    }

    public void setClientWriteKey(byte[] clientWriteKey) {
        this.clientWriteKey = clientWriteKey;
    }

    public byte[] getServerWriteKey() {
        return this.serverWriteKey;
    }

    public void setServerWriteKey(byte[] serverWriteKey) {
        this.serverWriteKey = serverWriteKey;
    }

    public byte[] getClientWriteIv() {
        return this.clientWriteIv;
    }

    public void setClientWriteIv(byte[] clientWriteIv) {
        this.clientWriteIv = clientWriteIv;
    }

    public byte[] getServerWriteIv() {
        return this.serverWriteIv;
    }

    public void setServerWriteIv(byte[] serverWriteIv) {
        this.serverWriteIv = serverWriteIv;
    }

    public byte[] getWriteKey(ConnectionEndType connectionEndType) {
        if (connectionEndType == ConnectionEndType.CLIENT) {
            return this.clientWriteKey;
        }
        return this.serverWriteKey;
    }

    public byte[] getReadKey(ConnectionEndType connectionEndType) {
        if (connectionEndType == ConnectionEndType.SERVER) {
            return this.clientWriteKey;
        }
        return this.serverWriteKey;
    }

    public byte[] getReadMacSecret(ConnectionEndType connectionEndType) {
        if (connectionEndType == ConnectionEndType.SERVER) {
            return this.clientWriteMacSecret;
        }
        return this.serverWriteMacSecret;
    }

    public byte[] getWriteMacSecret(ConnectionEndType connectionEndType) {
        if (connectionEndType == ConnectionEndType.CLIENT) {
            return this.clientWriteMacSecret;
        }
        return this.serverWriteMacSecret;
    }

    public byte[] getWriteIv(ConnectionEndType connectionEndType) {
        if (connectionEndType == ConnectionEndType.CLIENT) {
            return this.clientWriteIv;
        }
        return this.serverWriteIv;
    }

    public byte[] getReadIv(ConnectionEndType connectionEndType) {
        if (connectionEndType == ConnectionEndType.SERVER) {
            return this.clientWriteIv;
        }
        return this.serverWriteIv;
    }

    public Tls13KeySetType getKeySetType() {
        return this.keySetType;
    }

    public void setKeySetType(Tls13KeySetType keySetType) {
        this.keySetType = keySetType;
    }
}

