/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.task.ITask;
import de.rub.nds.tlsattacker.core.workflow.task.StateExecutionTask;
import de.rub.nds.tlsattacker.core.workflow.task.TlsTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParallelExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExecutorService executorService;
    private final int size;
    private final int reexecutions;

    public ParallelExecutor(int size, int reexecutions) {
        this.executorService = new ThreadPoolExecutor(size, size, 10L, TimeUnit.DAYS, new LinkedBlockingDeque<Runnable>());
        this.reexecutions = reexecutions;
        this.size = size;
        if (reexecutions < 0) {
            throw new IllegalArgumentException("Reexecutions is below zero");
        }
    }

    public ParallelExecutor(int size, int reexecutions, ThreadFactory factory) {
        this.executorService = new ThreadPoolExecutor(size, size, 5L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(), factory);
        this.reexecutions = reexecutions;
        this.size = size;
        if (reexecutions < 0) {
            throw new IllegalArgumentException("Reexecutions is below zero");
        }
    }

    public Future addTask(TlsTask task) {
        if (this.executorService.isShutdown()) {
            throw new RuntimeException("Cannot add Tasks to already shutdown executor");
        }
        Future<ITask> submit = this.executorService.submit(task);
        return submit;
    }

    public Future addStateTask(State state) {
        return this.addTask(new StateExecutionTask(state, this.reexecutions));
    }

    public void bulkExecuteStateTasks(List<State> stateList) {
        LinkedList<Future> futureList = new LinkedList<Future>();
        for (State state : stateList) {
            futureList.add(this.addStateTask(state));
        }
        for (Future future : futureList) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException("Failed to execute tasks!", ex);
            }
        }
    }

    public void bulkExecuteStateTasks(State ... states) {
        this.bulkExecuteStateTasks(new ArrayList<State>(Arrays.asList(states)));
    }

    public void bulkExecuteTasks(List<TlsTask> taskList) {
        LinkedList<Future> futureList = new LinkedList<Future>();
        for (TlsTask tlStask : taskList) {
            futureList.add(this.addTask(tlStask));
        }
        for (Future future : futureList) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException("Failed to execute tasks!", ex);
            }
        }
    }

    public void bulkExecuteTasks(TlsTask ... tasks) {
        this.bulkExecuteTasks(new ArrayList<TlsTask>(Arrays.asList(tasks)));
    }

    public int getSize() {
        return this.size;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public int getReexecutions() {
        return this.reexecutions;
    }
}

