/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.udp.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class UdpOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 8192;
    private final DatagramSocket socket;
    private int index;
    private final byte[] dataBuffer = new byte[8192];

    public UdpOutputStream(DatagramSocket socket) {
        this.socket = socket;
    }

    @Override
    public void write(int i) throws IOException {
        this.dataBuffer[this.index] = (byte)(i & 0xFF);
        ++this.index;
        if (this.index >= this.dataBuffer.length) {
            this.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    public void flush() throws IOException {
        byte[] outData = new byte[this.index];
        System.arraycopy(this.dataBuffer, 0, outData, 0, this.index);
        DatagramPacket packet = new DatagramPacket(outData, this.index);
        this.socket.send(packet);
        this.index = 0;
    }
}

