/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.Notification;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;

@Singleton
public class NotificatorPushover
implements Notificator {
    private final NotificationFormatter notificationFormatter;
    private final Client client;
    private final String url;
    private final String token;
    private final String user;

    @Inject
    public NotificatorPushover(Config config, NotificationFormatter notificationFormatter, Client client) {
        this.notificationFormatter = notificationFormatter;
        this.client = client;
        this.url = "https://api.pushover.net/1/messages.json";
        this.token = config.getString(Keys.NOTIFICATOR_PUSHOVER_TOKEN);
        this.user = config.getString(Keys.NOTIFICATOR_PUSHOVER_USER);
    }

    @Override
    public void send(Notification notification, User user, Event event, Position position) {
        NotificationMessage shortMessage = this.notificationFormatter.formatMessage(user, event, position, "short");
        Message message = new Message();
        message.token = this.token;
        message.user = user.getString("pushoverUserKey");
        if (message.user == null) {
            message.user = this.user;
        }
        if (user.hasAttribute("pushoverDeviceNames")) {
            message.device = user.getString("pushoverDeviceNames").replaceAll(" *, *", ",");
        }
        message.title = shortMessage.getSubject();
        message.message = shortMessage.getBody();
        this.client.target(this.url).request().post(Entity.json((Object)message)).close();
    }

    public static class Message {
        @JsonProperty(value="token")
        private String token;
        @JsonProperty(value="user")
        private String user;
        @JsonProperty(value="device")
        private String device;
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="message")
        private String message;
    }
}

