/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class OmnicommFrameDecoder
extends BaseFrameDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.readableBytes() < 6) {
            return null;
        }
        int endIndex = buf.getUnsignedShortLE(buf.readerIndex() + 2) + buf.readerIndex() + 6;
        if (buf.writerIndex() < endIndex) {
            return null;
        }
        ByteBuf result = Unpooled.buffer();
        result.writeByte((int)buf.readUnsignedByte());
        while (buf.readerIndex() < endIndex) {
            short b = buf.readUnsignedByte();
            if (b == 219) {
                short ext = buf.readUnsignedByte();
                if (ext == 220) {
                    result.writeByte(192);
                } else if (ext == 221) {
                    result.writeByte(219);
                }
                ++endIndex;
                continue;
            }
            result.writeByte((int)b);
        }
        return result;
    }
}

