/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class Template
extends Procedure {
    private Pattern matchPattern;
    private int precedence;
    private int minImportPrecedence;
    private StructuredQName templateName;
    private boolean hasRequiredParams;
    private boolean bodyIsTailCallReturner;
    private SequenceType requiredType;

    public Template() {
        this.setHostLanguage(50);
    }

    public void init(StructuredQName templateName, int precedence, int minImportPrecedence) {
        this.templateName = templateName;
        this.precedence = precedence;
        this.minImportPrecedence = minImportPrecedence;
    }

    public void setMatchPattern(Pattern pattern) {
        this.matchPattern = pattern;
    }

    public Pattern getMatchPattern() {
        return this.matchPattern;
    }

    public void setBody(Expression body) {
        super.setBody(body);
        this.bodyIsTailCallReturner = body instanceof TailCallReturner;
    }

    public StructuredQName getTemplateName() {
        return this.templateName;
    }

    public StructuredQName getObjectName() {
        return this.templateName;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public void setHasRequiredParams(boolean has) {
        this.hasRequiredParams = has;
    }

    public boolean hasRequiredParams() {
        return this.hasRequiredParams;
    }

    public void setRequiredType(SequenceType type) {
        this.requiredType = type;
    }

    public SequenceType getRequiredType() {
        if (this.requiredType == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.requiredType;
    }

    public void apply(XPathContext context, Rule rule) throws XPathException {
        for (TailCall tc = this.applyLeavingTail(context, rule); tc != null; tc = tc.processLeavingTail()) {
        }
    }

    public TailCall applyLeavingTail(XPathContext context, Rule rule) throws XPathException {
        if (this.body == null) {
            return null;
        }
        XPathContextMajor c2 = context.newContext();
        c2.setOriginatingConstructType(2008);
        c2.setCurrentTemplateRule(rule);
        if (this.bodyIsTailCallReturner) {
            return ((TailCallReturner)((Object)this.body)).processLeavingTail(c2);
        }
        this.body.process(c2);
        return null;
    }

    public TailCall expand(XPathContext context) throws XPathException {
        if (this.bodyIsTailCallReturner) {
            return ((TailCallReturner)((Object)this.body)).processLeavingTail(context);
        }
        if (this.body != null) {
            this.body.process(context);
        }
        return null;
    }

    public int getConstructType() {
        return 2008;
    }
}

