# This file was automatically generated by bifcl from /usr/obj/ports/zeek-6.0.1/zeek-6.0.1/src/analyzer/protocol/conn-size/functions.bif (plugin mode).

export {


## Sets the current byte threshold for connection sizes, overwriting any potential old
## threshold. Be aware that in nearly any case you will want to use the high level API
## instead (:zeek:see:`ConnThreshold::set_bytes_threshold`).
##
## cid: The connection id.
##
## threshold: Threshold in bytes.
##
## is_orig: If true, threshold is set for bytes from originator, otherwise for bytes from responder.
##
## .. zeek:see:: set_current_conn_packets_threshold conn_bytes_threshold_crossed conn_packets_threshold_crossed
##               get_current_conn_bytes_threshold get_current_conn_packets_threshold
##               set_current_conn_duration_threshold get_current_conn_duration_threshold
global set_current_conn_bytes_threshold: function(cid: conn_id , threshold: count , is_orig: bool ): bool ;


## Sets a threshold for connection packets, overwriting any potential old thresholds.
## Be aware that in nearly any case you will want to use the high level API
## instead (:zeek:see:`ConnThreshold::set_packets_threshold`).
##
## cid: The connection id.
##
## threshold: Threshold in packets.
##
## is_orig: If true, threshold is set for packets from originator, otherwise for packets from responder.
##
## .. zeek:see:: set_current_conn_bytes_threshold conn_bytes_threshold_crossed conn_packets_threshold_crossed
##               get_current_conn_bytes_threshold get_current_conn_packets_threshold
##               set_current_conn_duration_threshold get_current_conn_duration_threshold
global set_current_conn_packets_threshold: function(cid: conn_id , threshold: count , is_orig: bool ): bool ;


## Sets the current duration threshold for connection, overwriting any potential old
## threshold. Be aware that in nearly any case you will want to use the high level API
## instead (:zeek:see:`ConnThreshold::set_duration_threshold`).
##
## cid: The connection id.
##
## threshold: Threshold in seconds.
##
## .. zeek:see:: set_current_conn_packets_threshold conn_bytes_threshold_crossed conn_packets_threshold_crossed
##               get_current_conn_bytes_threshold get_current_conn_packets_threshold
##               get_current_conn_duration_threshold
global set_current_conn_duration_threshold: function(cid: conn_id , threshold: interval ): bool ;



##
## cid: The connection id.
##
## is_orig: If true, threshold of originator, otherwise threshold of responder.
##
## Returns: 0 if no threshold is set or the threshold in bytes
##
## .. zeek:see:: set_current_conn_packets_threshold conn_bytes_threshold_crossed conn_packets_threshold_crossed
##               get_current_conn_packets_threshold set_current_conn_duration_threshold
##               get_current_conn_duration_threshold
global get_current_conn_bytes_threshold: function(cid: conn_id , is_orig: bool ): count ;


## Gets the current packet threshold size for a connection.
##
## cid: The connection id.
##
## is_orig: If true, threshold of originator, otherwise threshold of responder.
##
## Returns: 0 if no threshold is set or the threshold in packets
##
## .. zeek:see:: set_current_conn_packets_threshold conn_bytes_threshold_crossed conn_packets_threshold_crossed
##               get_current_conn_bytes_threshold set_current_conn_duration_threshold get_current_conn_duration_threshold
global get_current_conn_packets_threshold: function(cid: conn_id , is_orig: bool ): count ;


## Gets the current duration threshold size for a connection.
##
## cid: The connection id.
##
## Returns: 0 if no threshold is set or the threshold in seconds
##
## .. zeek:see:: set_current_conn_packets_threshold conn_bytes_threshold_crossed conn_packets_threshold_crossed
##               get_current_conn_packets_threshold set_current_conn_duration_threshold
global get_current_conn_duration_threshold: function(cid: conn_id ): interval ;

} # end of export section
module GLOBAL;
