"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.readOnlyProperty = exports.readOnlyBinaryProperty = exports.frozenClass = exports.immutableBaseClass = exports.immutableClass = void 0;
function immutableClass(ObjectClass) {
    Object.freeze(ObjectClass);
    const propertyNames = Object.getOwnPropertyNames(ObjectClass.prototype);
    propertyNames
        .filter((name) => name !== 'constructor')
        .forEach((name) => Object.defineProperty(ObjectClass.prototype, name, { writable: false }));
    Object.seal(ObjectClass.prototype);
    return ObjectClass;
}
exports.immutableClass = immutableClass;
function immutableBaseClass(ObjectClass) {
    Object.setPrototypeOf(ObjectClass.prototype, null);
    immutableClass(ObjectClass);
    return ObjectClass;
}
exports.immutableBaseClass = immutableBaseClass;
function frozenClass(ObjectClass) {
    Object.setPrototypeOf(ObjectClass.prototype, null);
    Object.freeze(ObjectClass.prototype);
    Object.freeze(ObjectClass);
    return ObjectClass;
}
exports.frozenClass = frozenClass;
function readOnlyBinaryProperty(obj, name, value) {
    // should this also add a zero property?
    // and should it create a local value?  maybe not.
    const safeValue = new Uint8Array(value);
    Object.defineProperty(obj, name, {
        get: () => new Uint8Array(safeValue),
        enumerable: true,
    });
}
exports.readOnlyBinaryProperty = readOnlyBinaryProperty;
function readOnlyProperty(obj, name, value) {
    Object.defineProperty(obj, name, { value, enumerable: true });
}
exports.readOnlyProperty = readOnlyProperty;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW1tdXRhYmxlX2NsYXNzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2ltbXV0YWJsZV9jbGFzcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQzs7O0FBRXRDLFNBQWdCLGNBQWMsQ0FBQyxXQUFnQjtJQUM3QyxNQUFNLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxDQUFBO0lBQzFCLE1BQU0sYUFBYSxHQUFHLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDLENBQUE7SUFDdkUsYUFBYTtTQUNWLE1BQU0sQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsSUFBSSxLQUFLLGFBQWEsQ0FBQztTQUN4QyxPQUFPLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUNoQixNQUFNLENBQUMsY0FBYyxDQUFDLFdBQVcsQ0FBQyxTQUFTLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQ3hFLENBQUE7SUFDSCxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsQ0FBQTtJQUNsQyxPQUFPLFdBQVcsQ0FBQTtBQUNwQixDQUFDO0FBVkQsd0NBVUM7QUFFRCxTQUFnQixrQkFBa0IsQ0FBQyxXQUFnQjtJQUNqRCxNQUFNLENBQUMsY0FBYyxDQUFDLFdBQVcsQ0FBQyxTQUFTLEVBQUUsSUFBSSxDQUFDLENBQUE7SUFDbEQsY0FBYyxDQUFDLFdBQVcsQ0FBQyxDQUFBO0lBQzNCLE9BQU8sV0FBVyxDQUFBO0FBQ3BCLENBQUM7QUFKRCxnREFJQztBQUVELFNBQWdCLFdBQVcsQ0FBQyxXQUFnQjtJQUMxQyxNQUFNLENBQUMsY0FBYyxDQUFDLFdBQVcsQ0FBQyxTQUFTLEVBQUUsSUFBSSxDQUFDLENBQUE7SUFDbEQsTUFBTSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDLENBQUE7SUFDcEMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsQ0FBQTtJQUMxQixPQUFPLFdBQVcsQ0FBQTtBQUNwQixDQUFDO0FBTEQsa0NBS0M7QUFFRCxTQUFnQixzQkFBc0IsQ0FDcEMsR0FBUSxFQUNSLElBQVksRUFDWixLQUFpQjtJQUVqQix3Q0FBd0M7SUFDeEMsa0RBQWtEO0lBQ2xELE1BQU0sU0FBUyxHQUFHLElBQUksVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFBO0lBQ3ZDLE1BQU0sQ0FBQyxjQUFjLENBQUMsR0FBRyxFQUFFLElBQUksRUFBRTtRQUMvQixHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQ3BDLFVBQVUsRUFBRSxJQUFJO0tBQ2pCLENBQUMsQ0FBQTtBQUNKLENBQUM7QUFaRCx3REFZQztBQUVELFNBQWdCLGdCQUFnQixDQUM5QixHQUFNLEVBQ04sSUFBTyxFQUNQLEtBQVc7SUFFWCxNQUFNLENBQUMsY0FBYyxDQUFDLEdBQUcsRUFBRSxJQUFJLEVBQUUsRUFBRSxLQUFLLEVBQUUsVUFBVSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUE7QUFDL0QsQ0FBQztBQU5ELDRDQU1DIn0=