"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = alertingPlugin;

var _constants = require("../../services/utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function alertingPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.alerting = components.clientAction.namespaceFactory();
  const alerting = Client.prototype.alerting.prototype;
  alerting.getFindings = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/findings/_search`
    },
    needBody: true,
    method: 'GET'
  });
  alerting.getWorkflow = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/workflows/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.getMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.createMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.createWorkflow = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/workflows?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.deleteMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.deleteWorkflow = ca({
    url: {
      fmt: `${_constants.WORKFLOW_BASE_API}/<%=workflowId%>`,
      req: {
        workflowId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  }); // TODO DRAFT: May need to add 'refresh' assignment here again.

  alerting.updateMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  }); // TODO DRAFT: May need to add 'refresh' assignment here again.

  alerting.updateWorkflow = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/workflows/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.getMonitors = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.acknowledgeAlerts = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>/_acknowledge/alerts`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.acknowledgeChainedAlerts = ca({
    url: {
      fmt: `${_constants.WORKFLOW_BASE_API}/<%=workflowId%>/_acknowledge/alerts`,
      req: {
        workflowId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.getAlerts = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/alerts`
    },
    method: 'GET'
  });
  alerting.executeMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/_execute?dryrun=<%=dryrun%>`,
      req: {
        dryrun: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.getDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}/<%=destinationId%>`,
      req: {
        destinationId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.searchDestinations = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}`
    },
    method: 'GET'
  });
  alerting.createDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}/<%=destinationId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        destinationId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.deleteDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}/<%=destinationId%>`,
      req: {
        destinationId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.getEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/<%=emailAccountId%>`,
      req: {
        emailAccountId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.getEmailAccounts = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.createEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/<%=emailAccountId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        emailAccountId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.deleteEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/<%=emailAccountId%>`,
      req: {
        emailAccountId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.getEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/<%=emailGroupId%>`,
      req: {
        emailGroupId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.getEmailGroups = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.createEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/<%=emailGroupId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        emailGroupId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.deleteEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/<%=emailGroupId%>`,
      req: {
        emailGroupId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.getWorkflowAlerts = ca({
    url: {
      fmt: `${_constants.WORKFLOW_BASE_API}/alerts?workflowIds=<%=workflowIds%>&getAssociatedAlerts=<%=getAssociatedAlerts%>&sortString=<%=sortString%>&sortOrder=<%=sortOrder%>&startIndex=<%=startIndex%>&size=<%=size%>&severityLevel=<%=severityLevel%>&alertState=<%=alertState%>&searchString=<%=searchString%>&alertIds=<%=alertIds%>`,
      req: {
        workflowIds: {
          type: 'string',
          required: true
        },
        alertIds: {
          type: 'string',
          required: true
        },
        getAssociatedAlerts: {
          type: 'boolean',
          required: true
        },
        sortString: {
          type: 'string',
          required: true
        },
        sortOrder: {
          type: 'string',
          required: true
        },
        startIndex: {
          type: 'number',
          required: true
        },
        size: {
          type: 'number',
          required: true
        },
        severityLevel: {
          type: 'string',
          required: false
        },
        alertState: {
          type: 'string',
          required: false
        },
        searchString: {
          type: 'string',
          required: false
        }
      }
    },
    method: 'GET'
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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