"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pageStyles = exports.observabilityTracesTitle = exports.observabilityTracesPluginOrder = exports.observabilityTracesID = exports.observabilityTitle = exports.observabilityPluginOrder = exports.observabilityPanelsTitle = exports.observabilityPanelsPluginOrder = exports.observabilityPanelsID = exports.observabilityNotebookTitle = exports.observabilityNotebookPluginOrder = exports.observabilityNotebookID = exports.observabilityMetricsTitle = exports.observabilityMetricsPluginOrder = exports.observabilityMetricsID = exports.observabilityLogsTitle = exports.observabilityLogsPluginOrder = exports.observabilityLogsID = exports.observabilityIntegrationsTitle = exports.observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsID = exports.observabilityID = exports.observabilityApplicationsTitle = exports.observabilityApplicationsPluginOrder = exports.observabilityApplicationsID = exports.WAITING_TIME_ON_USER_ACTIONS = exports.VIS_CHART_TYPES = exports.VISUALIZATION_ERROR = exports.UI_DATE_FORMAT = exports.THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_OPACITY = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SPAN_REGEX = exports.SLIDER_STEP = exports.SLIDER_MIN_VALUE = exports.SLIDER_MAX_VALUE = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.PPL_WHERE_CLAUSE_REGEX = exports.PPL_STATS_REGEX = exports.PPL_SPAN_REGEX = exports.PPL_SEARCH = exports.PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_NEWLINE_REGEX = exports.PPL_INDEX_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_DATE_FORMAT = exports.PPL_BASE = exports.PLOT_MARGIN = exports.PLOTLY_COLOR = exports.OPENSEARCH_PANELS_API = exports.OBSERVABILITY_BASE = exports.NUMERICAL_FIELDS = exports.MAX_BUCKET_LENGTH = exports.LONG_CHART_COLOR = exports.LIVE_OPTIONS = exports.LIVE_END_TIME = exports.INTEGRATIONS_BASE = exports.FILLOPACITY_DIV_FACTOR = exports.EVENT_ANALYTICS = exports.ENABLED_VIS_TYPES = exports.DSL_SEARCH = exports.DSL_MAPPING = exports.DSL_ENDPOINT = exports.DSL_CAT = exports.DSL_BASE = exports.DEFAULT_CHART_STYLES = exports.BarOrientation = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// Client route
const PPL_BASE = '/api/ppl';
exports.PPL_BASE = PPL_BASE;
const PPL_SEARCH = '/search';
exports.PPL_SEARCH = PPL_SEARCH;
const DSL_BASE = '/api/dsl';
exports.DSL_BASE = DSL_BASE;
const DSL_SEARCH = '/search';
exports.DSL_SEARCH = DSL_SEARCH;
const DSL_CAT = '/cat.indices';
exports.DSL_CAT = DSL_CAT;
const DSL_MAPPING = '/indices.getFieldMapping';
exports.DSL_MAPPING = DSL_MAPPING;
const OBSERVABILITY_BASE = '/api/observability';
exports.OBSERVABILITY_BASE = OBSERVABILITY_BASE;
const INTEGRATIONS_BASE = '/api/integrations';
exports.INTEGRATIONS_BASE = INTEGRATIONS_BASE;
const EVENT_ANALYTICS = '/event_analytics';
exports.EVENT_ANALYTICS = EVENT_ANALYTICS;
const SAVED_OBJECTS = '/saved_objects';
exports.SAVED_OBJECTS = SAVED_OBJECTS;
const SAVED_QUERY = '/query';
exports.SAVED_QUERY = SAVED_QUERY;
const SAVED_VISUALIZATION = '/vis'; // Server route

exports.SAVED_VISUALIZATION = SAVED_VISUALIZATION;
const PPL_ENDPOINT = '/_plugins/_ppl';
exports.PPL_ENDPOINT = PPL_ENDPOINT;
const SQL_ENDPOINT = '/_plugins/_sql';
exports.SQL_ENDPOINT = SQL_ENDPOINT;
const DSL_ENDPOINT = '/_plugins/_dsl';
exports.DSL_ENDPOINT = DSL_ENDPOINT;
const observabilityID = 'observability-logs';
exports.observabilityID = observabilityID;
const observabilityTitle = 'Observability';
exports.observabilityTitle = observabilityTitle;
const observabilityPluginOrder = 1500;
exports.observabilityPluginOrder = observabilityPluginOrder;
const observabilityApplicationsID = 'observability-applications';
exports.observabilityApplicationsID = observabilityApplicationsID;
const observabilityApplicationsTitle = 'Applications';
exports.observabilityApplicationsTitle = observabilityApplicationsTitle;
const observabilityApplicationsPluginOrder = 5090;
exports.observabilityApplicationsPluginOrder = observabilityApplicationsPluginOrder;
const observabilityLogsID = 'observability-logs';
exports.observabilityLogsID = observabilityLogsID;
const observabilityLogsTitle = 'Logs';
exports.observabilityLogsTitle = observabilityLogsTitle;
const observabilityLogsPluginOrder = 5091;
exports.observabilityLogsPluginOrder = observabilityLogsPluginOrder;
const observabilityMetricsID = 'observability-metrics';
exports.observabilityMetricsID = observabilityMetricsID;
const observabilityMetricsTitle = 'Metrics';
exports.observabilityMetricsTitle = observabilityMetricsTitle;
const observabilityMetricsPluginOrder = 5092;
exports.observabilityMetricsPluginOrder = observabilityMetricsPluginOrder;
const observabilityTracesID = 'observability-traces';
exports.observabilityTracesID = observabilityTracesID;
const observabilityTracesTitle = 'Traces';
exports.observabilityTracesTitle = observabilityTracesTitle;
const observabilityTracesPluginOrder = 5093;
exports.observabilityTracesPluginOrder = observabilityTracesPluginOrder;
const observabilityNotebookID = 'observability-notebooks';
exports.observabilityNotebookID = observabilityNotebookID;
const observabilityNotebookTitle = 'Notebooks';
exports.observabilityNotebookTitle = observabilityNotebookTitle;
const observabilityNotebookPluginOrder = 5094;
exports.observabilityNotebookPluginOrder = observabilityNotebookPluginOrder;
const observabilityPanelsID = 'observability-dashboards';
exports.observabilityPanelsID = observabilityPanelsID;
const observabilityPanelsTitle = 'Dashboards';
exports.observabilityPanelsTitle = observabilityPanelsTitle;
const observabilityPanelsPluginOrder = 5095;
exports.observabilityPanelsPluginOrder = observabilityPanelsPluginOrder;
const observabilityIntegrationsID = 'integrations';
exports.observabilityIntegrationsID = observabilityIntegrationsID;
const observabilityIntegrationsTitle = 'Integrations';
exports.observabilityIntegrationsTitle = observabilityIntegrationsTitle;
const observabilityIntegrationsPluginOrder = 9020; // Shared Constants

exports.observabilityIntegrationsPluginOrder = observabilityIntegrationsPluginOrder;
const SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
exports.SQL_DOCUMENTATION_URL = SQL_DOCUMENTATION_URL;
const PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/ppl/index';
exports.PPL_DOCUMENTATION_URL = PPL_DOCUMENTATION_URL;
const PPL_PATTERNS_DOCUMENTATION_URL = 'https://github.com/opensearch-project/sql/blob/2.x/docs/user/ppl/cmd/patterns.rst#description';
exports.PPL_PATTERNS_DOCUMENTATION_URL = PPL_PATTERNS_DOCUMENTATION_URL;
const UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
exports.UI_DATE_FORMAT = UI_DATE_FORMAT;
const PPL_DATE_FORMAT = 'YYYY-MM-DD HH:mm:ss.SSSSSS';
exports.PPL_DATE_FORMAT = PPL_DATE_FORMAT;
const SPAN_REGEX = /span/;
exports.SPAN_REGEX = SPAN_REGEX;
const PPL_SPAN_REGEX = /by\s*span/i;
exports.PPL_SPAN_REGEX = PPL_SPAN_REGEX;
const PPL_STATS_REGEX = /\|\s*stats/i;
exports.PPL_STATS_REGEX = PPL_STATS_REGEX;
const PPL_INDEX_INSERT_POINT_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)(.*)/i;
exports.PPL_INDEX_INSERT_POINT_REGEX = PPL_INDEX_INSERT_POINT_REGEX;
const PPL_INDEX_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)/i;
exports.PPL_INDEX_REGEX = PPL_INDEX_REGEX;
const PPL_WHERE_CLAUSE_REGEX = /\s*where\s+/i;
exports.PPL_WHERE_CLAUSE_REGEX = PPL_WHERE_CLAUSE_REGEX;
const PPL_NEWLINE_REGEX = /[\n\r]+/g; // Observability plugin URI

exports.PPL_NEWLINE_REGEX = PPL_NEWLINE_REGEX;
const BASE_OBSERVABILITY_URI = '/_plugins/_observability';
const BASE_INTEGRATIONS_URI = '/_plugins/_integrations'; // Used later in front-end for routing

const OPENSEARCH_PANELS_API = {
  OBJECT: `${BASE_OBSERVABILITY_URI}/object`
}; // Saved Objects

exports.OPENSEARCH_PANELS_API = OPENSEARCH_PANELS_API;
const SAVED_OBJECT = '/object'; // Color Constants

exports.SAVED_OBJECT = SAVED_OBJECT;
const PLOTLY_COLOR = ['#3CA1C7', '#8C55A3', '#DB748A', '#F2BE4B', '#68CCC2', '#2A7866', '#843769', '#374FB8', '#BD6F26', '#4C636F'];
exports.PLOTLY_COLOR = PLOTLY_COLOR;
const LONG_CHART_COLOR = PLOTLY_COLOR[1];
exports.LONG_CHART_COLOR = LONG_CHART_COLOR;
const pageStyles = {
  float: 'left',
  width: '100%',
  maxWidth: '1130px'
};
exports.pageStyles = pageStyles;
let VIS_CHART_TYPES;
exports.VIS_CHART_TYPES = VIS_CHART_TYPES;

(function (VIS_CHART_TYPES) {
  VIS_CHART_TYPES["Bar"] = "bar";
  VIS_CHART_TYPES["HorizontalBar"] = "horizontal_bar";
  VIS_CHART_TYPES["Line"] = "line";
  VIS_CHART_TYPES["Pie"] = "pie";
  VIS_CHART_TYPES["HeatMap"] = "heatmap";
  VIS_CHART_TYPES["Text"] = "text";
})(VIS_CHART_TYPES || (exports.VIS_CHART_TYPES = VIS_CHART_TYPES = {}));

const NUMERICAL_FIELDS = ['short', 'integer', 'long', 'float', 'double'];
exports.NUMERICAL_FIELDS = NUMERICAL_FIELDS;
const ENABLED_VIS_TYPES = [VIS_CHART_TYPES.Bar, VIS_CHART_TYPES.HorizontalBar, VIS_CHART_TYPES.Line, VIS_CHART_TYPES.Pie, VIS_CHART_TYPES.HeatMap, VIS_CHART_TYPES.Text]; // Live tail constants

exports.ENABLED_VIS_TYPES = ENABLED_VIS_TYPES;
const LIVE_OPTIONS = [{
  label: '5s',
  startTime: 'now-5s',
  delayTime: 5000
}, {
  label: '10s',
  startTime: 'now-10s',
  delayTime: 10000
}, {
  label: '30s',
  startTime: 'now-30s',
  delayTime: 30000
}, {
  label: '1m',
  startTime: 'now-1m',
  delayTime: 60000
}, {
  label: '5m',
  startTime: 'now-5m',
  delayTime: 60000 * 5
}, {
  label: '15m',
  startTime: 'now-15m',
  delayTime: 60000 * 15
}, {
  label: '30m',
  startTime: 'now-30m',
  delayTime: 60000 * 30
}, {
  label: '1h',
  startTime: 'now-1h',
  delayTime: 60000 * 60
}, {
  label: '2h',
  startTime: 'now-2h',
  delayTime: 60000 * 120
}];
exports.LIVE_OPTIONS = LIVE_OPTIONS;
const LIVE_END_TIME = 'now';
exports.LIVE_END_TIME = LIVE_END_TIME;
const DEFAULT_CHART_STYLES = {
  DefaultModeLine: 'lines',
  Interpolation: 'spline',
  LineWidth: 0,
  FillOpacity: 100,
  MarkerSize: 5,
  ShowLegend: 'show',
  LegendPosition: 'v',
  LabelAngle: 0,
  DefaultSortSectors: 'largest_to_smallest',
  DefaultModeScatter: 'markers'
};
exports.DEFAULT_CHART_STYLES = DEFAULT_CHART_STYLES;
const FILLOPACITY_DIV_FACTOR = 200;
exports.FILLOPACITY_DIV_FACTOR = FILLOPACITY_DIV_FACTOR;
const SLIDER_MIN_VALUE = 0;
exports.SLIDER_MIN_VALUE = SLIDER_MIN_VALUE;
const SLIDER_MAX_VALUE = 100;
exports.SLIDER_MAX_VALUE = SLIDER_MAX_VALUE;
const SLIDER_STEP = 1;
exports.SLIDER_STEP = SLIDER_STEP;
const THRESHOLD_LINE_WIDTH = 3;
exports.THRESHOLD_LINE_WIDTH = THRESHOLD_LINE_WIDTH;
const THRESHOLD_LINE_OPACITY = 0.7;
exports.THRESHOLD_LINE_OPACITY = THRESHOLD_LINE_OPACITY;
const MAX_BUCKET_LENGTH = 16;
exports.MAX_BUCKET_LENGTH = MAX_BUCKET_LENGTH;
let BarOrientation;
exports.BarOrientation = BarOrientation;

(function (BarOrientation) {
  BarOrientation["horizontal"] = "h";
  BarOrientation["vertical"] = "v";
})(BarOrientation || (exports.BarOrientation = BarOrientation = {}));

const PLOT_MARGIN = {
  l: 30,
  r: 5,
  b: 30,
  t: 50,
  pad: 4
};
exports.PLOT_MARGIN = PLOT_MARGIN;
const WAITING_TIME_ON_USER_ACTIONS = 300;
exports.WAITING_TIME_ON_USER_ACTIONS = WAITING_TIME_ON_USER_ACTIONS;
const VISUALIZATION_ERROR = {
  NO_DATA: 'No data found.',
  INVALID_DATA: 'Invalid visualization data'
};
exports.VISUALIZATION_ERROR = VISUALIZATION_ERROR;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNoYXJlZC50cyJdLCJuYW1lcyI6WyJQUExfQkFTRSIsIlBQTF9TRUFSQ0giLCJEU0xfQkFTRSIsIkRTTF9TRUFSQ0giLCJEU0xfQ0FUIiwiRFNMX01BUFBJTkciLCJPQlNFUlZBQklMSVRZX0JBU0UiLCJJTlRFR1JBVElPTlNfQkFTRSIsIkVWRU5UX0FOQUxZVElDUyIsIlNBVkVEX09CSkVDVFMiLCJTQVZFRF9RVUVSWSIsIlNBVkVEX1ZJU1VBTElaQVRJT04iLCJQUExfRU5EUE9JTlQiLCJTUUxfRU5EUE9JTlQiLCJEU0xfRU5EUE9JTlQiLCJvYnNlcnZhYmlsaXR5SUQiLCJvYnNlcnZhYmlsaXR5VGl0bGUiLCJvYnNlcnZhYmlsaXR5UGx1Z2luT3JkZXIiLCJvYnNlcnZhYmlsaXR5QXBwbGljYXRpb25zSUQiLCJvYnNlcnZhYmlsaXR5QXBwbGljYXRpb25zVGl0bGUiLCJvYnNlcnZhYmlsaXR5QXBwbGljYXRpb25zUGx1Z2luT3JkZXIiLCJvYnNlcnZhYmlsaXR5TG9nc0lEIiwib2JzZXJ2YWJpbGl0eUxvZ3NUaXRsZSIsIm9ic2VydmFiaWxpdHlMb2dzUGx1Z2luT3JkZXIiLCJvYnNlcnZhYmlsaXR5TWV0cmljc0lEIiwib2JzZXJ2YWJpbGl0eU1ldHJpY3NUaXRsZSIsIm9ic2VydmFiaWxpdHlNZXRyaWNzUGx1Z2luT3JkZXIiLCJvYnNlcnZhYmlsaXR5VHJhY2VzSUQiLCJvYnNlcnZhYmlsaXR5VHJhY2VzVGl0bGUiLCJvYnNlcnZhYmlsaXR5VHJhY2VzUGx1Z2luT3JkZXIiLCJvYnNlcnZhYmlsaXR5Tm90ZWJvb2tJRCIsIm9ic2VydmFiaWxpdHlOb3RlYm9va1RpdGxlIiwib2JzZXJ2YWJpbGl0eU5vdGVib29rUGx1Z2luT3JkZXIiLCJvYnNlcnZhYmlsaXR5UGFuZWxzSUQiLCJvYnNlcnZhYmlsaXR5UGFuZWxzVGl0bGUiLCJvYnNlcnZhYmlsaXR5UGFuZWxzUGx1Z2luT3JkZXIiLCJvYnNlcnZhYmlsaXR5SW50ZWdyYXRpb25zSUQiLCJvYnNlcnZhYmlsaXR5SW50ZWdyYXRpb25zVGl0bGUiLCJvYnNlcnZhYmlsaXR5SW50ZWdyYXRpb25zUGx1Z2luT3JkZXIiLCJTUUxfRE9DVU1FTlRBVElPTl9VUkwiLCJQUExfRE9DVU1FTlRBVElPTl9VUkwiLCJQUExfUEFUVEVSTlNfRE9DVU1FTlRBVElPTl9VUkwiLCJVSV9EQVRFX0ZPUk1BVCIsIlBQTF9EQVRFX0ZPUk1BVCIsIlNQQU5fUkVHRVgiLCJQUExfU1BBTl9SRUdFWCIsIlBQTF9TVEFUU19SRUdFWCIsIlBQTF9JTkRFWF9JTlNFUlRfUE9JTlRfUkVHRVgiLCJQUExfSU5ERVhfUkVHRVgiLCJQUExfV0hFUkVfQ0xBVVNFX1JFR0VYIiwiUFBMX05FV0xJTkVfUkVHRVgiLCJCQVNFX09CU0VSVkFCSUxJVFlfVVJJIiwiQkFTRV9JTlRFR1JBVElPTlNfVVJJIiwiT1BFTlNFQVJDSF9QQU5FTFNfQVBJIiwiT0JKRUNUIiwiU0FWRURfT0JKRUNUIiwiUExPVExZX0NPTE9SIiwiTE9OR19DSEFSVF9DT0xPUiIsInBhZ2VTdHlsZXMiLCJmbG9hdCIsIndpZHRoIiwibWF4V2lkdGgiLCJWSVNfQ0hBUlRfVFlQRVMiLCJOVU1FUklDQUxfRklFTERTIiwiRU5BQkxFRF9WSVNfVFlQRVMiLCJCYXIiLCJIb3Jpem9udGFsQmFyIiwiTGluZSIsIlBpZSIsIkhlYXRNYXAiLCJUZXh0IiwiTElWRV9PUFRJT05TIiwibGFiZWwiLCJzdGFydFRpbWUiLCJkZWxheVRpbWUiLCJMSVZFX0VORF9USU1FIiwiREVGQVVMVF9DSEFSVF9TVFlMRVMiLCJEZWZhdWx0TW9kZUxpbmUiLCJJbnRlcnBvbGF0aW9uIiwiTGluZVdpZHRoIiwiRmlsbE9wYWNpdHkiLCJNYXJrZXJTaXplIiwiU2hvd0xlZ2VuZCIsIkxlZ2VuZFBvc2l0aW9uIiwiTGFiZWxBbmdsZSIsIkRlZmF1bHRTb3J0U2VjdG9ycyIsIkRlZmF1bHRNb2RlU2NhdHRlciIsIkZJTExPUEFDSVRZX0RJVl9GQUNUT1IiLCJTTElERVJfTUlOX1ZBTFVFIiwiU0xJREVSX01BWF9WQUxVRSIsIlNMSURFUl9TVEVQIiwiVEhSRVNIT0xEX0xJTkVfV0lEVEgiLCJUSFJFU0hPTERfTElORV9PUEFDSVRZIiwiTUFYX0JVQ0tFVF9MRU5HVEgiLCJCYXJPcmllbnRhdGlvbiIsIlBMT1RfTUFSR0lOIiwibCIsInIiLCJiIiwidCIsInBhZCIsIldBSVRJTkdfVElNRV9PTl9VU0VSX0FDVElPTlMiLCJWSVNVQUxJWkFUSU9OX0VSUk9SIiwiTk9fREFUQSIsIklOVkFMSURfREFUQSJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBSUE7QUFDTyxNQUFNQSxRQUFRLEdBQUcsVUFBakI7O0FBQ0EsTUFBTUMsVUFBVSxHQUFHLFNBQW5COztBQUNBLE1BQU1DLFFBQVEsR0FBRyxVQUFqQjs7QUFDQSxNQUFNQyxVQUFVLEdBQUcsU0FBbkI7O0FBQ0EsTUFBTUMsT0FBTyxHQUFHLGNBQWhCOztBQUNBLE1BQU1DLFdBQVcsR0FBRywwQkFBcEI7O0FBQ0EsTUFBTUMsa0JBQWtCLEdBQUcsb0JBQTNCOztBQUNBLE1BQU1DLGlCQUFpQixHQUFHLG1CQUExQjs7QUFDQSxNQUFNQyxlQUFlLEdBQUcsa0JBQXhCOztBQUNBLE1BQU1DLGFBQWEsR0FBRyxnQkFBdEI7O0FBQ0EsTUFBTUMsV0FBVyxHQUFHLFFBQXBCOztBQUNBLE1BQU1DLG1CQUFtQixHQUFHLE1BQTVCLEMsQ0FFUDs7O0FBQ08sTUFBTUMsWUFBWSxHQUFHLGdCQUFyQjs7QUFDQSxNQUFNQyxZQUFZLEdBQUcsZ0JBQXJCOztBQUNBLE1BQU1DLFlBQVksR0FBRyxnQkFBckI7O0FBRUEsTUFBTUMsZUFBZSxHQUFHLG9CQUF4Qjs7QUFDQSxNQUFNQyxrQkFBa0IsR0FBRyxlQUEzQjs7QUFDQSxNQUFNQyx3QkFBd0IsR0FBRyxJQUFqQzs7QUFFQSxNQUFNQywyQkFBMkIsR0FBRyw0QkFBcEM7O0FBQ0EsTUFBTUMsOEJBQThCLEdBQUcsY0FBdkM7O0FBQ0EsTUFBTUMsb0NBQW9DLEdBQUcsSUFBN0M7O0FBRUEsTUFBTUMsbUJBQW1CLEdBQUcsb0JBQTVCOztBQUNBLE1BQU1DLHNCQUFzQixHQUFHLE1BQS9COztBQUNBLE1BQU1DLDRCQUE0QixHQUFHLElBQXJDOztBQUVBLE1BQU1DLHNCQUFzQixHQUFHLHVCQUEvQjs7QUFDQSxNQUFNQyx5QkFBeUIsR0FBRyxTQUFsQzs7QUFDQSxNQUFNQywrQkFBK0IsR0FBRyxJQUF4Qzs7QUFFQSxNQUFNQyxxQkFBcUIsR0FBRyxzQkFBOUI7O0FBQ0EsTUFBTUMsd0JBQXdCLEdBQUcsUUFBakM7O0FBQ0EsTUFBTUMsOEJBQThCLEdBQUcsSUFBdkM7O0FBRUEsTUFBTUMsdUJBQXVCLEdBQUcseUJBQWhDOztBQUNBLE1BQU1DLDBCQUEwQixHQUFHLFdBQW5DOztBQUNBLE1BQU1DLGdDQUFnQyxHQUFHLElBQXpDOztBQUVBLE1BQU1DLHFCQUFxQixHQUFHLDBCQUE5Qjs7QUFDQSxNQUFNQyx3QkFBd0IsR0FBRyxZQUFqQzs7QUFDQSxNQUFNQyw4QkFBOEIsR0FBRyxJQUF2Qzs7QUFFQSxNQUFNQywyQkFBMkIsR0FBRyxjQUFwQzs7QUFDQSxNQUFNQyw4QkFBOEIsR0FBRyxjQUF2Qzs7QUFDQSxNQUFNQyxvQ0FBb0MsR0FBRyxJQUE3QyxDLENBRVA7OztBQUNPLE1BQU1DLHFCQUFxQixHQUFHLDhEQUE5Qjs7QUFDQSxNQUFNQyxxQkFBcUIsR0FDaEMsaUVBREs7O0FBRUEsTUFBTUMsOEJBQThCLEdBQ3pDLCtGQURLOztBQUVBLE1BQU1DLGNBQWMsR0FBRyxvQkFBdkI7O0FBQ0EsTUFBTUMsZUFBZSxHQUFHLDRCQUF4Qjs7QUFDQSxNQUFNQyxVQUFVLEdBQUcsTUFBbkI7O0FBQ0EsTUFBTUMsY0FBYyxHQUFHLFlBQXZCOztBQUNBLE1BQU1DLGVBQWUsR0FBRyxhQUF4Qjs7QUFDQSxNQUFNQyw0QkFBNEIsR0FBRyxtREFBckM7O0FBQ0EsTUFBTUMsZUFBZSxHQUFHLCtDQUF4Qjs7QUFDQSxNQUFNQyxzQkFBc0IsR0FBRyxjQUEvQjs7QUFDQSxNQUFNQyxpQkFBaUIsR0FBRyxVQUExQixDLENBRVA7OztBQUNBLE1BQU1DLHNCQUFzQixHQUFHLDBCQUEvQjtBQUNBLE1BQU1DLHFCQUFxQixHQUFHLHlCQUE5QixDLENBQXlEOztBQUNsRCxNQUFNQyxxQkFBcUIsR0FBRztBQUNuQ0MsRUFBQUEsTUFBTSxFQUFHLEdBQUVILHNCQUF1QjtBQURDLENBQTlCLEMsQ0FJUDs7O0FBQ08sTUFBTUksWUFBWSxHQUFHLFNBQXJCLEMsQ0FFUDs7O0FBQ08sTUFBTUMsWUFBWSxHQUFHLENBQzFCLFNBRDBCLEVBRTFCLFNBRjBCLEVBRzFCLFNBSDBCLEVBSTFCLFNBSjBCLEVBSzFCLFNBTDBCLEVBTTFCLFNBTjBCLEVBTzFCLFNBUDBCLEVBUTFCLFNBUjBCLEVBUzFCLFNBVDBCLEVBVTFCLFNBVjBCLENBQXJCOztBQWFBLE1BQU1DLGdCQUFnQixHQUFHRCxZQUFZLENBQUMsQ0FBRCxDQUFyQzs7QUFFQSxNQUFNRSxVQUEwQixHQUFHO0FBQ3hDQyxFQUFBQSxLQUFLLEVBQUUsTUFEaUM7QUFFeENDLEVBQUFBLEtBQUssRUFBRSxNQUZpQztBQUd4Q0MsRUFBQUEsUUFBUSxFQUFFO0FBSDhCLENBQW5DOztJQU1LQyxlOzs7V0FBQUEsZTtBQUFBQSxFQUFBQSxlO0FBQUFBLEVBQUFBLGU7QUFBQUEsRUFBQUEsZTtBQUFBQSxFQUFBQSxlO0FBQUFBLEVBQUFBLGU7QUFBQUEsRUFBQUEsZTtHQUFBQSxlLCtCQUFBQSxlOztBQVNMLE1BQU1DLGdCQUFnQixHQUFHLENBQUMsT0FBRCxFQUFVLFNBQVYsRUFBcUIsTUFBckIsRUFBNkIsT0FBN0IsRUFBc0MsUUFBdEMsQ0FBekI7O0FBRUEsTUFBTUMsaUJBQWlCLEdBQUcsQ0FDL0JGLGVBQWUsQ0FBQ0csR0FEZSxFQUUvQkgsZUFBZSxDQUFDSSxhQUZlLEVBRy9CSixlQUFlLENBQUNLLElBSGUsRUFJL0JMLGVBQWUsQ0FBQ00sR0FKZSxFQUsvQk4sZUFBZSxDQUFDTyxPQUxlLEVBTS9CUCxlQUFlLENBQUNRLElBTmUsQ0FBMUIsQyxDQVNQOzs7QUFDTyxNQUFNQyxZQUFZLEdBQUcsQ0FDMUI7QUFDRUMsRUFBQUEsS0FBSyxFQUFFLElBRFQ7QUFFRUMsRUFBQUEsU0FBUyxFQUFFLFFBRmI7QUFHRUMsRUFBQUEsU0FBUyxFQUFFO0FBSGIsQ0FEMEIsRUFNMUI7QUFDRUYsRUFBQUEsS0FBSyxFQUFFLEtBRFQ7QUFFRUMsRUFBQUEsU0FBUyxFQUFFLFNBRmI7QUFHRUMsRUFBQUEsU0FBUyxFQUFFO0FBSGIsQ0FOMEIsRUFXMUI7QUFDRUYsRUFBQUEsS0FBSyxFQUFFLEtBRFQ7QUFFRUMsRUFBQUEsU0FBUyxFQUFFLFNBRmI7QUFHRUMsRUFBQUEsU0FBUyxFQUFFO0FBSGIsQ0FYMEIsRUFnQjFCO0FBQ0VGLEVBQUFBLEtBQUssRUFBRSxJQURUO0FBRUVDLEVBQUFBLFNBQVMsRUFBRSxRQUZiO0FBR0VDLEVBQUFBLFNBQVMsRUFBRTtBQUhiLENBaEIwQixFQXFCMUI7QUFDRUYsRUFBQUEsS0FBSyxFQUFFLElBRFQ7QUFFRUMsRUFBQUEsU0FBUyxFQUFFLFFBRmI7QUFHRUMsRUFBQUEsU0FBUyxFQUFFLFFBQVE7QUFIckIsQ0FyQjBCLEVBMEIxQjtBQUNFRixFQUFBQSxLQUFLLEVBQUUsS0FEVDtBQUVFQyxFQUFBQSxTQUFTLEVBQUUsU0FGYjtBQUdFQyxFQUFBQSxTQUFTLEVBQUUsUUFBUTtBQUhyQixDQTFCMEIsRUErQjFCO0FBQ0VGLEVBQUFBLEtBQUssRUFBRSxLQURUO0FBRUVDLEVBQUFBLFNBQVMsRUFBRSxTQUZiO0FBR0VDLEVBQUFBLFNBQVMsRUFBRSxRQUFRO0FBSHJCLENBL0IwQixFQW9DMUI7QUFDRUYsRUFBQUEsS0FBSyxFQUFFLElBRFQ7QUFFRUMsRUFBQUEsU0FBUyxFQUFFLFFBRmI7QUFHRUMsRUFBQUEsU0FBUyxFQUFFLFFBQVE7QUFIckIsQ0FwQzBCLEVBeUMxQjtBQUNFRixFQUFBQSxLQUFLLEVBQUUsSUFEVDtBQUVFQyxFQUFBQSxTQUFTLEVBQUUsUUFGYjtBQUdFQyxFQUFBQSxTQUFTLEVBQUUsUUFBUTtBQUhyQixDQXpDMEIsQ0FBckI7O0FBZ0RBLE1BQU1DLGFBQWEsR0FBRyxLQUF0Qjs7QUFjQSxNQUFNQyxvQkFBNkMsR0FBRztBQUMzREMsRUFBQUEsZUFBZSxFQUFFLE9BRDBDO0FBRTNEQyxFQUFBQSxhQUFhLEVBQUUsUUFGNEM7QUFHM0RDLEVBQUFBLFNBQVMsRUFBRSxDQUhnRDtBQUkzREMsRUFBQUEsV0FBVyxFQUFFLEdBSjhDO0FBSzNEQyxFQUFBQSxVQUFVLEVBQUUsQ0FMK0M7QUFNM0RDLEVBQUFBLFVBQVUsRUFBRSxNQU4rQztBQU8zREMsRUFBQUEsY0FBYyxFQUFFLEdBUDJDO0FBUTNEQyxFQUFBQSxVQUFVLEVBQUUsQ0FSK0M7QUFTM0RDLEVBQUFBLGtCQUFrQixFQUFFLHFCQVR1QztBQVUzREMsRUFBQUEsa0JBQWtCLEVBQUU7QUFWdUMsQ0FBdEQ7O0FBYUEsTUFBTUMsc0JBQXNCLEdBQUcsR0FBL0I7O0FBQ0EsTUFBTUMsZ0JBQWdCLEdBQUcsQ0FBekI7O0FBQ0EsTUFBTUMsZ0JBQWdCLEdBQUcsR0FBekI7O0FBQ0EsTUFBTUMsV0FBVyxHQUFHLENBQXBCOztBQUNBLE1BQU1DLG9CQUFvQixHQUFHLENBQTdCOztBQUNBLE1BQU1DLHNCQUFzQixHQUFHLEdBQS9COztBQUNBLE1BQU1DLGlCQUFpQixHQUFHLEVBQTFCOztJQUVLQyxjOzs7V0FBQUEsYztBQUFBQSxFQUFBQSxjO0FBQUFBLEVBQUFBLGM7R0FBQUEsYyw4QkFBQUEsYzs7QUFLTCxNQUFNQyxXQUFXLEdBQUc7QUFDekJDLEVBQUFBLENBQUMsRUFBRSxFQURzQjtBQUV6QkMsRUFBQUEsQ0FBQyxFQUFFLENBRnNCO0FBR3pCQyxFQUFBQSxDQUFDLEVBQUUsRUFIc0I7QUFJekJDLEVBQUFBLENBQUMsRUFBRSxFQUpzQjtBQUt6QkMsRUFBQUEsR0FBRyxFQUFFO0FBTG9CLENBQXBCOztBQVFBLE1BQU1DLDRCQUE0QixHQUFHLEdBQXJDOztBQUVBLE1BQU1DLG1CQUFtQixHQUFHO0FBQ2pDQyxFQUFBQSxPQUFPLEVBQUUsZ0JBRHdCO0FBRWpDQyxFQUFBQSxZQUFZLEVBQUU7QUFGbUIsQ0FBNUIiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5pbXBvcnQgQ1NTIGZyb20gJ2Nzc3R5cGUnO1xuaW1wb3J0IHsgSUZpZWxkIH0gZnJvbSAnLi4vLi4vY29tbW9uL3R5cGVzL2V4cGxvcmVyJztcblxuLy8gQ2xpZW50IHJvdXRlXG5leHBvcnQgY29uc3QgUFBMX0JBU0UgPSAnL2FwaS9wcGwnO1xuZXhwb3J0IGNvbnN0IFBQTF9TRUFSQ0ggPSAnL3NlYXJjaCc7XG5leHBvcnQgY29uc3QgRFNMX0JBU0UgPSAnL2FwaS9kc2wnO1xuZXhwb3J0IGNvbnN0IERTTF9TRUFSQ0ggPSAnL3NlYXJjaCc7XG5leHBvcnQgY29uc3QgRFNMX0NBVCA9ICcvY2F0LmluZGljZXMnO1xuZXhwb3J0IGNvbnN0IERTTF9NQVBQSU5HID0gJy9pbmRpY2VzLmdldEZpZWxkTWFwcGluZyc7XG5leHBvcnQgY29uc3QgT0JTRVJWQUJJTElUWV9CQVNFID0gJy9hcGkvb2JzZXJ2YWJpbGl0eSc7XG5leHBvcnQgY29uc3QgSU5URUdSQVRJT05TX0JBU0UgPSAnL2FwaS9pbnRlZ3JhdGlvbnMnO1xuZXhwb3J0IGNvbnN0IEVWRU5UX0FOQUxZVElDUyA9ICcvZXZlbnRfYW5hbHl0aWNzJztcbmV4cG9ydCBjb25zdCBTQVZFRF9PQkpFQ1RTID0gJy9zYXZlZF9vYmplY3RzJztcbmV4cG9ydCBjb25zdCBTQVZFRF9RVUVSWSA9ICcvcXVlcnknO1xuZXhwb3J0IGNvbnN0IFNBVkVEX1ZJU1VBTElaQVRJT04gPSAnL3Zpcyc7XG5cbi8vIFNlcnZlciByb3V0ZVxuZXhwb3J0IGNvbnN0IFBQTF9FTkRQT0lOVCA9ICcvX3BsdWdpbnMvX3BwbCc7XG5leHBvcnQgY29uc3QgU1FMX0VORFBPSU5UID0gJy9fcGx1Z2lucy9fc3FsJztcbmV4cG9ydCBjb25zdCBEU0xfRU5EUE9JTlQgPSAnL19wbHVnaW5zL19kc2wnO1xuXG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eUlEID0gJ29ic2VydmFiaWxpdHktbG9ncyc7XG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eVRpdGxlID0gJ09ic2VydmFiaWxpdHknO1xuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlQbHVnaW5PcmRlciA9IDE1MDA7XG5cbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5QXBwbGljYXRpb25zSUQgPSAnb2JzZXJ2YWJpbGl0eS1hcHBsaWNhdGlvbnMnO1xuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlBcHBsaWNhdGlvbnNUaXRsZSA9ICdBcHBsaWNhdGlvbnMnO1xuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlBcHBsaWNhdGlvbnNQbHVnaW5PcmRlciA9IDUwOTA7XG5cbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5TG9nc0lEID0gJ29ic2VydmFiaWxpdHktbG9ncyc7XG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eUxvZ3NUaXRsZSA9ICdMb2dzJztcbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5TG9nc1BsdWdpbk9yZGVyID0gNTA5MTtcblxuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlNZXRyaWNzSUQgPSAnb2JzZXJ2YWJpbGl0eS1tZXRyaWNzJztcbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5TWV0cmljc1RpdGxlID0gJ01ldHJpY3MnO1xuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlNZXRyaWNzUGx1Z2luT3JkZXIgPSA1MDkyO1xuXG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eVRyYWNlc0lEID0gJ29ic2VydmFiaWxpdHktdHJhY2VzJztcbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5VHJhY2VzVGl0bGUgPSAnVHJhY2VzJztcbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5VHJhY2VzUGx1Z2luT3JkZXIgPSA1MDkzO1xuXG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eU5vdGVib29rSUQgPSAnb2JzZXJ2YWJpbGl0eS1ub3RlYm9va3MnO1xuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlOb3RlYm9va1RpdGxlID0gJ05vdGVib29rcyc7XG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eU5vdGVib29rUGx1Z2luT3JkZXIgPSA1MDk0O1xuXG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eVBhbmVsc0lEID0gJ29ic2VydmFiaWxpdHktZGFzaGJvYXJkcyc7XG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eVBhbmVsc1RpdGxlID0gJ0Rhc2hib2FyZHMnO1xuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlQYW5lbHNQbHVnaW5PcmRlciA9IDUwOTU7XG5cbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5SW50ZWdyYXRpb25zSUQgPSAnaW50ZWdyYXRpb25zJztcbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5SW50ZWdyYXRpb25zVGl0bGUgPSAnSW50ZWdyYXRpb25zJztcbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5SW50ZWdyYXRpb25zUGx1Z2luT3JkZXIgPSA5MDIwO1xuXG4vLyBTaGFyZWQgQ29uc3RhbnRzXG5leHBvcnQgY29uc3QgU1FMX0RPQ1VNRU5UQVRJT05fVVJMID0gJ2h0dHBzOi8vb3BlbnNlYXJjaC5vcmcvZG9jcy9sYXRlc3Qvc2VhcmNoLXBsdWdpbnMvc3FsL2luZGV4Lyc7XG5leHBvcnQgY29uc3QgUFBMX0RPQ1VNRU5UQVRJT05fVVJMID1cbiAgJ2h0dHBzOi8vb3BlbnNlYXJjaC5vcmcvZG9jcy9sYXRlc3Qvc2VhcmNoLXBsdWdpbnMvc3FsL3BwbC9pbmRleCc7XG5leHBvcnQgY29uc3QgUFBMX1BBVFRFUk5TX0RPQ1VNRU5UQVRJT05fVVJMID1cbiAgJ2h0dHBzOi8vZ2l0aHViLmNvbS9vcGVuc2VhcmNoLXByb2plY3Qvc3FsL2Jsb2IvMi54L2RvY3MvdXNlci9wcGwvY21kL3BhdHRlcm5zLnJzdCNkZXNjcmlwdGlvbic7XG5leHBvcnQgY29uc3QgVUlfREFURV9GT1JNQVQgPSAnTU0vREQvWVlZWSBoaDptbSBBJztcbmV4cG9ydCBjb25zdCBQUExfREFURV9GT1JNQVQgPSAnWVlZWS1NTS1ERCBISDptbTpzcy5TU1NTU1MnO1xuZXhwb3J0IGNvbnN0IFNQQU5fUkVHRVggPSAvc3Bhbi87XG5leHBvcnQgY29uc3QgUFBMX1NQQU5fUkVHRVggPSAvYnlcXHMqc3Bhbi9pO1xuZXhwb3J0IGNvbnN0IFBQTF9TVEFUU19SRUdFWCA9IC9cXHxcXHMqc3RhdHMvaTtcbmV4cG9ydCBjb25zdCBQUExfSU5ERVhfSU5TRVJUX1BPSU5UX1JFR0VYID0gLyhzZWFyY2ggc291cmNlfHNvdXJjZXxpbmRleClcXHMqPVxccyooW158XFxzXSspKC4qKS9pO1xuZXhwb3J0IGNvbnN0IFBQTF9JTkRFWF9SRUdFWCA9IC8oc2VhcmNoIHNvdXJjZXxzb3VyY2V8aW5kZXgpXFxzKj1cXHMqKFtefFxcc10rKS9pO1xuZXhwb3J0IGNvbnN0IFBQTF9XSEVSRV9DTEFVU0VfUkVHRVggPSAvXFxzKndoZXJlXFxzKy9pO1xuZXhwb3J0IGNvbnN0IFBQTF9ORVdMSU5FX1JFR0VYID0gL1tcXG5cXHJdKy9nO1xuXG4vLyBPYnNlcnZhYmlsaXR5IHBsdWdpbiBVUklcbmNvbnN0IEJBU0VfT0JTRVJWQUJJTElUWV9VUkkgPSAnL19wbHVnaW5zL19vYnNlcnZhYmlsaXR5JztcbmNvbnN0IEJBU0VfSU5URUdSQVRJT05TX1VSSSA9ICcvX3BsdWdpbnMvX2ludGVncmF0aW9ucyc7IC8vIFVzZWQgbGF0ZXIgaW4gZnJvbnQtZW5kIGZvciByb3V0aW5nXG5leHBvcnQgY29uc3QgT1BFTlNFQVJDSF9QQU5FTFNfQVBJID0ge1xuICBPQkpFQ1Q6IGAke0JBU0VfT0JTRVJWQUJJTElUWV9VUkl9L29iamVjdGAsXG59O1xuXG4vLyBTYXZlZCBPYmplY3RzXG5leHBvcnQgY29uc3QgU0FWRURfT0JKRUNUID0gJy9vYmplY3QnO1xuXG4vLyBDb2xvciBDb25zdGFudHNcbmV4cG9ydCBjb25zdCBQTE9UTFlfQ09MT1IgPSBbXG4gICcjM0NBMUM3JyxcbiAgJyM4QzU1QTMnLFxuICAnI0RCNzQ4QScsXG4gICcjRjJCRTRCJyxcbiAgJyM2OENDQzInLFxuICAnIzJBNzg2NicsXG4gICcjODQzNzY5JyxcbiAgJyMzNzRGQjgnLFxuICAnI0JENkYyNicsXG4gICcjNEM2MzZGJyxcbl07XG5cbmV4cG9ydCBjb25zdCBMT05HX0NIQVJUX0NPTE9SID0gUExPVExZX0NPTE9SWzFdO1xuXG5leHBvcnQgY29uc3QgcGFnZVN0eWxlczogQ1NTLlByb3BlcnRpZXMgPSB7XG4gIGZsb2F0OiAnbGVmdCcsXG4gIHdpZHRoOiAnMTAwJScsXG4gIG1heFdpZHRoOiAnMTEzMHB4Jyxcbn07XG5cbmV4cG9ydCBlbnVtIFZJU19DSEFSVF9UWVBFUyB7XG4gIEJhciA9ICdiYXInLFxuICBIb3Jpem9udGFsQmFyID0gJ2hvcml6b250YWxfYmFyJyxcbiAgTGluZSA9ICdsaW5lJyxcbiAgUGllID0gJ3BpZScsXG4gIEhlYXRNYXAgPSAnaGVhdG1hcCcsXG4gIFRleHQgPSAndGV4dCcsXG59XG5cbmV4cG9ydCBjb25zdCBOVU1FUklDQUxfRklFTERTID0gWydzaG9ydCcsICdpbnRlZ2VyJywgJ2xvbmcnLCAnZmxvYXQnLCAnZG91YmxlJ107XG5cbmV4cG9ydCBjb25zdCBFTkFCTEVEX1ZJU19UWVBFUyA9IFtcbiAgVklTX0NIQVJUX1RZUEVTLkJhcixcbiAgVklTX0NIQVJUX1RZUEVTLkhvcml6b250YWxCYXIsXG4gIFZJU19DSEFSVF9UWVBFUy5MaW5lLFxuICBWSVNfQ0hBUlRfVFlQRVMuUGllLFxuICBWSVNfQ0hBUlRfVFlQRVMuSGVhdE1hcCxcbiAgVklTX0NIQVJUX1RZUEVTLlRleHQsXG5dO1xuXG4vLyBMaXZlIHRhaWwgY29uc3RhbnRzXG5leHBvcnQgY29uc3QgTElWRV9PUFRJT05TID0gW1xuICB7XG4gICAgbGFiZWw6ICc1cycsXG4gICAgc3RhcnRUaW1lOiAnbm93LTVzJyxcbiAgICBkZWxheVRpbWU6IDUwMDAsXG4gIH0sXG4gIHtcbiAgICBsYWJlbDogJzEwcycsXG4gICAgc3RhcnRUaW1lOiAnbm93LTEwcycsXG4gICAgZGVsYXlUaW1lOiAxMDAwMCxcbiAgfSxcbiAge1xuICAgIGxhYmVsOiAnMzBzJyxcbiAgICBzdGFydFRpbWU6ICdub3ctMzBzJyxcbiAgICBkZWxheVRpbWU6IDMwMDAwLFxuICB9LFxuICB7XG4gICAgbGFiZWw6ICcxbScsXG4gICAgc3RhcnRUaW1lOiAnbm93LTFtJyxcbiAgICBkZWxheVRpbWU6IDYwMDAwLFxuICB9LFxuICB7XG4gICAgbGFiZWw6ICc1bScsXG4gICAgc3RhcnRUaW1lOiAnbm93LTVtJyxcbiAgICBkZWxheVRpbWU6IDYwMDAwICogNSxcbiAgfSxcbiAge1xuICAgIGxhYmVsOiAnMTVtJyxcbiAgICBzdGFydFRpbWU6ICdub3ctMTVtJyxcbiAgICBkZWxheVRpbWU6IDYwMDAwICogMTUsXG4gIH0sXG4gIHtcbiAgICBsYWJlbDogJzMwbScsXG4gICAgc3RhcnRUaW1lOiAnbm93LTMwbScsXG4gICAgZGVsYXlUaW1lOiA2MDAwMCAqIDMwLFxuICB9LFxuICB7XG4gICAgbGFiZWw6ICcxaCcsXG4gICAgc3RhcnRUaW1lOiAnbm93LTFoJyxcbiAgICBkZWxheVRpbWU6IDYwMDAwICogNjAsXG4gIH0sXG4gIHtcbiAgICBsYWJlbDogJzJoJyxcbiAgICBzdGFydFRpbWU6ICdub3ctMmgnLFxuICAgIGRlbGF5VGltZTogNjAwMDAgKiAxMjAsXG4gIH0sXG5dO1xuXG5leHBvcnQgY29uc3QgTElWRV9FTkRfVElNRSA9ICdub3cnO1xuZXhwb3J0IGludGVyZmFjZSBEZWZhdWx0Q2hhcnRTdHlsZXNQcm9wcyB7XG4gIERlZmF1bHRNb2RlTGluZTogc3RyaW5nO1xuICBJbnRlcnBvbGF0aW9uOiBzdHJpbmc7XG4gIExpbmVXaWR0aDogbnVtYmVyO1xuICBGaWxsT3BhY2l0eTogbnVtYmVyO1xuICBNYXJrZXJTaXplOiBudW1iZXI7XG4gIFNob3dMZWdlbmQ6IHN0cmluZztcbiAgTGVnZW5kUG9zaXRpb246IHN0cmluZztcbiAgTGFiZWxBbmdsZTogbnVtYmVyO1xuICBEZWZhdWx0U29ydFNlY3RvcnM6IHN0cmluZztcbiAgRGVmYXVsdE1vZGVTY2F0dGVyOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjb25zdCBERUZBVUxUX0NIQVJUX1NUWUxFUzogRGVmYXVsdENoYXJ0U3R5bGVzUHJvcHMgPSB7XG4gIERlZmF1bHRNb2RlTGluZTogJ2xpbmVzJyxcbiAgSW50ZXJwb2xhdGlvbjogJ3NwbGluZScsXG4gIExpbmVXaWR0aDogMCxcbiAgRmlsbE9wYWNpdHk6IDEwMCxcbiAgTWFya2VyU2l6ZTogNSxcbiAgU2hvd0xlZ2VuZDogJ3Nob3cnLFxuICBMZWdlbmRQb3NpdGlvbjogJ3YnLFxuICBMYWJlbEFuZ2xlOiAwLFxuICBEZWZhdWx0U29ydFNlY3RvcnM6ICdsYXJnZXN0X3RvX3NtYWxsZXN0JyxcbiAgRGVmYXVsdE1vZGVTY2F0dGVyOiAnbWFya2VycycsXG59O1xuXG5leHBvcnQgY29uc3QgRklMTE9QQUNJVFlfRElWX0ZBQ1RPUiA9IDIwMDtcbmV4cG9ydCBjb25zdCBTTElERVJfTUlOX1ZBTFVFID0gMDtcbmV4cG9ydCBjb25zdCBTTElERVJfTUFYX1ZBTFVFID0gMTAwO1xuZXhwb3J0IGNvbnN0IFNMSURFUl9TVEVQID0gMTtcbmV4cG9ydCBjb25zdCBUSFJFU0hPTERfTElORV9XSURUSCA9IDM7XG5leHBvcnQgY29uc3QgVEhSRVNIT0xEX0xJTkVfT1BBQ0lUWSA9IDAuNztcbmV4cG9ydCBjb25zdCBNQVhfQlVDS0VUX0xFTkdUSCA9IDE2O1xuXG5leHBvcnQgZW51bSBCYXJPcmllbnRhdGlvbiB7XG4gIGhvcml6b250YWwgPSAnaCcsXG4gIHZlcnRpY2FsID0gJ3YnLFxufVxuXG5leHBvcnQgY29uc3QgUExPVF9NQVJHSU4gPSB7XG4gIGw6IDMwLFxuICByOiA1LFxuICBiOiAzMCxcbiAgdDogNTAsXG4gIHBhZDogNCxcbn07XG5cbmV4cG9ydCBjb25zdCBXQUlUSU5HX1RJTUVfT05fVVNFUl9BQ1RJT05TID0gMzAwO1xuXG5leHBvcnQgY29uc3QgVklTVUFMSVpBVElPTl9FUlJPUiA9IHtcbiAgTk9fREFUQTogJ05vIGRhdGEgZm91bmQuJyxcbiAgSU5WQUxJRF9EQVRBOiAnSW52YWxpZCB2aXN1YWxpemF0aW9uIGRhdGEnLFxufTtcbiJdfQ==