# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class InvokableScriptsService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """InvokableScriptsService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def delete_scripts_id(self, script_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a script.

        Deletes a script and all associated records.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scripts_id(script_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str script_id: The ID of the script to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scripts_id_with_http_info(script_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scripts_id_with_http_info(script_id, **kwargs)  # noqa: E501
            return data

    def delete_scripts_id_with_http_info(self, script_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a script.

        Deletes a script and all associated records.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scripts_id_with_http_info(script_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str script_id: The ID of the script to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_scripts_id_prepare(script_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scripts/{scriptID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_scripts_id_async(self, script_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a script.

        Deletes a script and all associated records.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str script_id: The ID of the script to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        if not await self._is_cloud_instance_async():
            from influxdb_client.client.warnings import CloudOnlyWarning
            CloudOnlyWarning.print_warning('InvokableScriptsService',
                                           'https://docs.influxdata.com/influxdb/cloud/api-guide/api-invokable-scripts/')  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_scripts_id_prepare(script_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scripts/{scriptID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_scripts_id_prepare(self, script_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['script_id']  # noqa: E501
        self._check_operation_params('delete_scripts_id', all_params, local_var_params)
        # verify the required parameter 'script_id' is set
        if ('script_id' not in local_var_params or
                local_var_params['script_id'] is None):
            raise ValueError("Missing the required parameter `script_id` when calling `delete_scripts_id`")  # noqa: E501

        path_params = {}
        if 'script_id' in local_var_params:
            path_params['scriptID'] = local_var_params['script_id']  # noqa: E501

        query_params = []

        header_params = {}

        body_params = None
        return local_var_params, path_params, query_params, header_params, body_params

    def get_scripts(self, **kwargs):  # noqa: E501,D401,D403
        """List scripts.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scripts(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The number of scripts to return.
        :param int offset: The offset for pagination.
        :return: Scripts
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scripts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_scripts_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_scripts_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List scripts.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scripts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The number of scripts to return.
        :param int offset: The offset for pagination.
        :return: Scripts
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        if not self._is_cloud_instance():
            from influxdb_client.client.warnings import CloudOnlyWarning
            CloudOnlyWarning.print_warning('InvokableScriptsService',
                                           'https://docs.influxdata.com/influxdb/cloud/api-guide/api-invokable-scripts/')  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scripts_prepare(**kwargs)

        return self.api_client.call_api(
            '/api/v2/scripts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Scripts',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_scripts_async(self, **kwargs):  # noqa: E501,D401,D403
        """List scripts.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param int limit: The number of scripts to return.
        :param int offset: The offset for pagination.
        :return: Scripts
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        if not await self._is_cloud_instance_async():
            from influxdb_client.client.warnings import CloudOnlyWarning
            CloudOnlyWarning.print_warning('InvokableScriptsService',
                                           'https://docs.influxdata.com/influxdb/cloud/api-guide/api-invokable-scripts/')  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scripts_prepare(**kwargs)

        return await self.api_client.call_api(
            '/api/v2/scripts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Scripts',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_scripts_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['limit', 'offset']  # noqa: E501
        self._check_operation_params('get_scripts', all_params, local_var_params)

        path_params = {}

        query_params = []
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_scripts_id(self, script_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a script.

        Uses script ID to retrieve details of an invokable script.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scripts_id(script_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str script_id: The script ID. (required)
        :return: Script
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scripts_id_with_http_info(script_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scripts_id_with_http_info(script_id, **kwargs)  # noqa: E501
            return data

    def get_scripts_id_with_http_info(self, script_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a script.

        Uses script ID to retrieve details of an invokable script.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scripts_id_with_http_info(script_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str script_id: The script ID. (required)
        :return: Script
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        if not self._is_cloud_instance():
            from influxdb_client.client.warnings import CloudOnlyWarning
            CloudOnlyWarning.print_warning('InvokableScriptsService',
                                           'https://docs.influxdata.com/influxdb/cloud/api-guide/api-invokable-scripts/')  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scripts_id_prepare(script_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scripts/{scriptID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Script',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_scripts_id_async(self, script_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a script.

        Uses script ID to retrieve details of an invokable script.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str script_id: The script ID. (required)
        :return: Script
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        if not await self._is_cloud_instance_async():
            from influxdb_client.client.warnings import CloudOnlyWarning
            CloudOnlyWarning.print_warning('InvokableScriptsService',
                                           'https://docs.influxdata.com/influxdb/cloud/api-guide/api-invokable-scripts/')  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scripts_id_prepare(script_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scripts/{scriptID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Script',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_scripts_id_prepare(self, script_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['script_id']  # noqa: E501
        self._check_operation_params('get_scripts_id', all_params, local_var_params)
        # verify the required parameter 'script_id' is set
        if ('script_id' not in local_var_params or
                local_var_params['script_id'] is None):
            raise ValueError("Missing the required parameter `script_id` when calling `get_scripts_id`")  # noqa: E501

        path_params = {}
        if 'script_id' in local_var_params:
            path_params['scriptID'] = local_var_params['script_id']  # noqa: E501

        query_params = []

        header_params = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_scripts_id(self, script_id, script_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update a script.

        Updates properties (`name`, `description`, and `script`) of an invokable script.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_scripts_id(script_id, script_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str script_id: The script ID. (required)
        :param ScriptUpdateRequest script_update_request: Script update to apply (required)
        :return: Script
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_scripts_id_with_http_info(script_id, script_update_request, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_scripts_id_with_http_info(script_id, script_update_request, **kwargs)  # noqa: E501
            return data

    def patch_scripts_id_with_http_info(self, script_id, script_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update a script.

        Updates properties (`name`, `description`, and `script`) of an invokable script.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_scripts_id_with_http_info(script_id, script_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str script_id: The script ID. (required)
        :param ScriptUpdateRequest script_update_request: Script update to apply (required)
        :return: Script
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        if not self._is_cloud_instance():
            from influxdb_client.client.warnings import CloudOnlyWarning
            CloudOnlyWarning.print_warning('InvokableScriptsService',
                                           'https://docs.influxdata.com/influxdb/cloud/api-guide/api-invokable-scripts/')  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_scripts_id_prepare(script_id, script_update_request, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scripts/{scriptID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Script',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_scripts_id_async(self, script_id, script_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update a script.

        Updates properties (`name`, `description`, and `script`) of an invokable script.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str script_id: The script ID. (required)
        :param ScriptUpdateRequest script_update_request: Script update to apply (required)
        :return: Script
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        if not await self._is_cloud_instance_async():
            from influxdb_client.client.warnings import CloudOnlyWarning
            CloudOnlyWarning.print_warning('InvokableScriptsService',
                                           'https://docs.influxdata.com/influxdb/cloud/api-guide/api-invokable-scripts/')  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_scripts_id_prepare(script_id, script_update_request, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scripts/{scriptID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Script',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_scripts_id_prepare(self, script_id, script_update_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['script_id', 'script_update_request']  # noqa: E501
        self._check_operation_params('patch_scripts_id', all_params, local_var_params)
        # verify the required parameter 'script_id' is set
        if ('script_id' not in local_var_params or
                local_var_params['script_id'] is None):
            raise ValueError("Missing the required parameter `script_id` when calling `patch_scripts_id`")  # noqa: E501
        # verify the required parameter 'script_update_request' is set
        if ('script_update_request' not in local_var_params or
                local_var_params['script_update_request'] is None):
            raise ValueError("Missing the required parameter `script_update_request` when calling `patch_scripts_id`")  # noqa: E501

        path_params = {}
        if 'script_id' in local_var_params:
            path_params['scriptID'] = local_var_params['script_id']  # noqa: E501

        query_params = []

        header_params = {}

        body_params = None
        if 'script_update_request' in local_var_params:
            body_params = local_var_params['script_update_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_scripts(self, script_create_request, **kwargs):  # noqa: E501,D401,D403
        """Create a script.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scripts(script_create_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScriptCreateRequest script_create_request: The script to create. (required)
        :return: Script
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_scripts_with_http_info(script_create_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_scripts_with_http_info(script_create_request, **kwargs)  # noqa: E501
            return data

    def post_scripts_with_http_info(self, script_create_request, **kwargs):  # noqa: E501,D401,D403
        """Create a script.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scripts_with_http_info(script_create_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScriptCreateRequest script_create_request: The script to create. (required)
        :return: Script
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        if not self._is_cloud_instance():
            from influxdb_client.client.warnings import CloudOnlyWarning
            CloudOnlyWarning.print_warning('InvokableScriptsService',
                                           'https://docs.influxdata.com/influxdb/cloud/api-guide/api-invokable-scripts/')  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_scripts_prepare(script_create_request, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scripts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Script',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_scripts_async(self, script_create_request, **kwargs):  # noqa: E501,D401,D403
        """Create a script.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param ScriptCreateRequest script_create_request: The script to create. (required)
        :return: Script
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        if not await self._is_cloud_instance_async():
            from influxdb_client.client.warnings import CloudOnlyWarning
            CloudOnlyWarning.print_warning('InvokableScriptsService',
                                           'https://docs.influxdata.com/influxdb/cloud/api-guide/api-invokable-scripts/')  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_scripts_prepare(script_create_request, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scripts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Script',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_scripts_prepare(self, script_create_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['script_create_request']  # noqa: E501
        self._check_operation_params('post_scripts', all_params, local_var_params)
        # verify the required parameter 'script_create_request' is set
        if ('script_create_request' not in local_var_params or
                local_var_params['script_create_request'] is None):
            raise ValueError("Missing the required parameter `script_create_request` when calling `post_scripts`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}

        body_params = None
        if 'script_create_request' in local_var_params:
            body_params = local_var_params['script_create_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_scripts_id_invoke(self, script_id, **kwargs):  # noqa: E501,D401,D403
        """Invoke a script.

        Invokes a script and substitutes `params` keys referenced in the script with `params` key-values sent in the request body.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scripts_id_invoke(script_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str script_id: (required)
        :param ScriptInvocationParams script_invocation_params:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_scripts_id_invoke_with_http_info(script_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_scripts_id_invoke_with_http_info(script_id, **kwargs)  # noqa: E501
            return data

    def post_scripts_id_invoke_with_http_info(self, script_id, **kwargs):  # noqa: E501,D401,D403
        """Invoke a script.

        Invokes a script and substitutes `params` keys referenced in the script with `params` key-values sent in the request body.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scripts_id_invoke_with_http_info(script_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str script_id: (required)
        :param ScriptInvocationParams script_invocation_params:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        if not self._is_cloud_instance():
            from influxdb_client.client.warnings import CloudOnlyWarning
            CloudOnlyWarning.print_warning('InvokableScriptsService',
                                           'https://docs.influxdata.com/influxdb/cloud/api-guide/api-invokable-scripts/')  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_scripts_id_invoke_prepare(script_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scripts/{scriptID}/invoke', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='str',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_scripts_id_invoke_async(self, script_id, **kwargs):  # noqa: E501,D401,D403
        """Invoke a script.

        Invokes a script and substitutes `params` keys referenced in the script with `params` key-values sent in the request body.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str script_id: (required)
        :param ScriptInvocationParams script_invocation_params:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        if not await self._is_cloud_instance_async():
            from influxdb_client.client.warnings import CloudOnlyWarning
            CloudOnlyWarning.print_warning('InvokableScriptsService',
                                           'https://docs.influxdata.com/influxdb/cloud/api-guide/api-invokable-scripts/')  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_scripts_id_invoke_prepare(script_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scripts/{scriptID}/invoke', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='str',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_scripts_id_invoke_prepare(self, script_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['script_id', 'script_invocation_params']  # noqa: E501
        self._check_operation_params('post_scripts_id_invoke', all_params, local_var_params)
        # verify the required parameter 'script_id' is set
        if ('script_id' not in local_var_params or
                local_var_params['script_id'] is None):
            raise ValueError("Missing the required parameter `script_id` when calling `post_scripts_id_invoke`")  # noqa: E501

        path_params = {}
        if 'script_id' in local_var_params:
            path_params['scriptID'] = local_var_params['script_id']  # noqa: E501

        query_params = []

        header_params = {}

        body_params = None
        if 'script_invocation_params' in local_var_params:
            body_params = local_var_params['script_invocation_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
