/* packet-asap+enrp-common.h
 * Common routines for
 * Aggregate Server Access Protocol (ASAP) and
 * Endpoint Handlespace Redundancy Protocol (ENRP)
 * It is hopefully (needs testing) compliant to
 * RFC 5352
 * RFC 5354
 * RFC 5356
 * https://tools.ietf.org/html/draft-dreibholz-rserpool-asap-hropt-27
 * https://tools.ietf.org/html/draft-dreibholz-rserpool-delay-26
 * https://tools.ietf.org/html/draft-dreibholz-rserpool-enrp-takeover-21
 *
 * Copyright 2008-2021 Thomas Dreibholz <dreibh [AT] iem.uni-due.de>
 * Copyright 2004-2007 Michael Tüxen <tuexen [AT] fh-muenster.de>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * Copied from README.developer
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#ifndef __PACKET_ASAP_ENRP_COMMON_H__
#define __PACKET_ASAP_ENRP_COMMON_H__

#include <epan/packet.h>


#define UNRECOGNIZED_PARAMETER_CAUSE_CODE                  0x1
#define UNRECONGNIZED_MESSAGE_CAUSE_CODE                   0x2
#define INVALID_VALUES                                     0x3
#define NON_UNIQUE_PE_IDENTIFIER                           0x4
#define POOLING_POLICY_INCONSISTENT_CAUSE_CODE             0x5
#define LACK_OF_RESOURCES_CAUSE_CODE                       0x6
#define INCONSISTENT_TRANSPORT_TYPE_CAUSE_CODE             0x7
#define INCONSISTENT_DATA_CONTROL_CONFIGURATION_CAUSE_CODE 0x8
#define UNKNOWN_POOL_HANDLE                                0x9
#define REJECTION_DUE_TO_SECURITY_CAUSE_CODE               0xa

extern const value_string cause_code_values[];


#define ROUND_ROBIN_POLICY           0x00000001
#define WEIGHTED_ROUND_ROBIN_POLICY  0x00000002
#define RANDOM_POLICY                0x00000003
#define WEIGHTED_RANDOM_POLICY       0x00000004
#define PRIORITY_POLICY              0x00000005
#define LEAST_USED_POLICY            0x40000001
#define LEAST_USED_WITH_DEG_POLICY   0x40000002
#define PRIORITY_LEAST_USED_POLICY   0x40000003
#define RANDOMIZED_LEAST_USED_POLICY 0x40000004

#define PRIORITY_LEAST_USED_DEG_POLICY 0xb0001003
#define WEIGHTED_RANDOM_DPF_POLICY     0xb0002001
#define LEAST_USED_DPF_POLICY          0xb0002002

extern const value_string policy_type_values[];


#define TRANSPORT_USE_DATA_ONLY         0
#define TRANSPORT_USE_DATA_PLUS_CONTROL 1

extern const value_string transport_use_values[];


#define IPV4_ADDRESS_PARAMETER_TYPE                 0x01
#define IPV6_ADDRESS_PARAMETER_TYPE                 0x02
#define DCCP_TRANSPORT_PARAMETER_TYPE               0x03
#define SCTP_TRANSPORT_PARAMETER_TYPE               0x04
#define TCP_TRANSPORT_PARAMETER_TYPE                0x05
#define UDP_TRANSPORT_PARAMETER_TYPE                0x06
#define UDP_LITE_TRANSPORT_PARAMETER_TYPE           0x07
#define POOL_MEMBER_SELECTION_POLICY_PARAMETER_TYPE 0x08
#define POOL_HANDLE_PARAMETER_TYPE                  0x09
#define POOL_ELEMENT_PARAMETER_TYPE                 0x0a
#define SERVER_INFORMATION_PARAMETER_TYPE           0x0b
#define OPERATION_ERROR_PARAMETER_TYPE              0x0c
#define COOKIE_PARAMETER_TYPE                       0x0d
#define PE_IDENTIFIER_PARAMETER_TYPE                0x0e
#define PE_CHECKSUM_PARAMETER_TYPE                  0x0f
#define HANDLE_RESOLUTION_OPTION_PARAMETER_TYPE     0x803f

extern const value_string parameter_type_values[];


#define CAUSE_CODE_LENGTH   2
#define CAUSE_LENGTH_LENGTH 2
#define CAUSE_HEADER_LENGTH (CAUSE_CODE_LENGTH + CAUSE_LENGTH_LENGTH)

#define CAUSE_HEADER_OFFSET 0
#define CAUSE_CODE_OFFSET   CAUSE_HEADER_OFFSET
#define CAUSE_LENGTH_OFFSET (CAUSE_CODE_OFFSET + CAUSE_CODE_LENGTH)
#define CAUSE_INFO_OFFSET   (CAUSE_LENGTH_OFFSET + CAUSE_LENGTH_LENGTH)


#define PARAMETER_TYPE_LENGTH   2
#define PARAMETER_LENGTH_LENGTH 2
#define PARAMETER_HEADER_LENGTH (PARAMETER_TYPE_LENGTH + PARAMETER_LENGTH_LENGTH)

#define PARAMETER_HEADER_OFFSET 0
#define PARAMETER_TYPE_OFFSET   PARAMETER_HEADER_OFFSET
#define PARAMETER_LENGTH_OFFSET (PARAMETER_TYPE_OFFSET + PARAMETER_TYPE_LENGTH)
#define PARAMETER_VALUE_OFFSET  (PARAMETER_LENGTH_OFFSET + PARAMETER_LENGTH_LENGTH)

#define IPV4_ADDRESS_LENGTH 4
#define IPV4_ADDRESS_OFFSET PARAMETER_VALUE_OFFSET

#define IPV6_ADDRESS_LENGTH 16
#define IPV6_ADDRESS_OFFSET PARAMETER_VALUE_OFFSET

#define DCCP_PORT_LENGTH         2
#define DCCP_RESERVED_LENGTH     2
#define DCCP_SERVICE_CODE_LENGTH 4
#define DCCP_PORT_OFFSET         PARAMETER_VALUE_OFFSET
#define DCCP_RESERVED_OFFSET     (DCCP_PORT_OFFSET + DCCP_PORT_LENGTH)
#define DCCP_SERVICE_CODE_OFFSET (DCCP_RESERVED_OFFSET + DCCP_RESERVED_LENGTH)
#define DCCP_ADDRESS_OFFSET      (DCCP_SERVICE_CODE_OFFSET + DCCP_SERVICE_CODE_LENGTH)

#define SCTP_PORT_LENGTH          2
#define SCTP_TRANSPORT_USE_LENGTH 2
#define SCTP_PORT_OFFSET          PARAMETER_VALUE_OFFSET
#define SCTP_TRANSPORT_USE_OFFSET (SCTP_PORT_OFFSET + SCTP_PORT_LENGTH)
#define SCTP_ADDRESS_OFFSET       (SCTP_TRANSPORT_USE_OFFSET + SCTP_TRANSPORT_USE_LENGTH)

#define TCP_PORT_LENGTH          2
#define TCP_TRANSPORT_USE_LENGTH 2
#define TCP_PORT_OFFSET          PARAMETER_VALUE_OFFSET
#define TCP_TRANSPORT_USE_OFFSET (TCP_PORT_OFFSET + TCP_PORT_LENGTH)
#define TCP_ADDRESS_OFFSET       (TCP_TRANSPORT_USE_OFFSET + TCP_TRANSPORT_USE_LENGTH)

#define UDP_PORT_LENGTH     2
#define UDP_RESERVED_LENGTH 2
#define UDP_PORT_OFFSET     PARAMETER_VALUE_OFFSET
#define UDP_RESERVED_OFFSET (UDP_PORT_OFFSET + UDP_PORT_LENGTH)
#define UDP_ADDRESS_OFFSET  (UDP_RESERVED_OFFSET + UDP_RESERVED_LENGTH)

#define UDP_LITE_PORT_LENGTH     2
#define UDP_LITE_RESERVED_LENGTH 2
#define UDP_LITE_PORT_OFFSET     PARAMETER_VALUE_OFFSET
#define UDP_LITE_RESERVED_OFFSET (UDP_LITE_PORT_OFFSET + UDP_LITE_PORT_LENGTH)
#define UDP_LITE_ADDRESS_OFFSET  (UDP_LITE_RESERVED_OFFSET + UDP_LITE_RESERVED_LENGTH)


#define POLICY_TYPE_LENGTH               4
#define POLICY_WEIGHT_LENGTH             4
#define POLICY_PRIORITY_LENGTH           4
#define POLICY_LOAD_LENGTH               4
#define POLICY_DEGRADATION_LENGTH        4
#define POLICY_LUDPF_LOADDPF_LENGTH      4
#define POLICY_LUDPF_DISTANCE_LENGTH     4
#define POLICY_WRANDDPF_WEIGHTDPF_LENGTH 4
#define POLICY_WRANDDPF_DISTANCE_LENGTH  4

#define POLICY_TYPE_OFFSET        PARAMETER_VALUE_OFFSET
#define POLICY_VALUE_OFFSET       (POLICY_TYPE_OFFSET + POLICY_TYPE_LENGTH)
#define POLICY_WEIGHT_OFFSET      POLICY_VALUE_OFFSET
#define POLICY_PRIORITY_OFFSET    POLICY_VALUE_OFFSET
#define POLICY_LOAD_OFFSET        POLICY_VALUE_OFFSET
#define POLICY_DEGRADATION_OFFSET (POLICY_LOAD_OFFSET + POLICY_LOAD_LENGTH)

#define POLICY_LUDPF_LOADDPF_OFFSET      (POLICY_LOAD_OFFSET + POLICY_LOAD_LENGTH)
#define POLICY_LUDPF_DISTANCE_OFFSET     (POLICY_LUDPF_LOADDPF_OFFSET + POLICY_LUDPF_LOADDPF_LENGTH)
#define POLICY_WRANDDPF_WEIGHTDPF_OFFSET (POLICY_WEIGHT_OFFSET + POLICY_WEIGHT_LENGTH)
#define POLICY_WRANDDPF_DISTANCE_OFFSET  (POLICY_WRANDDPF_WEIGHTDPF_OFFSET + POLICY_WRANDDPF_WEIGHTDPF_LENGTH)


#define POOL_HANDLE_OFFSET PARAMETER_VALUE_OFFSET


#define PE_PE_IDENTIFIER_LENGTH         4
#define HOME_ENRP_INDENTIFIER_LENGTH    4
#define REGISTRATION_LIFE_LENGTH        4

#define PE_PE_IDENTIFIER_OFFSET         PARAMETER_VALUE_OFFSET
#define HOME_ENRP_INDENTIFIER_OFFSET    (PE_PE_IDENTIFIER_OFFSET + PE_PE_IDENTIFIER_LENGTH)
#define REGISTRATION_LIFE_OFFSET        (HOME_ENRP_INDENTIFIER_OFFSET + HOME_ENRP_INDENTIFIER_LENGTH)
#define USER_TRANSPORT_PARAMETER_OFFSET (REGISTRATION_LIFE_OFFSET + REGISTRATION_LIFE_LENGTH)


#define SERVER_ID_LENGTH         4
#define SERVER_ID_OFFSET         PARAMETER_VALUE_OFFSET
#define SERVER_TRANSPORT_OFFSET  (SERVER_ID_OFFSET + SERVER_ID_LENGTH)


#define PE_IDENTIFIER_LENGTH 4
#define PE_IDENTIFIER_OFFSET PARAMETER_VALUE_OFFSET


#define ERROR_CAUSES_OFFSET PARAMETER_VALUE_OFFSET


#define COOKIE_OFFSET PARAMETER_VALUE_OFFSET


#define PE_CHECKSUM_LENGTH 2

#define PE_CHECKSUM_OFFSET PARAMETER_VALUE_OFFSET


#define HROPT_ITEMS_LENGTH 4
#define HROPT_ITEMS_OFFSET PARAMETER_VALUE_OFFSET


#define MESSAGE_TYPE_LENGTH   1
#define MESSAGE_FLAGS_LENGTH  1
#define MESSAGE_LENGTH_LENGTH 2
#define MESSAGE_HEADER_LENGTH (MESSAGE_TYPE_LENGTH + MESSAGE_FLAGS_LENGTH + MESSAGE_LENGTH_LENGTH)

#define MESSAGE_TYPE_OFFSET   0
#define MESSAGE_FLAGS_OFFSET  (MESSAGE_TYPE_OFFSET   + MESSAGE_TYPE_LENGTH)
#define MESSAGE_LENGTH_OFFSET (MESSAGE_FLAGS_OFFSET  + MESSAGE_FLAGS_LENGTH)
#define MESSAGE_VALUE_OFFSET  (MESSAGE_LENGTH_OFFSET + MESSAGE_LENGTH_LENGTH)


#endif /* __PACKET_ASAP_ENRP_COMMON_H__ */
