/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.reporting;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EpubCheck;
import com.adobe.epubcheck.api.MasterReport;
import com.adobe.epubcheck.messages.Message;
import com.adobe.epubcheck.reporting.CheckMessage;
import com.adobe.epubcheck.reporting.CheckerMetadata;
import com.adobe.epubcheck.reporting.ItemMetadata;
import com.adobe.epubcheck.reporting.PublicationMetadata;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.JsonWriter;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.outWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class CheckingReport
extends MasterReport {
    @JsonProperty
    final CheckerMetadata checker;
    @JsonProperty
    final PublicationMetadata publication;
    Map<String, ItemMetadata> itemIndex = null;
    @JsonProperty
    List<ItemMetadata> items = null;
    @JsonProperty
    final List<CheckMessage> messages = new ArrayList<CheckMessage>();
    final PrintWriter out;

    public CheckingReport(PrintWriter out, String epubName) {
        this.checker = new CheckerMetadata();
        this.publication = new PublicationMetadata();
        this.out = out != null ? out : new PrintWriter(System.out);
        this.setEpubFileName(PathUtil.removeWorkingDirectory(epubName));
    }

    void setParameters() {
        this.checker.setCheckerVersion(EpubCheck.version());
        File f = new File(this.getEpubFileName());
        this.checker.setFileInfo(f);
        this.checker.setMessageTypes(this.messages);
        boolean defaultFixedFormat = this.publication.getRenditionLayout().equals("pre-paginated");
        for (ItemMetadata item : this.getItems()) {
            Boolean isFixed;
            String spread;
            String orientation;
            String id = item.getId();
            if (id == null || id.equals("")) {
                item.setId("ePubCheck.NoManifestRef:" + item.getFileName());
            }
            if (!item.getIsSpineItem()) continue;
            String layout = item.getRenditionLayout();
            if (layout == null || layout.equals("")) {
                item.setRenditionLayout(this.publication.getRenditionLayout());
            }
            if ((orientation = item.getRenditionOrientation()) == null || orientation.equals("")) {
                item.setRenditionOrientation(this.publication.getRenditionOrientation());
            }
            if ((spread = item.getRenditionSpread()) == null || spread.equals("")) {
                item.setRenditionSpread(this.publication.getRenditionSpread());
            }
            if ((isFixed = item.getIsFixedFormat()) != null) continue;
            item.setIsFixedFormat(defaultFixedFormat);
        }
    }

    @Override
    public int generate() {
        this.setStopDate();
        this.setParameters();
        try {
            this.getJsonReport();
        }
        catch (IOException e) {
            outWriter.println("Incorrect path to save JsonFile.");
            return 1;
        }
        return 0;
    }

    @Override
    public void initialize() {
        this.setStartDate();
    }

    void getJsonReport() throws IOException {
        this.sortCollections();
        try {
            JsonWriter jw = JsonWriter.createJsonWriter(true);
            jw.writeJson(this, this.out);
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
        }
    }

    void sortCollections() {
        Collections.sort(this.getItems());
        Collections.sort(this.messages);
        for (CheckMessage m : this.messages) {
            m.sortLocations();
        }
    }

    long getProcessDuration() {
        return this.checker.getProcessDuration();
    }

    void setStartDate() {
        this.checker.setStartDate();
    }

    void setStopDate() {
        this.checker.setStopDate();
    }

    @Override
    public void message(Message message, EPUBLocation location, Object ... args) {
        CheckMessage.addCheckMessage(this.messages, message, location, args);
    }

    @Override
    public void info(String resource, FeatureEnum feature, String value) {
        this.publication.handleInfo(resource, feature, value);
        if (resource != null && !resource.equals("")) {
            ItemMetadata item = ItemMetadata.getItemByName(this.getItemIndex(), resource);
            item.handleInfo(feature, value);
        }
    }

    List<ItemMetadata> getItems() {
        if (this.items == null) {
            this.items = this.itemIndex != null ? new ArrayList<ItemMetadata>(this.itemIndex.values()) : new ArrayList<ItemMetadata>();
        }
        return this.items;
    }

    Map<String, ItemMetadata> getItemIndex() {
        if (this.itemIndex == null) {
            this.itemIndex = new HashMap<String, ItemMetadata>();
            if (this.items != null && this.items.size() > 0) {
                for (ItemMetadata item : this.items) {
                    this.itemIndex.put(item.getFileName(), item);
                }
            }
        }
        return this.itemIndex;
    }
}

