/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml.model;

import com.adobe.epubcheck.xml.model.XMLAttribute;
import com.adobe.epubcheck.xml.model.XMLNode;
import java.util.HashMap;
import java.util.Map;

public class XMLElement
extends XMLNode {
    private final XMLAttribute[] attributes;
    private final XMLElement parent;
    private final Map<String, Object> privateData = new HashMap<String, Object>();

    public XMLElement(String namespace, String prefix, String name, XMLAttribute[] attributes, XMLElement parent) {
        super(namespace, prefix, name);
        this.attributes = attributes;
        this.parent = parent;
    }

    public int getAttributeCount() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.length;
    }

    public XMLAttribute getAttribute(int i) {
        return this.attributes[i];
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public String getAttributeNS(String ns, String name) {
        if (this.attributes == null) {
            return null;
        }
        for (XMLAttribute attr : this.attributes) {
            String ans = attr.getNamespace();
            if (!attr.getName().equals(name) || !(ans == null ? ns == null : ns != null && ans.equals(ns))) continue;
            return attr.getValue();
        }
        return null;
    }

    public String getAttribute(String attr) {
        return this.getAttributeNS(null, attr);
    }

    public final Object getPrivateData(String key) {
        return this.privateData.get(key);
    }

    public final Map<String, Object> getPrivateData() {
        return this.privateData;
    }

    public final void setPrivateData(String key, Object privateData) {
        if (key != null) {
            this.privateData.put(key, privateData);
        }
    }
}

