/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import java.awt.Point;
import java.util.logging.Logger;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.animation.Animation;
import net.sf.freecol.client.gui.animation.Animations;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Utils;

final class UnitMoveAnimation
extends Animation {
    private static final Logger logger = Logger.getLogger(UnitMoveAnimation.class.getName());
    private static final long ANIMATION_DELAY = 33L;
    private final int speed;
    private final float scale;

    public UnitMoveAnimation(Unit unit, Tile sourceTile, Tile destinationTile, int speed, float scale) {
        super(unit, CollectionUtils.makeUnmodifiableList(sourceTile, destinationTile));
        this.speed = speed;
        this.scale = scale;
    }

    @Override
    public void executeWithLabel(JLabel unitLabel, Animations.Procedure paintCallback) {
        int movementRatio = (int)(Math.pow(2.0, this.speed + 1) * (double)this.scale);
        double xratio = (double)ImageLibrary.TILE_SIZE.width / (double)ImageLibrary.TILE_SIZE.height;
        Point srcPoint = (Point)this.points.get(0);
        Point dstPoint = (Point)this.points.get(1);
        int stepX = (int)(Math.signum(dstPoint.getX() - srcPoint.getX()) * xratio * (double)movementRatio);
        int stepY = (int)(Math.signum(dstPoint.getY() - srcPoint.getY()) * (double)movementRatio);
        Point point = srcPoint;
        long time = Utils.now();
        long dropFrames = 0L;
        while (!point.equals(dstPoint)) {
            point.x += stepX;
            point.y += stepY;
            if (stepX < 0 && point.x < dstPoint.x || stepX > 0 && point.x > dstPoint.x) {
                point.x = dstPoint.x;
            }
            if (stepY < 0 && point.y < dstPoint.y || stepY > 0 && point.y > dstPoint.y) {
                point.y = dstPoint.y;
            }
            if (dropFrames <= 0L) {
                unitLabel.setLocation(point);
                paintCallback.execute();
                long newTime = Utils.now();
                long timeTaken = newTime - time;
                time = newTime;
                long waitTime = 33L - timeTaken;
                if (waitTime > 0L) {
                    Utils.delay(waitTime, "Animation interrupted.");
                    dropFrames = 0L;
                    continue;
                }
                dropFrames = timeTaken / 33L - 1L;
                continue;
            }
            --dropFrames;
        }
    }
}

